/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.httpcache4j.resolver;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.ProtocolVersion;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpOptions;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpTrace;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.scheme.PlainSocketFactory;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.conn.scheme.SocketFactory;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.entity.InputStreamEntity;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.conn.tsccm.ThreadSafeClientConnManager;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpParams;
import org.codehaus.httpcache4j.HTTPHost;
import org.codehaus.httpcache4j.HTTPMethod;
import org.codehaus.httpcache4j.HTTPRequest;
import org.codehaus.httpcache4j.HTTPResponse;
import org.codehaus.httpcache4j.HTTPVersion;
import org.codehaus.httpcache4j.Header;
import org.codehaus.httpcache4j.Headers;
import org.codehaus.httpcache4j.Status;
import org.codehaus.httpcache4j.StatusLine;
import org.codehaus.httpcache4j.auth.Authenticator;
import org.codehaus.httpcache4j.auth.DefaultAuthenticator;
import org.codehaus.httpcache4j.auth.DefaultProxyAuthenticator;
import org.codehaus.httpcache4j.auth.ProxyAuthenticator;
import org.codehaus.httpcache4j.auth.ProxyConfiguration;
import org.codehaus.httpcache4j.payload.DelegatingInputStream;
import org.codehaus.httpcache4j.payload.Payload;
import org.codehaus.httpcache4j.resolver.AbstractResponseResolver;
import org.codehaus.httpcache4j.resolver.ResolverConfiguration;

public class HTTPClientResponseResolver
extends AbstractResponseResolver {
    private HttpClient httpClient;

    public HTTPClientResponseResolver(HttpClient httpClient, ResolverConfiguration configuration) {
        super(configuration);
        this.httpClient = httpClient;
        HTTPHost proxyHost = this.getProxyAuthenticator().getConfiguration().getHost();
        HttpParams params = httpClient.getParams();
        if (params == null) {
            params = new BasicHttpParams();
            if (httpClient instanceof DefaultHttpClient) {
                ((DefaultHttpClient)httpClient).setParams(params);
            }
        }
        if (proxyHost != null) {
            HttpHost host = new HttpHost(proxyHost.getHost(), proxyHost.getPort(), proxyHost.getScheme());
            params.setParameter("http.route.default-proxy", (Object)host);
        }
        params.setParameter("http.useragent", (Object)this.getConfiguration().getUserAgent());
    }

    public HTTPClientResponseResolver(HttpClient httpClient, ProxyAuthenticator proxyAuthenticator, Authenticator authenticator) {
        this(httpClient, new ResolverConfiguration(proxyAuthenticator, authenticator));
    }

    public HTTPClientResponseResolver(HttpClient httpClient, ProxyConfiguration proxyConfiguration) {
        this(httpClient, (ProxyAuthenticator)new DefaultProxyAuthenticator(proxyConfiguration), (Authenticator)new DefaultAuthenticator());
    }

    public HTTPClientResponseResolver(HttpClient httpClient) {
        this(httpClient, new ProxyConfiguration());
    }

    public static HTTPClientResponseResolver createMultithreadedInstance() {
        SchemeRegistry schemeRegistry = new SchemeRegistry();
        schemeRegistry.register(new Scheme("http", (SocketFactory)PlainSocketFactory.getSocketFactory(), 80));
        schemeRegistry.register(new Scheme("https", (SocketFactory)SSLSocketFactory.getSocketFactory(), 443));
        ThreadSafeClientConnManager cm = new ThreadSafeClientConnManager((HttpParams)new BasicHttpParams(), schemeRegistry);
        return new HTTPClientResponseResolver((HttpClient)new DefaultHttpClient((ClientConnectionManager)cm, (HttpParams)new BasicHttpParams()));
    }

    protected HTTPResponse resolveImpl(HTTPRequest request) throws IOException {
        HttpUriRequest realRequest = this.convertRequest(request);
        HttpResponse response = this.httpClient.execute(realRequest);
        return this.convertResponse(realRequest, response);
    }

    public void shutdown() {
        this.httpClient.getConnectionManager().shutdown();
    }

    private HttpUriRequest convertRequest(HTTPRequest request) {
        HttpUriRequest realRequest = this.getMethod(request.getMethod(), request.getRequestURI());
        Headers headers = request.getAllHeaders();
        for (Header header : headers) {
            realRequest.addHeader(header.getName(), header.getValue());
        }
        if (request.hasPayload() && realRequest instanceof HttpEntityEnclosingRequest) {
            HttpEntityEnclosingRequest req = (HttpEntityEnclosingRequest)realRequest;
            req.setEntity((HttpEntity)new UnknownLengthInputStreamEntity(request.getPayload(), this.getConfiguration().isUseChunked()));
        }
        return realRequest;
    }

    protected HttpUriRequest getMethod(HTTPMethod method, URI requestURI) {
        if (HTTPMethod.DELETE.equals((Object)method)) {
            return new HttpDelete(requestURI);
        }
        if (HTTPMethod.GET.equals((Object)method)) {
            return new HttpGet(requestURI);
        }
        if (HTTPMethod.HEAD.equals((Object)method)) {
            return new HttpHead(requestURI);
        }
        if (HTTPMethod.OPTIONS.equals((Object)method)) {
            return new HttpOptions(requestURI);
        }
        if (HTTPMethod.POST.equals((Object)method)) {
            return new HttpPost(requestURI);
        }
        if (HTTPMethod.PUT.equals((Object)method)) {
            return new HttpPut(requestURI);
        }
        if (HTTPMethod.TRACE.equals((Object)method)) {
            return new HttpTrace(requestURI);
        }
        throw new IllegalArgumentException("Cannot handle method: " + method);
    }

    private HTTPResponse convertResponse(HttpUriRequest request, HttpResponse response) throws IOException {
        org.apache.http.Header[] realHeaders;
        Headers headers = new Headers();
        for (org.apache.http.Header header : realHeaders = response.getAllHeaders()) {
            headers = headers.add(header.getName(), header.getValue());
        }
        InputStream stream = this.getStream(request, response);
        ProtocolVersion protocolversion = response.getStatusLine().getProtocolVersion();
        StatusLine line = new StatusLine(HTTPVersion.get((String)(protocolversion.getMajor() + "." + protocolversion.getMinor())), Status.valueOf((int)response.getStatusLine().getStatusCode()), response.getStatusLine().getReasonPhrase());
        return this.getResponseCreator().createResponse(line, headers, stream);
    }

    private InputStream getStream(HttpUriRequest realRequest, HttpResponse response) throws IOException {
        HttpEntity entity = response.getEntity();
        if (entity == null) {
            return null;
        }
        try {
            return new HttpEntityInputStream(entity);
        }
        catch (IOException e) {
            realRequest.abort();
            throw e;
        }
        catch (RuntimeException e) {
            realRequest.abort();
            throw e;
        }
    }

    private static class UnknownLengthInputStreamEntity
    extends InputStreamEntity {
        public UnknownLengthInputStreamEntity(Payload payload, boolean chunked) {
            super(payload.getInputStream(), -1L);
            this.setContentType(payload.getMimeType().toString());
            this.setChunked(chunked);
        }
    }

    private static class HttpEntityInputStream
    extends DelegatingInputStream {
        private final HttpEntity entity;

        public HttpEntityInputStream(HttpEntity entity) throws IOException {
            super(entity.getContent());
            this.entity = entity;
        }

        public void close() throws IOException {
            this.entity.consumeContent();
        }
    }
}

