/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.httpcache4j.resolver;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.Validate;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.auth.AuthScheme;
import org.apache.http.auth.AuthenticationException;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpOptions;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpTrace;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.InputStreamEntity;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.impl.auth.DigestScheme;
import org.codehaus.httpcache4j.Challenge;
import org.codehaus.httpcache4j.ChallengeMethod;
import org.codehaus.httpcache4j.HTTPException;
import org.codehaus.httpcache4j.HTTPMethod;
import org.codehaus.httpcache4j.HTTPRequest;
import org.codehaus.httpcache4j.HTTPResponse;
import org.codehaus.httpcache4j.Header;
import org.codehaus.httpcache4j.Headers;
import org.codehaus.httpcache4j.Status;
import org.codehaus.httpcache4j.payload.DelegatingInputStream;
import org.codehaus.httpcache4j.resolver.AbstractResponseResolver;
import org.codehaus.httpcache4j.resolver.ResponseCreator;

public class HttpClientResponseResolver
extends AbstractResponseResolver {
    private HttpClient httpClient;
    private boolean useRequestChallenge;

    public HttpClientResponseResolver(HttpClient httpClient, ResponseCreator responseCreator) {
        super(responseCreator);
        Validate.notNull((Object)httpClient, (String)"HttpClient may not be null");
        this.httpClient = httpClient;
    }

    public HTTPResponse resolve(HTTPRequest request) throws IOException {
        HttpUriRequest realRequest = this.convertRequest(request);
        HttpResponse response = this.httpClient.execute(realRequest);
        return this.convertResponse(request, realRequest, response);
    }

    private HttpUriRequest convertRequest(HTTPRequest request) {
        HttpUriRequest realRequest = this.getMethod(request.getMethod(), request.getRequestURI());
        Headers headers = request.getAllHeaders();
        for (Map.Entry headerList : headers) {
            for (Header header : (List)headerList.getValue()) {
                realRequest.addHeader(header.getName(), header.getValue());
            }
        }
        if (this.useRequestChallenge && request.getChallenge() != null) {
            Challenge challenge = request.getChallenge();
            AuthScheme scheme = this.getScheme(challenge.getMethod());
            try {
                scheme.authenticate((Credentials)new UsernamePasswordCredentials(challenge.getIdentifier(), new String(challenge.getPassword())), (HttpRequest)realRequest);
            }
            catch (AuthenticationException e) {
                throw new HTTPException("Unable to authenticate from challenge" + challenge);
            }
        }
        if (request.hasPayload() && realRequest instanceof HttpEntityEnclosingRequest) {
            HttpEntityEnclosingRequest req = (HttpEntityEnclosingRequest)realRequest;
            req.setEntity((HttpEntity)new InputStreamEntity(request.getPayload().getInputStream(), -1L));
        }
        return realRequest;
    }

    private AuthScheme getScheme(ChallengeMethod method) {
        switch (method) {
            case BASIC: {
                return new BasicScheme();
            }
            case DIGEST: {
                return new DigestScheme();
            }
        }
        throw new HTTPException("Not supported authentication scheme");
    }

    HttpUriRequest getMethod(HTTPMethod method, URI requestURI) {
        switch (method) {
            case GET: {
                return new HttpGet(requestURI);
            }
            case HEAD: {
                return new HttpHead(requestURI);
            }
            case OPTIONS: {
                return new HttpOptions(requestURI);
            }
            case TRACE: {
                return new HttpTrace(requestURI);
            }
            case PUT: {
                return new HttpPut(requestURI);
            }
            case POST: {
                return new HttpPost(requestURI);
            }
            case DELETE: {
                return new HttpDelete(requestURI);
            }
        }
        throw new IllegalArgumentException("Uknown method");
    }

    private HTTPResponse convertResponse(HTTPRequest request, HttpUriRequest realRequest, HttpResponse response) throws IOException {
        org.apache.http.Header[] realHeaders;
        Status status = Status.valueOf((int)response.getStatusLine().getStatusCode());
        Headers headers = new Headers();
        for (org.apache.http.Header header : realHeaders = response.getAllHeaders()) {
            headers.add(header.getName(), header.getValue());
        }
        InputStream stream = this.getStream(realRequest, response);
        return this.getResponseCreator().createResponse(request, status, headers, stream);
    }

    private InputStream getStream(HttpUriRequest realRequest, HttpResponse response) throws IOException {
        HttpEntity entity = response.getEntity();
        if (entity == null) {
            return null;
        }
        try {
            return new HttpEntityInputStream(entity);
        }
        catch (IOException e) {
            realRequest.abort();
            throw e;
        }
        catch (RuntimeException e) {
            realRequest.abort();
            throw e;
        }
    }

    public void setUseRequestChallenge(boolean useRequestChallenge) {
        this.useRequestChallenge = useRequestChallenge;
    }

    private static class HttpEntityInputStream
    extends DelegatingInputStream {
        private final HttpEntity entity;

        public HttpEntityInputStream(HttpEntity entity) throws IOException {
            super(entity.getContent());
            this.entity = entity;
        }

        public void close() throws IOException {
            this.entity.consumeContent();
        }
    }
}

