/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.httpcache4j.cache;

import com.google.common.base.Preconditions;
import org.codehaus.httpcache4j.CacheControl;
import org.codehaus.httpcache4j.HTTPResponse;
import org.codehaus.httpcache4j.cache.CacheItem;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.joda.time.Seconds;

public class DefaultCacheItem
implements CacheItem {
    protected DateTime cachedTime;
    protected HTTPResponse response;
    protected int ttl;

    public DefaultCacheItem(HTTPResponse response) {
        this(response, new DateTime());
    }

    public DefaultCacheItem(HTTPResponse response, DateTime cachedTime) {
        this.response = (HTTPResponse)Preconditions.checkNotNull((Object)response, (Object)"Response may not be null");
        this.cachedTime = (DateTime)Preconditions.checkNotNull((Object)cachedTime, (Object)"CacheTime may not be null");
        this.ttl = DefaultCacheItem.getTTL(response, 0);
    }

    @Override
    public int getTTL() {
        return this.ttl;
    }

    @Override
    public boolean isStale(DateTime requestTime) {
        if (this.response.hasPayload() && !this.response.getPayload().isAvailable()) {
            return true;
        }
        return this.ttl - this.getAge(requestTime) <= 0;
    }

    @Override
    public int getAge(DateTime requestTime) {
        return Seconds.secondsBetween((ReadableInstant)this.cachedTime, (ReadableInstant)requestTime).getSeconds();
    }

    public static int getTTL(HTTPResponse response, int defaultTTLinSeconds) {
        DateTime date;
        DateTime expiryDate;
        int maxAge;
        CacheControl cc = response.getCacheControl();
        if (cc != null && (maxAge = cc.getMaxAge()) > 0) {
            return maxAge;
        }
        if (response.getExpires() != null && (expiryDate = response.getExpires()) != null && (date = response.getDate()) != null && date.isBefore((ReadableInstant)expiryDate)) {
            return Seconds.secondsBetween((ReadableInstant)date, (ReadableInstant)expiryDate).getSeconds();
        }
        return defaultTTLinSeconds;
    }

    @Override
    public DateTime getCachedTime() {
        return this.cachedTime;
    }

    @Override
    public HTTPResponse getResponse() {
        return this.response;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultCacheItem cacheItem = (DefaultCacheItem)o;
        if (this.cachedTime != null ? !this.cachedTime.equals((Object)cacheItem.cachedTime) : cacheItem.cachedTime != null) {
            return false;
        }
        return !(this.response != null ? !this.response.equals((Object)cacheItem.response) : cacheItem.response != null);
    }

    public int hashCode() {
        int result = this.cachedTime != null ? this.cachedTime.hashCode() : 0;
        result = 31 * result + (this.response != null ? this.response.hashCode() : 0);
        return result;
    }
}

