/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.httpcache4j.cache;

import java.io.File;
import java.io.Serializable;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang.Validate;
import org.codehaus.httpcache4j.cache.Key;
import org.codehaus.httpcache4j.util.StorageUtil;

class FileResolver
implements Serializable {
    private static final long serialVersionUID = 3986711605116911333L;
    private final File baseDirectory;

    public FileResolver(File baseDirectory) {
        Validate.notNull((Object)baseDirectory, (String)"Base directory may not be null");
        this.baseDirectory = baseDirectory;
    }

    public File getBaseDirectory() {
        return this.baseDirectory;
    }

    public File resolve(Key key) {
        String uriHex = DigestUtils.md5Hex((String)key.getURI().toString());
        String vary = key.getVary().isEmpty() ? "default" : DigestUtils.md5Hex((String)key.getVary().toString());
        File uriFolder = new File(this.baseDirectory, uriHex);
        StorageUtil.ensureDirectoryExists(uriFolder);
        return new File(uriFolder, vary);
    }
}

