/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.httpcache4j.payload;

import java.io.IOException;
import java.io.InputStream;
import java.util.Optional;
import java.util.function.Function;
import org.codehaus.httpcache4j.HTTPException;
import org.codehaus.httpcache4j.MIMEType;

public interface Payload {
    public MIMEType getMimeType();

    public InputStream getInputStream();

    public long length();

    public boolean isAvailable();

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    default public <A> Optional<A> transform(Function<InputStream, A> f) {
        try (InputStream is = this.getInputStream();){
            Optional<A> optional = Optional.ofNullable(f.apply(is));
            return optional;
        }
        catch (IOException e) {
            throw new HTTPException(e);
        }
    }
}

