/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.httpcache4j;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

public final class HTTPMethod
implements Comparable<HTTPMethod> {
    public static final HTTPMethod CONNECT = new HTTPMethod("CONNECT");
    public static final HTTPMethod DELETE = new HTTPMethod("DELETE", Idempotency.IDEMPOTENT, Safety.UNSAFE);
    public static final HTTPMethod GET = new HTTPMethod("GET", Idempotency.IDEMPOTENT, Safety.SAFE);
    public static final HTTPMethod HEAD = new HTTPMethod("HEAD", Idempotency.IDEMPOTENT, Safety.SAFE);
    public static final HTTPMethod OPTIONS = new HTTPMethod("OPTIONS", Idempotency.IDEMPOTENT, Safety.SAFE);
    public static final HTTPMethod PATCH = new HTTPMethod("PATCH");
    public static final HTTPMethod POST = new HTTPMethod("POST");
    public static final HTTPMethod PURGE = new HTTPMethod("PURGE");
    public static final HTTPMethod PUT = new HTTPMethod("PUT", Idempotency.IDEMPOTENT, Safety.UNSAFE);
    public static final HTTPMethod TRACE = new HTTPMethod("TRACE", Idempotency.IDEMPOTENT, Safety.SAFE);
    public static final Map<String, HTTPMethod> defaultMethods;
    private final String method;
    private final Idempotency idempotency;
    private final Safety safety;

    private HTTPMethod(String method) {
        this(method, Idempotency.NON_IDEMPOTENT, Safety.UNSAFE);
    }

    private HTTPMethod(String method, Idempotency idempotency, Safety safety) {
        this.method = method;
        this.idempotency = idempotency;
        this.safety = safety;
    }

    public String getMethod() {
        return this.method;
    }

    @Deprecated
    public String name() {
        return this.getMethod();
    }

    public String toString() {
        return this.method;
    }

    public static HTTPMethod[] values() {
        return defaultMethods.values().toArray(new HTTPMethod[defaultMethods.size()]);
    }

    public static HTTPMethod valueOf(String method) {
        if (method == null || method.isEmpty()) {
            throw new IllegalArgumentException("method may not be null or empty");
        }
        String uppercaseMethod = method.toUpperCase(Locale.ENGLISH);
        if (defaultMethods.containsKey(uppercaseMethod)) {
            return defaultMethods.get(uppercaseMethod);
        }
        return new HTTPMethod(uppercaseMethod);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HTTPMethod that = (HTTPMethod)o;
        return !(this.method != null ? !this.method.equalsIgnoreCase(that.method) : that.method != null);
    }

    @Override
    public int compareTo(HTTPMethod other) {
        return this.getMethod().compareToIgnoreCase(other.getMethod());
    }

    public int hashCode() {
        return this.method != null ? this.method.hashCode() : 0;
    }

    public boolean canHavePayload() {
        return this == POST || this == PUT || this == PATCH;
    }

    public boolean isSafe() {
        return this.safety == Safety.SAFE;
    }

    public boolean isCacheable() {
        return this == GET || this == HEAD;
    }

    public boolean isIdempotent() {
        return this.idempotency == Idempotency.IDEMPOTENT;
    }

    static {
        List<HTTPMethod> defaultMethodList = Arrays.asList(CONNECT, DELETE, GET, HEAD, OPTIONS, PATCH, POST, PURGE, PUT, TRACE);
        defaultMethods = Collections.unmodifiableMap(defaultMethodList.stream().collect(Collectors.toMap(m -> m.getMethod().toUpperCase(Locale.ENGLISH), Function.identity())));
    }

    public static enum Safety {
        SAFE,
        UNSAFE;

    }

    public static enum Idempotency {
        IDEMPOTENT,
        NON_IDEMPOTENT;

    }
}

