/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.httpcache4j;

import java.net.URI;
import java.net.URISyntaxException;

public final class HTTPHost {
    private final String scheme;
    private final String host;
    private final int port;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public HTTPHost(String scheme, String host, int port) {
        this.scheme = scheme;
        this.host = host;
        if (port == -1) {
            if (!"http".equals(scheme) && !"https".equals(scheme)) throw new IllegalArgumentException("Unknown scheme for host " + scheme);
            this.port = port;
            return;
        } else {
            this.port = port;
        }
    }

    public HTTPHost(String scheme, String host) {
        this(scheme, host, -1);
    }

    public HTTPHost(URI uri) {
        this(uri.getScheme(), uri.getHost(), uri.getPort());
    }

    public String getScheme() {
        return this.scheme;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public URI toURI() {
        try {
            return new URI(this.scheme, null, this.host, this.port, null, null, null);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Unable to create uri");
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HTTPHost httpHost = (HTTPHost)o;
        if (this.port != httpHost.port) {
            return false;
        }
        return !(this.host != null ? !this.host.equals(httpHost.host) : httpHost.host != null);
    }

    public int hashCode() {
        int result = this.host != null ? this.host.hashCode() : 0;
        result = 31 * result + this.port;
        return result;
    }

    public String toString() {
        return this.toURI().toString();
    }
}

