/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.httpcache4j.resolver;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.codehaus.httpcache4j.HTTPHost;

public class ConnectionConfiguration {
    private final Optional<Integer> timeout;
    private final Optional<Integer> socketTimeout;
    private final Optional<Integer> connectionRequestTimeout;
    private final Optional<Integer> defaultConnectionsPerHost;
    private final Optional<Integer> maxConnections;
    private final Map<HTTPHost, Integer> connectionsPerHost = new HashMap<HTTPHost, Integer>();

    public ConnectionConfiguration(Optional<Integer> timeout, Optional<Integer> socketTimeout, Optional<Integer> connectionRequestTimeout, Optional<Integer> defaultConnectionsPerHost, Optional<Integer> maxConnections, Map<HTTPHost, Integer> connectionsPerHost) {
        this.timeout = timeout;
        this.socketTimeout = socketTimeout;
        this.connectionRequestTimeout = connectionRequestTimeout;
        this.defaultConnectionsPerHost = defaultConnectionsPerHost;
        this.maxConnections = maxConnections;
        this.connectionsPerHost.putAll(connectionsPerHost);
    }

    public ConnectionConfiguration() {
        this(Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Collections.emptyMap());
    }

    public Optional<Integer> getTimeout() {
        return this.timeout;
    }

    public Optional<Integer> getSocketTimeout() {
        return this.socketTimeout;
    }

    public Optional<Integer> getConnectionRequestTimeout() {
        return this.connectionRequestTimeout;
    }

    public Optional<Integer> getDefaultConnectionsPerHost() {
        return this.defaultConnectionsPerHost;
    }

    public Optional<Integer> getMaxConnections() {
        return this.maxConnections;
    }

    public Map<HTTPHost, Integer> getConnectionsPerHost() {
        return this.connectionsPerHost;
    }

    public static class Builder {
        private Optional<Integer> timeout = Optional.empty();
        private Optional<Integer> socketTimeout = Optional.empty();
        private Optional<Integer> connectionRequestTimeout = Optional.empty();
        private Optional<Integer> defaultConnectionPerHost = Optional.empty();
        private Optional<Integer> maxConnections = Optional.empty();
        private final Map<HTTPHost, Integer> connectionsPerHost = new HashMap<HTTPHost, Integer>();

        public Builder setTimeout(int timeout) {
            this.timeout = Optional.of(timeout);
            return this;
        }

        public Builder setSocketTimeout(int socketTimeout) {
            this.socketTimeout = Optional.of(socketTimeout);
            return this;
        }

        public Builder setConnectionRequestTimeout(int connectionRequestTimeout) {
            this.connectionRequestTimeout = Optional.of(connectionRequestTimeout);
            return this;
        }

        public Builder setDefaultConnectionPerHost(int defaultConnectionPerHost) {
            this.defaultConnectionPerHost = Optional.of(defaultConnectionPerHost);
            return this;
        }

        public Builder setMaxConnections(int maxConnections) {
            this.maxConnections = Optional.of(maxConnections);
            return this;
        }

        public Builder add(HTTPHost host, int connections) {
            this.connectionsPerHost.put(host, connections);
            return this;
        }

        public ConnectionConfiguration build() {
            return new ConnectionConfiguration(this.timeout, this.socketTimeout, this.connectionRequestTimeout, this.defaultConnectionPerHost, this.maxConnections, this.connectionsPerHost);
        }
    }
}

