/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.httpcache4j;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.chrono.ChronoLocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.stream.Collectors;
import org.codehaus.httpcache4j.CacheControl;
import org.codehaus.httpcache4j.Header;
import org.codehaus.httpcache4j.Headers;
import org.codehaus.httpcache4j.LinkDirective;
import org.codehaus.httpcache4j.util.OptionalUtils;
import org.codehaus.httpcache4j.util.Preconditions;

public final class HeaderUtils {
    public static final String PATTERN_RFC1123 = "EEE, dd MMM yyyy HH:mm:ss 'GMT'";
    private static final String NO_CACHE_HEADER_VALUE = "no-cache";
    private static final Header VARY_ALL = new Header("Vary", "*");
    private static List<String> UNCACHEABLE_HEADERS = Arrays.asList("Set-Cookie", "Proxy-Authenticate", "WWW-Authenticate");

    private HeaderUtils() {
    }

    public static Optional<LocalDateTime> fromHttpDate(Header header) {
        if (header == null) {
            return null;
        }
        if ("0".equals(header.getValue().trim())) {
            return Optional.of(LocalDateTime.of(LocalDate.of(1970, 1, 1), LocalTime.of(0, 0, 0, 0)));
        }
        return HeaderUtils.parseGMTString(header.getValue());
    }

    public static Optional<LocalDateTime> parseGMTString(String value) {
        DateTimeFormatter formatter = HeaderUtils.getFormatter();
        try {
            return Optional.of(LocalDateTime.from(formatter.parse(value)));
        }
        catch (DateTimeParseException dateTimeParseException) {
            return Optional.empty();
        }
    }

    public static Header toHttpDate(String headerName, LocalDateTime time) {
        return new Header(headerName, HeaderUtils.toGMTString(time));
    }

    public static String toGMTString(LocalDateTime time) {
        DateTimeFormatter formatter = HeaderUtils.getFormatter();
        return formatter.format(time);
    }

    private static DateTimeFormatter getFormatter() {
        return DateTimeFormatter.ofPattern(PATTERN_RFC1123).withZone(ZoneId.of("UTC")).withLocale(Locale.US);
    }

    public static long getHeaderAsDate(Header header) {
        try {
            Optional<LocalDateTime> dateTime = HeaderUtils.fromHttpDate(header);
            if (dateTime.isPresent()) {
                return dateTime.get().toInstant(ZoneOffset.UTC).toEpochMilli();
            }
        }
        catch (Exception e) {
            return -1L;
        }
        return -1L;
    }

    static Headers cleanForCaching(Headers headers) {
        for (String headerName : UNCACHEABLE_HEADERS) {
            headers = headers.remove(headerName);
        }
        return headers;
    }

    public static boolean hasCacheableHeaders(Headers headers) {
        Optional<String> header;
        Optional<CacheControl> cc;
        if (headers.contains(VARY_ALL)) {
            return false;
        }
        if (headers.contains("Cache-Control") && OptionalUtils.exists(cc = headers.getCacheControl(), cc2 -> cc2.isNoCache() || cc2.isNoStore())) {
            return false;
        }
        if (headers.contains("Pragma") && OptionalUtils.exists(header = headers.getFirstHeaderValue("Pragma"), s -> s.contains(NO_CACHE_HEADER_VALUE))) {
            return false;
        }
        if (headers.contains("Expires")) {
            Optional<LocalDateTime> expires = headers.getExpires();
            Optional<LocalDateTime> date = headers.getDate();
            if (!expires.isPresent() || !date.isPresent()) {
                return false;
            }
            if (OptionalUtils.exists(expires, e -> e.isBefore((ChronoLocalDateTime)date.get())) || OptionalUtils.exists(expires, e -> e.isEqual((ChronoLocalDateTime)date.get()))) {
                return false;
            }
        }
        return true;
    }

    static String removeQuotes(String value) {
        if (value != null && value.startsWith("\"") && value.endsWith("\"")) {
            return value.substring(1, value.length() - 1);
        }
        return value;
    }

    public static Header toLinkHeader(List<LinkDirective> linkDirectives) {
        StringBuilder builder = new StringBuilder();
        for (LinkDirective linkDirective : linkDirectives) {
            if (builder.length() > 0) {
                builder.append(", ");
            }
            builder.append(linkDirective);
        }
        return new Header("Link", builder.toString());
    }

    public static List<LinkDirective> toLinkDirectives(Header header) {
        Preconditions.checkArgument(!"Link".equals(header.getName()), "This must be a \"Link\" header");
        return header.getDirectives().stream().filter(d -> d instanceof LinkDirective).map(d -> (LinkDirective)d).collect(Collectors.toList());
    }
}

