/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.httpcache4j;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.codehaus.httpcache4j.HeaderUtils;
import org.codehaus.httpcache4j.NameValue;
import org.codehaus.httpcache4j.Parameter;
import org.codehaus.httpcache4j.util.NumberUtils;

public class Directive
extends NameValue {
    private final List<Parameter> parameters;
    private Map<String, Parameter> parameterMap;

    public Directive(String name, String value) {
        this(name, HeaderUtils.removeQuotes(value), Collections.emptyList());
    }

    public Directive(String name, String value, List<Parameter> parameters) {
        super(name, HeaderUtils.removeQuotes(value));
        this.parameters = Objects.requireNonNull(parameters);
    }

    public List<Parameter> getParameters() {
        return this.parameters;
    }

    public int getValueAsInteger() {
        return NumberUtils.toInt(this.getValue(), -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Parameter getParameter(String name) {
        if (this.parameterMap == null) {
            Directive directive = this;
            synchronized (directive) {
                if (this.parameterMap == null) {
                    this.parameterMap = this.parameters.stream().collect(Collectors.toMap(NameValue::getName, Function.identity()));
                }
            }
        }
        return this.parameterMap.get(name);
    }

    public String getParameterValue(String name) {
        Parameter param = this.getParameter(name);
        if (param != null) {
            return param.getValue();
        }
        return null;
    }

    @Override
    public String toString() {
        String output = this.name;
        if (!this.value.isEmpty()) {
            output = output + "=" + this.value;
        }
        if (!this.parameters.isEmpty()) {
            output = output + "; " + this.parameters.stream().map(Parameter::toString).collect(Collectors.joining("; "));
        }
        return output;
    }
}

