/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.httpcache4j.auth.digest;

import java.net.URI;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.codehaus.httpcache4j.Directive;
import org.codehaus.httpcache4j.HTTPHost;
import org.codehaus.httpcache4j.auth.AuthScheme;
import org.codehaus.httpcache4j.auth.digest.Algorithm;

public class Digest {
    private final HTTPHost host;
    private final String nonce;
    private final List<URI> domain;
    private final String opaque;
    private final boolean stale;
    private final Algorithm algorithm;
    private final String qop;
    private final AuthScheme scheme;

    public Digest(HTTPHost host, AuthScheme scheme) {
        this.scheme = scheme;
        Directive directives = scheme.getDirective();
        this.host = host;
        this.nonce = directives.getParameterValue("nonce");
        this.domain = this.parseDomain(directives.getParameterValue("domain"));
        this.opaque = directives.getParameterValue("opaque");
        this.stale = Boolean.parseBoolean(directives.getParameterValue("stale"));
        this.algorithm = Algorithm.getAlgorithm(directives.getParameterValue("algorithm"));
        this.qop = directives.getParameterValue("qop");
    }

    private List<URI> parseDomain(String domain) {
        if (!Objects.toString(domain, "").isEmpty() && !"*".equals(domain)) {
            String[] strings = domain.split(" ");
            List uris = Arrays.asList(strings).stream().map(this::parseURI).collect(Collectors.toList());
            return Collections.unmodifiableList(uris);
        }
        return Collections.emptyList();
    }

    private URI parseURI(String string) {
        URI uri;
        if (string.startsWith("/")) {
            string = this.host.toURI().resolve(string).toString();
        }
        if (!(uri = URI.create(string)).isAbsolute() && uri.getHost() == null) {
            uri = this.host.toURI().resolve(uri);
        }
        return uri;
    }

    public String getNonce() {
        return this.nonce;
    }

    public List<URI> getDomain() {
        return this.domain;
    }

    public String getOpaque() {
        return this.opaque;
    }

    public boolean isStale() {
        return this.stale;
    }

    public Algorithm getAlgorithm() {
        return this.algorithm;
    }

    public String getQop() {
        return this.qop;
    }

    public AuthScheme getScheme() {
        return this.scheme;
    }

    public HTTPHost getHost() {
        return this.host;
    }

    public String toString() {
        return "Digest{host=" + this.host + ", nonce='" + this.nonce + '\'' + ", domain=" + this.domain + ", opaque='" + this.opaque + '\'' + ", stale=" + this.stale + ", algorithm=" + (Object)((Object)this.algorithm) + ", qop='" + this.qop + '\'' + '}';
    }
}

