/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.httpcache4j.resolver;

import java.io.InputStream;
import java.util.Optional;
import org.codehaus.httpcache4j.HTTPResponse;
import org.codehaus.httpcache4j.Headers;
import org.codehaus.httpcache4j.MIMEType;
import org.codehaus.httpcache4j.StatusLine;
import org.codehaus.httpcache4j.payload.InputStreamPayload;
import org.codehaus.httpcache4j.payload.Payload;

public final class ResponseCreator {
    public static HTTPResponse createResponse(StatusLine line, Headers responseHeaders, Optional<InputStream> stream) {
        Optional<String> contentLengthHeader = responseHeaders.getFirstHeaderValue("Content-Length");
        MIMEType type = responseHeaders.getContentType().orElse(MIMEType.APPLICATION_OCTET_STREAM);
        Optional<Long> length = responseHeaders.getContentLength();
        Optional<Payload> payload = stream.filter(is -> line.getStatus().isBodyContentAllowed()).map(is -> new InputStreamPayload((InputStream)is, type, length.orElse(-1L)));
        return new HTTPResponse(payload, line, responseHeaders);
    }
}

