/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.httpcache4j.preference;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import org.codehaus.httpcache4j.Directive;
import org.codehaus.httpcache4j.Directives;
import org.codehaus.httpcache4j.Header;
import org.codehaus.httpcache4j.MIMEType;
import org.codehaus.httpcache4j.preference.Charset;
import org.codehaus.httpcache4j.util.NumberUtils;

public class Preference<T> {
    private final T preference;
    private final double quality;
    public static Function<Locale, String> LocaleToString = new Function<Locale, String>(){

        public String apply(Locale input) {
            String language = input.getLanguage();
            if (input.getCountry() != null && !input.getCountry().trim().isEmpty()) {
                return language + "-" + input.getCountry().toLowerCase(Locale.ENGLISH);
            }
            return language;
        }
    };
    public static Function<String, Locale> LocaleParse = new Function<String, Locale>(){

        public Locale apply(String input) {
            String[] parts = input.split("-", 2);
            return new Locale(parts[0], parts.length == 2 ? parts[1].toUpperCase() : "");
        }
    };
    public static Function<Charset, String> CharsetToString = new Function<Charset, String>(){

        public String apply(Charset input) {
            return input.toString();
        }
    };
    public static Function<String, Charset> CharsetParse = new Function<String, Charset>(){

        public Charset apply(String input) {
            return new Charset(input);
        }
    };
    public static Function<String, MIMEType> MIMEParse = new Function<String, MIMEType>(){

        public MIMEType apply(String input) {
            return MIMEType.valueOf(input);
        }
    };

    public Preference(T preference) {
        this(preference, 1.0);
    }

    public Preference(T preference, double quality) {
        Preconditions.checkNotNull(preference, (Object)"Preference may not be null, use a ALL preference instead.");
        Preconditions.checkArgument((quality <= 1.0 && quality > 0.0 ? 1 : 0) != 0, (Object)"Quality is a percentage ranging from 0.0, to 1.0");
        this.preference = preference;
        this.quality = quality;
    }

    public T getPreference() {
        return this.preference;
    }

    public double getQuality() {
        return this.quality;
    }

    public String toString() {
        StringBuilder headerValue = new StringBuilder();
        if (this.getQuality() != 1.0) {
            headerValue.append(this.getStringValue()).append(";q=").append(this.getQuality());
        } else {
            headerValue.append(this.getStringValue());
        }
        return headerValue.toString();
    }

    protected String getStringValue() {
        return this.getPreference().toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Preference that = (Preference)o;
        return !(this.preference != null ? !this.preference.equals(that.preference) : that.preference != null);
    }

    public int hashCode() {
        return this.preference != null ? this.preference.hashCode() : 0;
    }

    public static <T> List<Preference<T>> wrap(T ... values) {
        return Lists.transform(Arrays.asList(values), (Function)new Function<T, Preference<T>>(){

            public Preference<T> apply(T input) {
                return new Preference(input);
            }
        });
    }

    public static <T> Function<T, String> toStringF() {
        return new Function<T, String>(){

            public String apply(T input) {
                return input.toString();
            }
        };
    }

    public static <T> Header toHeader(String headerName, List<? extends Preference<T>> preferences, Function<T, String> f) {
        ArrayList<Preference<T>> pref = new ArrayList<Preference<T>>(preferences);
        Collections.sort(pref, new PreferenceComparator());
        StringBuilder builder = new StringBuilder();
        for (Preference<T> preference : pref) {
            if (builder.length() > 0) {
                builder.append(", ");
            }
            builder.append((String)f.apply(preference.getPreference()));
            if (preference.getQuality() == 1.0) continue;
            builder.append(";q=").append(preference.getQuality());
        }
        return new Header(headerName, builder.toString());
    }

    public static <T> List<Preference<T>> parse(Header header, Function<String, T> f) {
        ArrayList<Preference<Object>> accept = new ArrayList<Preference<Object>>();
        Directives directives = header.getDirectives();
        for (Directive directive : directives) {
            String loc = directive.getName();
            Object value = f.apply((Object)loc);
            if (value == null) {
                throw new IllegalArgumentException("Transformation turned value to null");
            }
            double quality = NumberUtils.toDouble(directive.getParameterValue("q"), 1.0);
            accept.add(new Preference<Object>(value, quality));
        }
        Collections.sort(accept, new PreferenceComparator());
        return Collections.unmodifiableList(accept);
    }

    public static class PreferenceComparator<T>
    implements Comparator<Preference<T>> {
        @Override
        public int compare(Preference<T> o1, Preference<T> o2) {
            return Double.compare(o2.getQuality(), o1.getQuality());
        }
    }
}

