/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.httpcache4j.payload;

import com.google.common.io.ByteStreams;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import org.codehaus.httpcache4j.MIMEType;
import org.codehaus.httpcache4j.payload.Payload;
import org.codehaus.httpcache4j.util.IOUtils;

public class ByteArrayPayload
implements Payload,
Serializable {
    private static final long serialVersionUID = -4845254892809632007L;
    private final byte[] bytes;
    private final MIMEType type;
    private final long length;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ByteArrayPayload(InputStream stream, MIMEType type) throws IOException {
        try {
            this.bytes = ByteStreams.toByteArray((InputStream)stream);
        }
        finally {
            IOUtils.closeQuietly(stream);
        }
        this.length = this.bytes.length;
        this.type = type;
    }

    @Override
    public MIMEType getMimeType() {
        return this.type;
    }

    @Override
    public InputStream getInputStream() {
        return new ByteArrayInputStream(this.bytes);
    }

    @Override
    public long length() {
        return this.length;
    }

    @Override
    public boolean isAvailable() {
        return this.bytes != null && this.bytes.length > 0;
    }
}

