/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.httpcache4j;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import java.io.InputStream;
import java.net.URI;
import java.util.List;
import java.util.Set;
import org.codehaus.httpcache4j.CacheControl;
import org.codehaus.httpcache4j.CacheHeaderBuilder;
import org.codehaus.httpcache4j.HTTPMethod;
import org.codehaus.httpcache4j.Header;
import org.codehaus.httpcache4j.Headers;
import org.codehaus.httpcache4j.Status;
import org.codehaus.httpcache4j.StatusLine;
import org.codehaus.httpcache4j.Tag;
import org.codehaus.httpcache4j.payload.InputStreamPayload;
import org.codehaus.httpcache4j.payload.Payload;
import org.codehaus.httpcache4j.util.IOUtils;
import org.joda.time.DateTime;

public final class HTTPResponse {
    private final StatusLine statusLine;
    private final Payload payload;
    private final Headers headers;
    private final DateTime date;
    private final DateTime expires;
    private final DateTime lastModified;
    private final Tag etag;
    private final Set<HTTPMethod> allowedMethods;
    private final CacheControl cacheControl;
    private final boolean cached;
    private final URI location;
    private final URI contentLocation;

    public HTTPResponse(Payload payload, Status status, Headers headers) {
        this(payload, new StatusLine(status), headers);
    }

    public HTTPResponse(Payload payload, StatusLine statusLine, Headers headers) {
        this.statusLine = (StatusLine)Preconditions.checkNotNull((Object)statusLine, (Object)"You must supply a Status");
        this.payload = payload;
        this.headers = (Headers)Preconditions.checkNotNull((Object)headers, (Object)"You must supply some Headers");
        this.etag = headers.getETag();
        this.lastModified = headers.getLastModified();
        this.allowedMethods = headers.getAllow();
        this.cacheControl = headers.getCacheControl();
        this.date = headers.getDate();
        this.expires = headers.getExpires();
        this.location = headers.getLocation();
        this.contentLocation = headers.getContentLocation();
        if (headers.contains("X-Cache")) {
            Header cacheHeader = CacheHeaderBuilder.getBuilder().createHITXCacheHeader();
            List<Header> xcacheHeaders = headers.getHeaders("X-Cache");
            this.cached = xcacheHeaders.contains(cacheHeader);
        } else {
            this.cached = false;
        }
    }

    public HTTPResponse withHeaders(Headers headers) {
        return new HTTPResponse(this.payload, this.statusLine, headers);
    }

    public HTTPResponse withPayload(Payload payload) {
        return new HTTPResponse(payload, this.statusLine, this.headers);
    }

    public boolean hasPayload() {
        return this.payload != null;
    }

    public Status getStatus() {
        return this.statusLine.getStatus();
    }

    public StatusLine getStatusLine() {
        return this.statusLine;
    }

    public Payload getPayload() {
        return this.payload;
    }

    public Headers getHeaders() {
        return this.headers;
    }

    public Tag getETag() {
        return this.etag;
    }

    public DateTime getDate() {
        return this.date;
    }

    public DateTime getExpires() {
        return this.expires;
    }

    public DateTime getLastModified() {
        return this.lastModified;
    }

    public CacheControl getCacheControl() {
        return this.cacheControl;
    }

    public URI getLocation() {
        return this.location;
    }

    public URI getContentLocation() {
        return this.contentLocation;
    }

    public boolean isCached() {
        return this.cached;
    }

    public Set<HTTPMethod> getAllowedMethods() {
        return this.allowedMethods;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <A> Optional<A> transform(Function<Payload, A> f) {
        if (this.hasPayload()) {
            InputStream is = this.payload.getInputStream();
            try {
                InputStreamPayload isp = new InputStreamPayload(is, this.payload.getMimeType(), this.payload.length());
                Optional optional = Optional.fromNullable((Object)f.apply((Object)isp));
                return optional;
            }
            finally {
                IOUtils.closeQuietly(is);
            }
        }
        return Optional.absent();
    }

    public void consume() {
        if (this.hasPayload()) {
            IOUtils.closeQuietly(this.payload.getInputStream());
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HTTPResponse response = (HTTPResponse)o;
        if (this.headers != null ? !this.headers.equals(response.headers) : response.headers != null) {
            return false;
        }
        if (this.payload != null ? !this.payload.equals(response.payload) : response.payload != null) {
            return false;
        }
        return this.statusLine == response.statusLine;
    }

    public int hashCode() {
        int result = this.statusLine != null ? this.statusLine.hashCode() : 0;
        result = 31 * result + (this.payload != null ? this.payload.hashCode() : 0);
        result = 31 * result + (this.headers != null ? this.headers.hashCode() : 0);
        return result;
    }
}

