/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.httpcache4j.util;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.codehaus.httpcache4j.AuthDirective;
import org.codehaus.httpcache4j.Directive;
import org.codehaus.httpcache4j.Directives;
import org.codehaus.httpcache4j.Parameter;
import org.codehaus.httpcache4j.util.DirectivesParser;

public final class AuthDirectivesParser {
    private static final String TOKEN = "[\\!\\#\\$\\%\\&\\'\\*\\+\\-\\.\\^\\_\\`\\|\\~a-zA-Z0-9]+";
    private static final String B64 = "([a-zA-Z0-9\\-\\.\\_\\~\\+\\/]+\\=*)";
    private static final String PARAM = "[\\!\\#\\$\\%\\&\\'\\*\\+\\-\\.\\^\\_\\`\\|\\~a-zA-Z0-9]+\\s*=\\s*(?:(?:\"(?:(?:\\Q\\\"\\E)|[^\"])*\")|(?:[\\!\\#\\$\\%\\&\\'\\*\\+\\-\\.\\^\\_\\`\\|\\~a-zA-Z0-9]+))";
    private static final String PARAMS = "\\s*,?\\s*([\\!\\#\\$\\%\\&\\'\\*\\+\\-\\.\\^\\_\\`\\|\\~a-zA-Z0-9]+\\s*=\\s*(?:(?:\"(?:(?:\\Q\\\"\\E)|[^\"])*\")|(?:[\\!\\#\\$\\%\\&\\'\\*\\+\\-\\.\\^\\_\\`\\|\\~a-zA-Z0-9]+))(?:\\s*,\\s*(?:[\\!\\#\\$\\%\\&\\'\\*\\+\\-\\.\\^\\_\\`\\|\\~a-zA-Z0-9]+\\s*=\\s*(?:(?:\"(?:(?:\\Q\\\"\\E)|[^\"])*\")|(?:[\\!\\#\\$\\%\\&\\'\\*\\+\\-\\.\\^\\_\\`\\|\\~a-zA-Z0-9]+)))?)*)";
    private static final String B64orPARAM = "(?:\\s*,?\\s*([\\!\\#\\$\\%\\&\\'\\*\\+\\-\\.\\^\\_\\`\\|\\~a-zA-Z0-9]+\\s*=\\s*(?:(?:\"(?:(?:\\Q\\\"\\E)|[^\"])*\")|(?:[\\!\\#\\$\\%\\&\\'\\*\\+\\-\\.\\^\\_\\`\\|\\~a-zA-Z0-9]+))(?:\\s*,\\s*(?:[\\!\\#\\$\\%\\&\\'\\*\\+\\-\\.\\^\\_\\`\\|\\~a-zA-Z0-9]+\\s*=\\s*(?:(?:\"(?:(?:\\Q\\\"\\E)|[^\"])*\")|(?:[\\!\\#\\$\\%\\&\\'\\*\\+\\-\\.\\^\\_\\`\\|\\~a-zA-Z0-9]+)))?)*)|([a-zA-Z0-9\\-\\.\\_\\~\\+\\/]+\\=*))";
    private static final String PATTERN = "([\\!\\#\\$\\%\\&\\'\\*\\+\\-\\.\\^\\_\\`\\|\\~a-zA-Z0-9]+)(?:\\s*(?:\\s*,?\\s*([\\!\\#\\$\\%\\&\\'\\*\\+\\-\\.\\^\\_\\`\\|\\~a-zA-Z0-9]+\\s*=\\s*(?:(?:\"(?:(?:\\Q\\\"\\E)|[^\"])*\")|(?:[\\!\\#\\$\\%\\&\\'\\*\\+\\-\\.\\^\\_\\`\\|\\~a-zA-Z0-9]+))(?:\\s*,\\s*(?:[\\!\\#\\$\\%\\&\\'\\*\\+\\-\\.\\^\\_\\`\\|\\~a-zA-Z0-9]+\\s*=\\s*(?:(?:\"(?:(?:\\Q\\\"\\E)|[^\"])*\")|(?:[\\!\\#\\$\\%\\&\\'\\*\\+\\-\\.\\^\\_\\`\\|\\~a-zA-Z0-9]+)))?)*)|([a-zA-Z0-9\\-\\.\\_\\~\\+\\/]+\\=*)))?";
    private static final Pattern pattern = Pattern.compile("([\\!\\#\\$\\%\\&\\'\\*\\+\\-\\.\\^\\_\\`\\|\\~a-zA-Z0-9]+)(?:\\s*(?:\\s*,?\\s*([\\!\\#\\$\\%\\&\\'\\*\\+\\-\\.\\^\\_\\`\\|\\~a-zA-Z0-9]+\\s*=\\s*(?:(?:\"(?:(?:\\Q\\\"\\E)|[^\"])*\")|(?:[\\!\\#\\$\\%\\&\\'\\*\\+\\-\\.\\^\\_\\`\\|\\~a-zA-Z0-9]+))(?:\\s*,\\s*(?:[\\!\\#\\$\\%\\&\\'\\*\\+\\-\\.\\^\\_\\`\\|\\~a-zA-Z0-9]+\\s*=\\s*(?:(?:\"(?:(?:\\Q\\\"\\E)|[^\"])*\")|(?:[\\!\\#\\$\\%\\&\\'\\*\\+\\-\\.\\^\\_\\`\\|\\~a-zA-Z0-9]+)))?)*)|([a-zA-Z0-9\\-\\.\\_\\~\\+\\/]+\\=*)))?");
    private static final Pattern param = Pattern.compile("([\\!\\#\\$\\%\\&\\'\\*\\+\\-\\.\\^\\_\\`\\|\\~a-zA-Z0-9]+\\s*=\\s*(?:(?:\"(?:(?:\\Q\\\"\\E)|[^\"])*\")|(?:[\\!\\#\\$\\%\\&\\'\\*\\+\\-\\.\\^\\_\\`\\|\\~a-zA-Z0-9]+)))");

    public static Directives parse(String challenge) {
        Preconditions.checkNotNull((Object)challenge);
        ArrayList<Directive> challenges = new ArrayList<Directive>();
        Matcher matcher = pattern.matcher(challenge);
        while (matcher.find()) {
            String scheme = matcher.group(1);
            String params = matcher.group(2);
            params = params != null ? params.replaceAll(",\\s*,", ",").replaceAll(",\\s*,", ",") : null;
            String b64token = matcher.group(3);
            ArrayList<Parameter> parameters = new ArrayList<Parameter>();
            if (params != null) {
                Matcher mparams = param.matcher(params);
                while (mparams.find()) {
                    String p = mparams.group(1);
                    String[] ps = p.split("\\s*=\\s*", 2);
                    String name = ps[0];
                    if (name.charAt(name.length() - 1) == '*') {
                        name = name.substring(0, name.length() - 1);
                    }
                    parameters.add(DirectivesParser.createParameter(name, ps[1]));
                }
            }
            challenges.add(new AuthDirective(scheme, b64token, parameters));
        }
        return new Directives(challenges);
    }
}

