/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.httpcache4j;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.codehaus.httpcache4j.HeaderUtils;
import org.codehaus.httpcache4j.NameValue;
import org.codehaus.httpcache4j.Parameter;
import org.codehaus.httpcache4j.util.NumberUtils;

public class Directive
extends NameValue {
    private final List<Parameter> parameters;
    private Map<String, Parameter> parameterMap;

    public Directive(String name, String value) {
        this(name, HeaderUtils.removeQuotes(value), Collections.emptyList());
    }

    public Directive(String name, String value, List<Parameter> parameters) {
        super(name, HeaderUtils.removeQuotes(value));
        Preconditions.checkNotNull(parameters, (Object)"Parameters may not be null");
        this.parameters = ImmutableList.copyOf(parameters);
    }

    public List<Parameter> getParameters() {
        return this.parameters;
    }

    public int getValueAsInteger() {
        return NumberUtils.toInt(this.getValue(), -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Parameter getParameter(String name) {
        if (this.parameterMap == null) {
            Directive directive = this;
            synchronized (directive) {
                if (this.parameterMap == null) {
                    ImmutableMap.Builder builder = ImmutableMap.builder();
                    for (Parameter parameter : this.parameters) {
                        builder.put((Object)parameter.getName(), (Object)parameter);
                    }
                    this.parameterMap = builder.build();
                }
            }
        }
        return this.parameterMap.get(name);
    }

    public String getParameterValue(String name) {
        Parameter param = this.getParameter(name);
        if (param != null) {
            return param.getValue();
        }
        return null;
    }

    @Override
    public String toString() {
        String output = this.name;
        if (this.value != null && !this.value.isEmpty()) {
            output = output + "=" + this.value;
        }
        if (!this.parameters.isEmpty()) {
            output = output + "; " + Joiner.on((String)"; ").join(this.parameters);
        }
        return output;
    }
}

