/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.httpcache4j;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import java.util.Locale;
import java.util.Map;

public final class HTTPMethod {
    public static final HTTPMethod CONNECT = new HTTPMethod("CONNECT");
    public static final HTTPMethod DELETE = new HTTPMethod("DELETE", false, Idempotency.IDEMPOTENT);
    public static final HTTPMethod GET = new HTTPMethod("GET", true, Idempotency.IDEMPOTENT);
    public static final HTTPMethod HEAD = new HTTPMethod("HEAD", true, Idempotency.IDEMPOTENT);
    public static final HTTPMethod OPTIONS = new HTTPMethod("OPTIONS", false, Idempotency.IDEMPOTENT);
    public static final HTTPMethod PATCH = new HTTPMethod("PATCH");
    public static final HTTPMethod POST = new HTTPMethod("POST");
    public static final HTTPMethod PURGE = new HTTPMethod("PURGE");
    public static final HTTPMethod PUT = new HTTPMethod("PUT", false, Idempotency.IDEMPOTENT);
    public static final HTTPMethod TRACE = new HTTPMethod("TRACE", false, Idempotency.IDEMPOTENT);
    private static Map<String, HTTPMethod> defaultMethods = ImmutableMap.builder().put((Object)CONNECT.getMethod().toUpperCase(Locale.ENGLISH), (Object)CONNECT).put((Object)DELETE.getMethod().toUpperCase(Locale.ENGLISH), (Object)DELETE).put((Object)GET.getMethod().toUpperCase(Locale.ENGLISH), (Object)GET).put((Object)HEAD.getMethod().toUpperCase(Locale.ENGLISH), (Object)HEAD).put((Object)OPTIONS.getMethod().toUpperCase(Locale.ENGLISH), (Object)OPTIONS).put((Object)PATCH.getMethod().toUpperCase(Locale.ENGLISH), (Object)PATCH).put((Object)POST.getMethod().toUpperCase(Locale.ENGLISH), (Object)POST).put((Object)PURGE.getMethod().toUpperCase(Locale.ENGLISH), (Object)PURGE).put((Object)PUT.getMethod().toUpperCase(Locale.ENGLISH), (Object)PUT).put((Object)TRACE.getMethod().toUpperCase(Locale.ENGLISH), (Object)TRACE).build();
    private final String method;
    private final boolean cacheable;
    private final Idempotency idempotency;

    private HTTPMethod(String method) {
        this(method, false, Idempotency.NON_IDEMPOTENT);
    }

    private HTTPMethod(String method, boolean cacheable, Idempotency idempotency) {
        this.method = method;
        this.cacheable = cacheable;
        this.idempotency = idempotency;
    }

    public String getMethod() {
        return this.method;
    }

    @Deprecated
    public String name() {
        return this.getMethod();
    }

    public String toString() {
        return this.method;
    }

    public static HTTPMethod[] values() {
        return defaultMethods.values().toArray(new HTTPMethod[defaultMethods.size()]);
    }

    public static HTTPMethod valueOf(String method) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)method) ? 1 : 0) != 0, (Object)"Method name may not be null or empty");
        String uppercaseMethod = method.toUpperCase(Locale.ENGLISH);
        if (defaultMethods.containsKey(uppercaseMethod)) {
            return defaultMethods.get(uppercaseMethod);
        }
        return new HTTPMethod(uppercaseMethod);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HTTPMethod that = (HTTPMethod)o;
        return !(this.method != null ? !this.method.equalsIgnoreCase(that.method) : that.method != null);
    }

    public int hashCode() {
        return this.method != null ? this.method.hashCode() : 0;
    }

    public boolean canHavePayload() {
        return this == POST || this == PUT || this == PATCH;
    }

    public boolean isSafe() {
        return this == GET || this == HEAD;
    }

    public boolean isCacheable() {
        return this.cacheable;
    }

    public boolean isIdempotent() {
        return this.idempotency == Idempotency.IDEMPOTENT;
    }

    public static enum Idempotency {
        IDEMPOTENT,
        NON_IDEMPOTENT;

    }
}

