/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.httpcache4j.auth.mac;

import java.security.SecureRandom;
import org.codehaus.httpcache4j.util.Hex;
import org.codehaus.httpcache4j.util.SecureRandomFactory;

public final class Nonce {
    private static SecureRandom rnd = SecureRandomFactory.getRandom();
    private static final int OFFSET = 8;
    private final String nonce;

    Nonce(String nonce) {
        this.nonce = nonce;
    }

    public static Nonce generate() {
        byte[] bytes = new byte[1024];
        rnd.nextBytes(bytes);
        String s = Hex.encode(bytes);
        int length = s.length();
        int index = rnd.nextInt(length);
        while (index + 8 >= length) {
            index = rnd.nextInt(length);
        }
        String substring = s.substring(index, index + 8);
        return new Nonce(substring);
    }

    public String format() {
        return this.nonce;
    }

    public String toString() {
        return "Nonce{'" + this.nonce + "'" + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Nonce nonce1 = (Nonce)o;
        return !(this.nonce != null ? !this.nonce.equals(nonce1.nonce) : nonce1.nonce != null);
    }

    public int hashCode() {
        return this.nonce != null ? this.nonce.hashCode() : 0;
    }
}

