/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.httpcache4j.auth;

import java.util.List;
import org.apache.commons.lang.Validate;
import org.codehaus.httpcache4j.Challenge;
import org.codehaus.httpcache4j.HTTPRequest;
import org.codehaus.httpcache4j.HTTPResponse;
import org.codehaus.httpcache4j.Headers;
import org.codehaus.httpcache4j.Status;
import org.codehaus.httpcache4j.auth.AuthScheme;
import org.codehaus.httpcache4j.auth.AuthenticatorBase;
import org.codehaus.httpcache4j.auth.AuthenticatorStrategy;
import org.codehaus.httpcache4j.auth.ProxyAuthenticator;
import org.codehaus.httpcache4j.auth.ProxyConfiguration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultProxyAuthenticator
extends AuthenticatorBase
implements ProxyAuthenticator {
    private final ProxyConfiguration configuration;
    private Challenge proxyChallenge;

    public DefaultProxyAuthenticator() {
        this(new ProxyConfiguration());
    }

    public DefaultProxyAuthenticator(ProxyConfiguration configuration) {
        this.configuration = configuration;
    }

    public DefaultProxyAuthenticator(ProxyConfiguration configuration, List<AuthenticatorStrategy> strategies) {
        super(strategies);
        Validate.notNull((Object)configuration, (String)"Configuration may not be null");
        this.configuration = configuration;
    }

    @Override
    public final HTTPRequest prepareAuthentication(HTTPRequest request, HTTPResponse response) {
        if (this.configuration.getHost() != null) {
            if (response == null && this.registry.matches(this.configuration.getHost())) {
                AuthScheme authScheme = this.registry.get(this.configuration.getHost());
                return this.doAuth(request, authScheme);
            }
            if (response != null && response.getStatus() == Status.PROXY_AUTHENTICATION_REQUIRED) {
                if (this.proxyChallenge == null) {
                    this.proxyChallenge = this.configuration.getProvider().getChallenge();
                }
                if (this.proxyChallenge != null) {
                    AuthScheme scheme = new AuthScheme(response.getHeaders().getFirstHeader("Proxy-Authenticate"));
                    this.registry.register(this.configuration.getHost(), scheme);
                    return this.doAuth(request, scheme);
                }
            }
        }
        return request;
    }

    @Override
    public boolean canAuthenticatePreemptively() {
        return this.canAuthenticatePreemptively(this.configuration.getHost());
    }

    @Override
    public HTTPRequest preparePreemptiveAuthentication(HTTPRequest request) {
        return this.prepareAuthentication(request, null);
    }

    private HTTPRequest doAuth(HTTPRequest request, AuthScheme scheme) {
        if (!this.configuration.isHostIgnored(request.getRequestURI().getHost())) {
            return this.select(scheme).prepareWithProxy(request, this.proxyChallenge, scheme);
        }
        return request;
    }

    @Override
    public void afterSuccessfulAuthentication(Headers responseHeaders) {
        if (this.registry.matches(this.configuration.getHost())) {
            AuthScheme scheme = this.registry.get(this.configuration.getHost());
            this.select(scheme).afterSuccessfulProxyAuthentication(scheme, responseHeaders);
        }
    }

    @Override
    public void afterFailedAuthentication(Headers responseHeaders) {
        this.invalidateAuthentication();
        this.registry.remove(this.configuration.getHost());
    }

    @Override
    public void invalidateAuthentication() {
        this.proxyChallenge = null;
    }

    @Override
    public ProxyConfiguration getConfiguration() {
        return this.configuration;
    }
}

