/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.httpcache4j;

import com.google.common.collect.Lists;
import java.net.URI;
import org.codehaus.httpcache4j.Directive;
import org.codehaus.httpcache4j.Parameter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LinkDirective
extends Directive {
    private final URI uri;

    public LinkDirective(Directive directive) {
        super("Link", directive.getValue(), directive.getParameters());
        this.uri = URI.create(directive.getValue());
    }

    public LinkDirective(URI uri, Iterable<Parameter> parameters) {
        super("Link", "<" + uri + ">", Lists.newArrayList(parameters));
        this.uri = uri;
    }

    public URI getURI() {
        return this.uri;
    }

    public String getRel() {
        return this.getParameterValue("rel");
    }

    public String getParameterValue(String key) {
        for (Parameter param : this.getParameters()) {
            if (!param.getName().equals(key)) continue;
            return param.getValue();
        }
        return null;
    }

    public String getRev() {
        return this.getParameterValue("rev");
    }

    public String getTitle() {
        return this.getParameterValue("title");
    }

    public URI getAnchor() {
        String paramValue = this.getParameterValue("anchor");
        if (paramValue != null) {
            return URI.create(paramValue);
        }
        return null;
    }

    @Override
    public String toString() {
        StringBuilder value = new StringBuilder();
        value.append(String.format("<%s>", this.uri));
        for (Parameter parameter : this.getParameters()) {
            if (value.length() > 0) {
                value.append("; ");
            }
            value.append(parameter);
        }
        return value.toString();
    }
}

