/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.httpcache4j.util;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.codehaus.httpcache4j.Parameter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class URIBuilder {
    private String scheme;
    private String host;
    private int port;
    private String path;
    private String fragment;
    private Map<String, List<Parameter>> parameters = new HashMap<String, List<Parameter>>();

    private URIBuilder(String scheme, String host, int port, String path, String fragment) {
        this.scheme = scheme;
        this.host = host;
        this.port = port;
        this.path = path;
        this.fragment = fragment;
    }

    public URIBuilder path(String path) {
        this.path = path;
        return this;
    }

    public URIBuilder host(String host) {
        this.host = host;
        return this;
    }

    public URIBuilder port(int port) {
        this.port = port;
        return this;
    }

    public URIBuilder fragment(String fragment) {
        this.fragment = fragment;
        return this;
    }

    public URIBuilder addParameter(String name, String value) {
        return this.addParameter(new Parameter(name, value));
    }

    public URIBuilder addParameter(Parameter parameter) {
        List<Parameter> list = this.parameters.get(parameter.getName());
        if (list == null) {
            list = new ArrayList<Parameter>();
        }
        list.add(parameter);
        return this;
    }

    public URIBuilder clearParameters() {
        this.parameters.clear();
        return this;
    }

    public URIBuilder copy() {
        URIBuilder builder = new URIBuilder(this.scheme, this.host, this.port, this.path, this.fragment);
        builder.parameters.putAll(this.parameters);
        return builder;
    }

    public URI toURI() {
        try {
            return new URI(this.scheme, null, this.host, this.port, this.path, this.toQuery(), this.fragment);
        }
        catch (URISyntaxException e) {
            throw new IllegalStateException(e);
        }
    }

    private String toQuery() {
        StringBuilder builder = new StringBuilder();
        for (Parameter parameter : this.getParametersAsList()) {
            if (builder.length() > 0) {
                builder.append("&");
            }
            builder.append(parameter.getName()).append("=").append(parameter.getValue());
        }
        return builder.toString();
    }

    private List<Parameter> getParametersAsList() {
        ArrayList<Parameter> list = new ArrayList<Parameter>();
        for (List<Parameter> pList : this.parameters.values()) {
            list.addAll(pList);
        }
        return list;
    }

    public static URIBuilder fromURI(URI uri) {
        return new URIBuilder(uri.getScheme(), uri.getHost(), uri.getPort(), uri.getPath(), uri.getFragment());
    }
}

