/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.httpcache4j.payload;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.Validate;
import org.codehaus.httpcache4j.MIMEType;
import org.codehaus.httpcache4j.Parameter;
import org.codehaus.httpcache4j.payload.Payload;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FormDataPayload
implements Payload {
    private final MIMEType mimeType = new MIMEType("application/x-www-form-urlencoded");
    private final String values;

    public FormDataPayload(Map<String, List<String>> parameters) {
        this(FormDataPayload.toIterable(parameters));
    }

    private static Iterable<FormParameter> toIterable(Map<String, List<String>> parameters) {
        Validate.notNull(parameters, (String)"Parameters map may not be null");
        ArrayList<FormParameter> params = new ArrayList<FormParameter>();
        for (Map.Entry<String, List<String>> entry : parameters.entrySet()) {
            params.addAll(FormDataPayload.convert(entry.getKey(), entry.getValue()));
        }
        return params;
    }

    private static List<FormParameter> convert(final String key, List<String> values) {
        return Lists.transform(values, (Function)new Function<String, FormParameter>(){

            public FormParameter apply(String from) {
                return new FormParameter(key, from);
            }
        });
    }

    public FormDataPayload(Iterable<FormParameter> parameters) {
        this.values = Joiner.on((String)"&").skipNulls().join(parameters);
    }

    @Override
    public MIMEType getMimeType() {
        return this.mimeType;
    }

    @Override
    public InputStream getInputStream() {
        return IOUtils.toInputStream((String)this.values);
    }

    public String getValues() {
        return this.values;
    }

    @Override
    public boolean isAvailable() {
        return true;
    }

    public static class FormParameter
    extends Parameter {
        private static final long serialVersionUID = -174492565886663398L;

        public FormParameter(String key, String value) {
            super(key, value);
        }

        private String encode(String value) {
            try {
                return URLEncoder.encode(value, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new Error(e);
            }
        }

        public String toString() {
            return this.encode(this.name) + "=" + this.encode(this.value);
        }
    }
}

