/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.httpcache4j.auth;

import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.Validate;
import org.codehaus.httpcache4j.Challenge;
import org.codehaus.httpcache4j.HTTPRequest;
import org.codehaus.httpcache4j.HTTPResponse;
import org.codehaus.httpcache4j.Status;
import org.codehaus.httpcache4j.auth.AuthScheme;
import org.codehaus.httpcache4j.auth.AuthenticatorStrategy;
import org.codehaus.httpcache4j.auth.BasicAuthenticatorStrategy;
import org.codehaus.httpcache4j.auth.ProxyAuthenticator;
import org.codehaus.httpcache4j.auth.ProxyConfiguration;
import org.codehaus.httpcache4j.auth.SchemeRegistry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultProxyAuthenticator
implements ProxyAuthenticator {
    private final ProxyConfiguration configuration;
    private final List<AuthenticatorStrategy> strategies = Lists.newArrayList();
    private final SchemeRegistry registry = new SchemeRegistry();
    private Challenge proxyChallenge;

    public DefaultProxyAuthenticator(ProxyConfiguration configuration) {
        Validate.notNull((Object)configuration, (String)"Configuration may not be null");
        this.configuration = configuration;
        this.strategies.addAll(this.createStrategies());
    }

    protected List<AuthenticatorStrategy> createStrategies() {
        return Collections.singletonList(new BasicAuthenticatorStrategy());
    }

    @Override
    public final HTTPRequest prepareAuthentication(HTTPRequest request, HTTPResponse response) {
        if (this.configuration.getHost() != null) {
            if (response == null && this.registry.matches(this.configuration.getHost())) {
                AuthScheme authScheme = this.registry.get(this.configuration.getHost());
                return this.doAuth(request, authScheme);
            }
            if (response != null && response.getStatus() == Status.PROXY_AUTHENTICATION_REQUIRED) {
                if (this.proxyChallenge == null) {
                    this.proxyChallenge = this.configuration.getProvider().getChallenge();
                }
                if (this.proxyChallenge != null) {
                    AuthScheme scheme = new AuthScheme(response.getHeaders().getFirstHeader("Proxy-Authenticate"));
                    this.registry.register(this.configuration.getHost(), scheme);
                    return this.doAuth(request, scheme);
                }
            }
        }
        return request;
    }

    @Override
    public HTTPRequest preparePreemptiveAuthentication(HTTPRequest request) {
        return this.prepareAuthentication(request, null);
    }

    private HTTPRequest doAuth(HTTPRequest request, AuthScheme scheme) {
        if (!this.configuration.isHostIgnored(request.getRequestURI().getHost())) {
            for (AuthenticatorStrategy strategy : this.strategies) {
                if (!strategy.supports(scheme)) continue;
                return strategy.prepareWithProxy(request, this.proxyChallenge, scheme);
            }
        }
        return request;
    }

    @Override
    public void invalidateAuthentication() {
        this.proxyChallenge = null;
    }

    @Override
    public ProxyConfiguration getConfiguration() {
        return this.configuration;
    }
}

