/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.httpcache4j.auth;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.codehaus.httpcache4j.Header;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AuthScheme {
    private final Header header;
    private String type;
    private final Map<String, String> directives = new LinkedHashMap<String, String>();

    public AuthScheme(Header pHeader) {
        this.header = pHeader;
        String headervalue = pHeader.getValue();
        if (headervalue.contains(" ")) {
            int index = headervalue.indexOf(" ");
            this.type = headervalue.substring(0, index);
            this.directives.putAll(Header.parseDirectives(headervalue.substring(index + 1)));
        }
    }

    public Header getHeader() {
        return this.header;
    }

    public String getType() {
        return this.type;
    }

    public String getRealm() {
        return this.directives.get("realm");
    }

    public Map<String, String> getDirectives() {
        return Collections.unmodifiableMap(this.directives);
    }
}

