/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.httpcache4j;

import java.util.Locale;
import org.codehaus.httpcache4j.Header;
import org.codehaus.httpcache4j.Headers;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

public final class HeaderUtils {
    public static final String PATTERN_RFC1123 = "EEE, dd MMM yyyy HH:mm:ss 'GMT'";
    private static final String NO_STORE_HEADER_VALUE = "no-store";
    private static final String NO_CACHE_HEADER_VALUE = "no-cache";

    private HeaderUtils() {
    }

    public static DateTime fromHttpDate(Header header) {
        if (header == null) {
            return null;
        }
        DateTimeFormatter formatter = DateTimeFormat.forPattern((String)PATTERN_RFC1123).withZone(DateTimeZone.forID((String)"UTC")).withLocale(Locale.US);
        DateTime formattedDate = null;
        try {
            formattedDate = formatter.parseDateTime(header.getValue());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return formattedDate;
    }

    public static Header toHttpDate(String headerName, DateTime time) {
        DateTimeFormatter formatter = DateTimeFormat.forPattern((String)PATTERN_RFC1123).withZone(DateTimeZone.forID((String)"UTC")).withLocale(Locale.US);
        return new Header(headerName, formatter.print((ReadableInstant)time));
    }

    public static long getHeaderAsDate(Header header) {
        try {
            DateTime dateTime = HeaderUtils.fromHttpDate(header);
            if (dateTime != null) {
                return dateTime.getMillis();
            }
        }
        catch (Exception e) {
            return -1L;
        }
        return -1L;
    }

    public static boolean hasCacheableHeaders(Headers headers) {
        Header header;
        if (headers.contains(new Header("Vary", "*")) || !headers.hasHeader("Date")) {
            return false;
        }
        if (headers.hasHeader("Cache-Control") && ((header = headers.getFirstHeader("Cache-Control")).getValue().contains(NO_STORE_HEADER_VALUE) || header.getValue().contains(NO_CACHE_HEADER_VALUE))) {
            return false;
        }
        if (headers.hasHeader("Expires")) {
            Header expires = headers.getFirstHeader("Expires");
            DateTime expiresValue = HeaderUtils.fromHttpDate(expires);
            Header date = headers.getFirstHeader("Date");
            if (expiresValue == null || date == null) {
                return false;
            }
            DateTime dateValue = HeaderUtils.fromHttpDate(date);
            if (expiresValue.isBefore((ReadableInstant)dateValue)) {
                return false;
            }
        }
        return headers.getFirstHeader("ETag") != null || headers.getFirstHeader("Last-Modified") != null;
    }
}

