/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.httpcache4j;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.math.NumberUtils;
import org.codehaus.httpcache4j.Header;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CacheControl {
    private int maxAge = -1;
    private int maxStale = -1;
    private int minFresh = -1;
    private int sMaxAge = -1;
    private Map<Directive, String> directives = new HashMap<Directive, String>();

    public CacheControl(Header header) {
        this.parse(header);
    }

    public static CacheControl valueOf(String headerValue) {
        return new CacheControl(new Header("Cache-Control", headerValue));
    }

    private void parse(Header header) {
        Map<Directive, String> directiveMap = this.convertDirectiveMap(header);
        this.directives.putAll(directiveMap);
        this.parseDirectiveMap(directiveMap);
        if (this.directives.isEmpty()) {
            throw new IllegalArgumentException("Unkown value from header: " + header.getValue());
        }
    }

    private void parseDirectiveMap(Map<Directive, String> directiveMap) {
        String directiveValue = directiveMap.get((Object)Directive.MAX_AGE);
        this.maxAge = NumberUtils.toInt((String)directiveValue, (int)-1);
        directiveValue = directiveMap.get((Object)Directive.MAX_STALE);
        this.maxStale = NumberUtils.toInt((String)directiveValue, (int)-1);
        directiveValue = directiveMap.get((Object)Directive.MIN_FRESH);
        this.minFresh = NumberUtils.toInt((String)directiveValue, (int)-1);
        directiveValue = directiveMap.get((Object)Directive.S_MAX_AGE);
        this.sMaxAge = NumberUtils.toInt((String)directiveValue, (int)-1);
    }

    private Map<Directive, String> convertDirectiveMap(Header header) {
        HashMap<Directive, String> directives = new HashMap<Directive, String>();
        for (Map.Entry<String, String> directive : header.getDirectives().entrySet()) {
            directives.put(Directive.toDirective(directive.getKey()), directive.getValue());
        }
        return directives;
    }

    public int getMaxAge() {
        return this.maxAge;
    }

    public int getMaxStale() {
        return this.maxStale;
    }

    public int getMinFresh() {
        return this.minFresh;
    }

    int getSMaxAge() {
        return this.sMaxAge;
    }

    public boolean isPrivate() {
        return this.directives.containsKey((Object)Directive.PRIVATE);
    }

    public Header toHeader() {
        if (this.directives.isEmpty()) {
            throw new IllegalStateException("No directives set, unable to add header");
        }
        return new Header("Cache-Control", this.format());
    }

    private String format() {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<Directive, String> directive : this.directives.entrySet()) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append(directive.getKey().getValue());
            if (directive.getValue() == null) continue;
            sb.append("=").append(directive.getValue());
        }
        return sb.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Directive {
        PRIVATE("private"),
        PUBLIC("public"),
        MUST_REVALIDATE("must-revalidate"),
        NO_STORE("no-store"),
        NO_CACHE("no-cache"),
        NO_TRANSFORM("no-transform"),
        MAX_AGE("max-age"),
        MAX_STALE("max-stale"),
        ONLY_IF_CACHED("only-if-cached"),
        MIN_FRESH("min-fresh"),
        S_MAX_AGE("s-maxage"),
        PROXY_REVALIDATE("proxy-revalidate");

        private final String value;

        private Directive(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public static Directive toDirective(String directive) {
            for (Directive dir : Directive.values()) {
                if (!dir.getValue().equals(directive)) continue;
                return dir;
            }
            throw new IllegalArgumentException(String.format("No such directive %s", directive));
        }
    }
}

