/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.httpcache4j;

import java.net.URI;
import org.apache.commons.lang.Validate;
import org.codehaus.httpcache4j.Challenge;
import org.codehaus.httpcache4j.Conditionals;
import org.codehaus.httpcache4j.HTTPMethod;
import org.codehaus.httpcache4j.Header;
import org.codehaus.httpcache4j.Headers;
import org.codehaus.httpcache4j.payload.Payload;
import org.codehaus.httpcache4j.preference.Preferences;
import org.joda.time.DateTime;

public class HTTPRequest {
    private final URI requestURI;
    private final HTTPMethod method;
    private final Conditionals conditionals;
    private final Preferences preferences;
    private final Headers headers;
    private final Challenge challenge;
    private final Payload payload;
    private final DateTime requestTime;

    public HTTPRequest(URI requestURI, HTTPMethod method) {
        this(requestURI, method, new Headers(), new Conditionals(), new Preferences(), null, null, new DateTime());
    }

    public HTTPRequest(HTTPRequest request) {
        this(request.getRequestURI(), request.getMethod(), request.getHeaders(), request.getConditionals(), request.getPreferences(), request.getChallenge(), request.getPayload(), request.getRequestTime());
    }

    private HTTPRequest(URI requestURI, HTTPMethod method, Headers headers, Conditionals conditionals, Preferences preferences, Challenge challenge, Payload payload, DateTime requestTime) {
        this.method = method;
        this.requestURI = requestURI;
        this.headers = headers;
        this.conditionals = conditionals;
        this.preferences = preferences;
        this.challenge = challenge;
        this.payload = payload;
        this.requestTime = requestTime;
    }

    public HTTPRequest(URI requestURI) {
        this(requestURI, HTTPMethod.GET);
    }

    public URI getRequestURI() {
        return this.requestURI;
    }

    public Headers getHeaders() {
        return this.headers;
    }

    public Headers getAllHeaders() {
        Headers requestHeaders = this.getHeaders();
        Headers conditionalHeaders = this.getConditionals().toHeaders();
        Headers preferencesHeaders = this.getPreferences().toHeaders();
        requestHeaders = this.merge(this.merge(requestHeaders, conditionalHeaders), preferencesHeaders);
        if (this.hasPayload()) {
            requestHeaders.remove("Content-Type");
            requestHeaders = requestHeaders.add("Content-Type", this.getPayload().getMimeType().toString());
        }
        return requestHeaders;
    }

    private Headers merge(Headers base, Headers toMerge) {
        return new Headers().add(base).add(toMerge);
    }

    public HTTPRequest addHeader(Header header) {
        Headers headers = this.headers.add(header);
        return new HTTPRequest(this.requestURI, this.method, headers, this.conditionals, this.preferences, this.challenge, this.payload, this.requestTime);
    }

    public HTTPRequest addHeader(String name, String value) {
        return this.addHeader(new Header(name, value));
    }

    public Conditionals getConditionals() {
        return this.conditionals;
    }

    public HTTPRequest conditionals(Conditionals conditionals) {
        Validate.notNull((Object)conditionals, (String)"You may not set null conditionals");
        return new HTTPRequest(this.requestURI, this.method, this.headers, conditionals, this.preferences, this.challenge, this.payload, this.requestTime);
    }

    public HTTPMethod getMethod() {
        return this.method;
    }

    public Preferences getPreferences() {
        return this.preferences;
    }

    public HTTPRequest preferences(Preferences preferences) {
        return new HTTPRequest(this.requestURI, this.method, this.headers, this.conditionals, preferences, this.challenge, this.payload, this.requestTime);
    }

    public Challenge getChallenge() {
        return this.challenge;
    }

    public HTTPRequest challenge(Challenge challenge) {
        return new HTTPRequest(this.requestURI, this.method, this.headers, this.conditionals, this.preferences, challenge, this.payload, this.requestTime);
    }

    public Payload getPayload() {
        return this.payload;
    }

    public HTTPRequest payload(Payload payload) {
        return new HTTPRequest(this.requestURI, this.method, this.headers, this.conditionals, this.preferences, this.challenge, payload, this.requestTime);
    }

    public HTTPRequest headers(Headers headers) {
        Validate.notNull((Object)headers, (String)"You may not set null headers");
        return new HTTPRequest(this.requestURI, this.method, headers, this.conditionals, this.preferences, this.challenge, this.payload, this.requestTime);
    }

    public boolean hasPayload() {
        return this.payload != null;
    }

    public DateTime getRequestTime() {
        return this.requestTime;
    }
}

