/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.httpcache4j;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.Validate;
import org.codehaus.httpcache4j.Header;
import org.codehaus.httpcache4j.HeaderUtils;
import org.codehaus.httpcache4j.Headers;
import org.codehaus.httpcache4j.Tag;
import org.joda.time.DateTime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Conditionals {
    private final List<Tag> match;
    private final List<Tag> noneMatch;
    private final DateTime modifiedSince;
    private final DateTime unModifiedSince;
    private static final String ERROR_MESSAGE = "The combination of %s and %s is undefined by the HTTP specification";

    public Conditionals() {
        this(Conditionals.empty(), Conditionals.empty(), null, null);
    }

    private static List<Tag> empty() {
        return Collections.emptyList();
    }

    public Conditionals(List<Tag> match, List<Tag> noneMatch, DateTime modifiedSince, DateTime unModifiedSince) {
        this.match = match;
        this.noneMatch = noneMatch;
        this.modifiedSince = modifiedSince;
        this.unModifiedSince = unModifiedSince;
    }

    public Conditionals addIfMatch(Tag tag) {
        Validate.isTrue((this.modifiedSince == null ? 1 : 0) != 0, (String)String.format(ERROR_MESSAGE, "If-Match", "If-Modified-Since"));
        Validate.isTrue((boolean)this.noneMatch.isEmpty(), (String)String.format(ERROR_MESSAGE, "If-Match", "If-None-Match"));
        ArrayList<Tag> match = new ArrayList<Tag>(this.match);
        if (tag == null) {
            tag = Tag.ALL;
        }
        if (Tag.ALL.equals(tag)) {
            match.clear();
        }
        if (!match.contains(Tag.ALL)) {
            if (!match.contains(tag)) {
                match.add(tag);
            }
        } else {
            throw new IllegalArgumentException("Tag ALL already in the list");
        }
        return new Conditionals(Collections.unmodifiableList(match), Conditionals.empty(), null, this.unModifiedSince);
    }

    public Conditionals addIfNoneMatch(Tag tag) {
        Validate.isTrue((this.unModifiedSince == null ? 1 : 0) != 0, (String)String.format(ERROR_MESSAGE, "If-None-Match", "If-Unmodified-Since"));
        Validate.isTrue((boolean)this.match.isEmpty(), (String)String.format(ERROR_MESSAGE, "If-None-Match", "If-Match"));
        ArrayList<Tag> noneMatch = new ArrayList<Tag>(this.noneMatch);
        if (tag == null) {
            tag = Tag.ALL;
        }
        if (Tag.ALL.equals(tag)) {
            noneMatch.clear();
        }
        if (!noneMatch.contains(Tag.ALL)) {
            if (!noneMatch.contains(tag)) {
                noneMatch.add(tag);
            }
        } else {
            throw new IllegalArgumentException("Tag ALL already in the list");
        }
        return new Conditionals(Conditionals.empty(), Collections.unmodifiableList(noneMatch), this.modifiedSince, null);
    }

    public Conditionals ifModifiedSince(DateTime time) {
        Validate.isTrue((boolean)this.match.isEmpty(), (String)String.format(ERROR_MESSAGE, "If-Modified-Since", "If-Match"));
        Validate.isTrue((this.unModifiedSince == null ? 1 : 0) != 0, (String)String.format(ERROR_MESSAGE, "If-Modified-Since", "If-Unmodified-Since"));
        return new Conditionals(Conditionals.empty(), this.noneMatch, time, null);
    }

    public Conditionals ifUnModifiedSince(DateTime time) {
        Validate.isTrue((boolean)this.noneMatch.isEmpty(), (String)String.format(ERROR_MESSAGE, "If-Unmodified-Since", "If-None-Match"));
        Validate.isTrue((this.modifiedSince == null ? 1 : 0) != 0, (String)String.format(ERROR_MESSAGE, "If-Unmodified-Since", "If-Modified-Since"));
        return new Conditionals(this.match, Conditionals.empty(), null, time);
    }

    public List<Tag> getMatch() {
        return Collections.unmodifiableList(this.match);
    }

    public List<Tag> getNoneMatch() {
        return Collections.unmodifiableList(this.noneMatch);
    }

    public DateTime getModifiedSince() {
        return this.modifiedSince;
    }

    public DateTime getUnModifiedSince() {
        return this.unModifiedSince;
    }

    public boolean isUnconditional() {
        return this.noneMatch.contains(Tag.ALL) || this.match.contains(Tag.ALL);
    }

    public Headers toHeaders() {
        Headers headers = new Headers();
        if (!this.getMatch().isEmpty()) {
            headers = headers.add(new Header("If-Match", this.buildTagHeaderValue(this.getMatch())));
        }
        if (!this.getNoneMatch().isEmpty()) {
            headers = headers.add(new Header("If-None-Match", this.buildTagHeaderValue(this.getNoneMatch())));
        }
        if (this.modifiedSince != null) {
            headers = headers.add(HeaderUtils.toHttpDate("If-Modified-Since", this.modifiedSince));
        }
        if (this.unModifiedSince != null) {
            headers = headers.add(HeaderUtils.toHttpDate("If-Unmodified-Since", this.unModifiedSince));
        }
        return headers;
    }

    private String buildTagHeaderValue(List<Tag> match) {
        StringBuilder builder = new StringBuilder();
        for (Tag tag : match) {
            if (builder.length() > 0) {
                builder.append(", ");
            }
            builder.append(tag.format());
        }
        return builder.toString();
    }
}

