/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.httpcache4j.resolver;

import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.Validate;
import org.codehaus.httpcache4j.HTTPException;
import org.codehaus.httpcache4j.HTTPRequest;
import org.codehaus.httpcache4j.HTTPResponse;
import org.codehaus.httpcache4j.HTTPUtil;
import org.codehaus.httpcache4j.Header;
import org.codehaus.httpcache4j.HeaderUtils;
import org.codehaus.httpcache4j.Headers;
import org.codehaus.httpcache4j.MIMEType;
import org.codehaus.httpcache4j.Status;
import org.codehaus.httpcache4j.payload.InputStreamPayload;
import org.codehaus.httpcache4j.payload.Payload;
import org.codehaus.httpcache4j.resolver.ResponseCreator;
import org.codehaus.httpcache4j.resolver.StoragePolicy;

public abstract class AbstractResponseCreator
implements ResponseCreator {
    private final StoragePolicy storagePolicy;

    protected AbstractResponseCreator(StoragePolicy storagePolicy) {
        Validate.notNull((Object)"Storage policy may not be null, use other constructor if you do not have a storage policy");
        this.storagePolicy = storagePolicy;
    }

    protected AbstractResponseCreator() {
        this(StoragePolicy.NULL);
    }

    public synchronized HTTPResponse createResponse(HTTPRequest request, Status status, Headers responseHeaders, InputStream stream) {
        boolean cacheable = HeaderUtils.hasCacheableHeaders(responseHeaders) && HTTPUtil.isCacheableRequest(request);
        Header contentTypeHeader = responseHeaders.getFirstHeader("Content-Type");
        MIMEType type = contentTypeHeader != null ? MIMEType.valueOf(contentTypeHeader.getValue()) : MIMEType.APPLICATION_OCTET_STREAM;
        Payload payload = null;
        if (status.isBodyContentAllowed()) {
            if (cacheable && stream != null) {
                try {
                    payload = this.createCachedPayload(request, responseHeaders, stream, type);
                }
                catch (IOException e) {
                    throw new HTTPException("Unable to create payload for response", e);
                }
                finally {
                    IOUtils.closeQuietly((InputStream)stream);
                }
            } else if (!cacheable && stream != null) {
                payload = new InputStreamPayload(stream, type);
            }
        }
        return new HTTPResponse(payload, status, responseHeaders);
    }

    protected StoragePolicy getStoragePolicy() {
        return this.storagePolicy;
    }

    protected abstract Payload createCachedPayload(HTTPRequest var1, Headers var2, InputStream var3, MIMEType var4) throws IOException;
}

