/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.httpcache4j;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import org.codehaus.httpcache4j.Header;
import org.codehaus.httpcache4j.Headers;
import org.codehaus.httpcache4j.preference.Preference;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HTTPUtils {
    public static final String PATTERN_RFC1123 = "EEE, dd MMM yyyy HH:mm:ss zzz";
    private static final String NO_STORE_HEADER_VALUE = "no-store";
    private static final String NO_CACHE_HEADER_VALUE = "no-cache";

    private HTTPUtils() {
    }

    public static DateTime fromHttpDate(Header header) {
        SimpleDateFormat format = new SimpleDateFormat(PATTERN_RFC1123);
        Date date = null;
        try {
            date = format.parse(header.getValue());
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        if (date != null) {
            return new DateTime(date.getTime());
        }
        return null;
    }

    public static Header toHttpDate(String headerName, DateTime time) {
        DateTimeFormatter formatter = DateTimeFormat.forPattern((String)PATTERN_RFC1123);
        return new Header(headerName, formatter.print((ReadableInstant)time));
    }

    public static long getHeaderAsDate(Header header) {
        try {
            DateTime dateTime = HTTPUtils.fromHttpDate(header);
            if (dateTime != null) {
                return dateTime.getMillis();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1L;
        }
        return -1L;
    }

    public static boolean hasCacheableHeaders(Headers headers) {
        if (headers.contains(new Header("Vary", "*"))) {
            return false;
        }
        if (headers.hasHeader("Cache-Control")) {
            Header header = headers.getFirstHeader("Cache-Control");
            if (header.getValue().contains(NO_STORE_HEADER_VALUE) || header.getValue().contains(NO_CACHE_HEADER_VALUE)) {
                return false;
            }
            return header.getDirectives().containsKey("max-age");
        }
        if (headers.contains(new Header("Pragma", NO_CACHE_HEADER_VALUE)) || headers.contains(new Header("Pragma", NO_STORE_HEADER_VALUE))) {
            return false;
        }
        return headers.getFirstHeader("ETag") != null || headers.getFirstHeader("Expires") != null || headers.getFirstHeader("Last-Modified") != null;
    }

    public static Header toHeader(String headerName, List<? extends Preference<?>> preferences) {
        StringBuilder builder = new StringBuilder();
        for (Preference<?> preference : preferences) {
            if (builder.length() > 0) {
                builder.append(", ");
            }
            builder.append(preference.toString());
        }
        return new Header(headerName, builder.toString());
    }
}

