/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.httpcache4j;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.Validate;
import org.codehaus.httpcache4j.HTTPUtils;
import org.codehaus.httpcache4j.Header;
import org.codehaus.httpcache4j.Headers;
import org.codehaus.httpcache4j.Tag;
import org.joda.time.DateTime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Conditionals {
    private final List<Tag> match = new ArrayList<Tag>();
    private final List<Tag> nonMatch = new ArrayList<Tag>();
    private DateTime modifiedSince;
    private DateTime unModifiedSince;
    private static final String ERROR_MESSAGE = "The combination of %s and %s is undefined by the HTTP specification";

    public void addIfMatch(Tag tag) {
        Validate.isTrue((this.modifiedSince == null ? 1 : 0) != 0, (String)String.format(ERROR_MESSAGE, "If-Match", "If-Modified-Since"));
        Validate.isTrue((this.nonMatch == null || this.nonMatch.isEmpty() ? 1 : 0) != 0, (String)String.format(ERROR_MESSAGE, "If-Match", "If-None-Match"));
        if (tag == null) {
            tag = Tag.ALL;
        }
        if (Tag.ALL.equals(tag)) {
            this.match.clear();
        }
        if (this.match.contains(Tag.ALL)) {
            throw new IllegalArgumentException("Tag ALL already in the list");
        }
        this.match.add(tag);
    }

    public void addIfNoneMatch(Tag tag) {
        Validate.isTrue((this.unModifiedSince == null ? 1 : 0) != 0, (String)String.format(ERROR_MESSAGE, "If-None-Match", "If-Unmodified-Since"));
        Validate.isTrue((this.match == null || this.match.isEmpty() ? 1 : 0) != 0, (String)String.format(ERROR_MESSAGE, "If-None-Match", "If-Match"));
        if (tag == null) {
            tag = Tag.ALL;
        }
        if (Tag.ALL.equals(tag)) {
            this.nonMatch.clear();
        }
        if (this.nonMatch.contains(Tag.ALL)) {
            throw new IllegalArgumentException("Tag ALL already in the list");
        }
        this.nonMatch.add(tag);
    }

    public void setIfModifiedSince(DateTime time) {
        Validate.isTrue((this.match == null || this.match.isEmpty() ? 1 : 0) != 0, (String)String.format(ERROR_MESSAGE, "If-Modified-Since", "If-Match"));
        Validate.isTrue((this.unModifiedSince == null ? 1 : 0) != 0, (String)String.format(ERROR_MESSAGE, "If-Modified-Since", "If-Unmodified-Since"));
        this.modifiedSince = time;
    }

    public void setIfUnModifiedSince(DateTime time) {
        Validate.isTrue((this.nonMatch == null || this.nonMatch.isEmpty() ? 1 : 0) != 0, (String)String.format(ERROR_MESSAGE, "If-Unmodified-Since", "If-None-Match"));
        Validate.isTrue((this.modifiedSince == null ? 1 : 0) != 0, (String)String.format(ERROR_MESSAGE, "If-Unmodified-Since", "If-Modified-Since"));
        this.unModifiedSince = time;
    }

    public List<Tag> getMatch() {
        return Collections.unmodifiableList(this.match);
    }

    public List<Tag> getNonMatch() {
        return Collections.unmodifiableList(this.nonMatch);
    }

    public DateTime getModifiedSince() {
        return this.modifiedSince;
    }

    public DateTime getUnModifiedSince() {
        return this.unModifiedSince;
    }

    public Headers toHeaders() {
        Headers headers = new Headers();
        if (!this.getMatch().isEmpty()) {
            headers.add(new Header("If-Match", this.buildTagHeaderValue(this.getMatch())));
        }
        if (!this.getNonMatch().isEmpty()) {
            headers.add(new Header("If-None-Match", this.buildTagHeaderValue(this.getNonMatch())));
        }
        if (this.modifiedSince != null) {
            headers.add(HTTPUtils.toHttpDate("If-Modified-Since", this.modifiedSince));
        }
        if (this.unModifiedSince != null) {
            headers.add(HTTPUtils.toHttpDate("If-Unmodified-Since", this.unModifiedSince));
        }
        return headers;
    }

    private String buildTagHeaderValue(List<Tag> match) {
        StringBuilder builder = new StringBuilder();
        for (Tag tag : match) {
            if (builder.length() > 0) {
                builder.append(", ");
            }
            builder.append(tag.format());
        }
        return builder.toString();
    }
}

