/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.compiler;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;
import java.security.CodeSource;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.codehaus.groovy.eclipse.compiler.InternalCompiler;
import org.codehaus.plexus.compiler.AbstractCompiler;
import org.codehaus.plexus.compiler.Compiler;
import org.codehaus.plexus.compiler.CompilerConfiguration;
import org.codehaus.plexus.compiler.CompilerException;
import org.codehaus.plexus.compiler.CompilerMessage;
import org.codehaus.plexus.compiler.CompilerOutputStyle;
import org.codehaus.plexus.compiler.CompilerResult;
import org.codehaus.plexus.compiler.util.scan.InclusionScanException;
import org.codehaus.plexus.compiler.util.scan.SourceInclusionScanner;
import org.codehaus.plexus.compiler.util.scan.StaleSourceScanner;
import org.codehaus.plexus.compiler.util.scan.mapping.SourceMapping;
import org.codehaus.plexus.compiler.util.scan.mapping.SuffixMapping;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.logging.Logger;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.Os;
import org.codehaus.plexus.util.cli.CommandLineUtils;
import org.codehaus.plexus.util.cli.Commandline;
import org.codehaus.plexus.util.cli.StreamConsumer;

@Component(role=Compiler.class, hint="groovy-eclipse-compiler")
public class GroovyEclipseCompiler
extends AbstractCompiler {
    private static final String PROBLEM_SEPARATOR = "----------\r?\n";
    private final List<String> vmArgs = new ArrayList<String>();
    private boolean verbose = false;
    private String javaAgentClass = "";

    public GroovyEclipseCompiler() {
        super(CompilerOutputStyle.ONE_OUTPUT_FILE_PER_INPUT_FILE, "", ".class", null);
    }

    public String getJavaAgentClass() {
        return this.javaAgentClass;
    }

    public void setJavaAgentClass(String javaAgentClass) {
        this.javaAgentClass = javaAgentClass;
    }

    public CompilerResult performCompile(CompilerConfiguration config) throws CompilerException {
        try {
            Class.forName("org.eclipse.jdt.core.compiler.CompilationProgress");
        }
        catch (Exception e) {
            throw new CompilerException("Could not find groovy-eclipse-batch artifact. Must add this artifact as an explicit dependency in the pom.");
        }
        Object[] args = this.createCommandLine(config);
        if (args.length == 0) {
            this.getLogger().info("Nothing to compile - all classes are up to date");
            return new CompilerResult(true, Collections.EMPTY_LIST);
        }
        if (config.isFork()) {
            String executable = config.getExecutable();
            if (GroovyEclipseCompiler.isBlank(executable)) {
                try {
                    executable = this.getJavaExecutable();
                }
                catch (IOException e) {
                    this.getLogger().warn("Unable to autodetect 'java' path, using 'java' from the environment.");
                    executable = "java";
                }
            }
            String groovyEclipseLocation = this.getGroovyEclipseBatchLocation();
            return this.compileOutOfProcess(config, executable, groovyEclipseLocation, (String[])args);
        }
        StringWriter out = new StringWriter();
        if (this.verbose) {
            this.getLogger().info("Compiler arguments: " + Arrays.toString(args));
        }
        InternalCompiler.Result result = InternalCompiler.doCompile((String[])args, out, this.getLogger(), this.verbose);
        List<CompilerMessage> messages = this.parseMessages(result.success ? 0 : 1, out.getBuffer().toString(), config.isShowWarnings() || config.isVerbose());
        if (!result.success) {
            messages.add(this.formatResult(result.success, result.globalErrorsCount, result.globalWarningsCount));
        }
        return new CompilerResult(result.success, messages);
    }

    private File[] recalculateStaleFiles(CompilerConfiguration config) throws CompilerException {
        config.setSourceFiles(null);
        long staleMillis = 0L;
        Set<String> includes = config.getIncludes();
        if (includes == null || includes.isEmpty()) {
            includes = Collections.singleton("**/*");
        }
        Set<File> staleSources = this.computeStaleSources(config, (SourceInclusionScanner)new StaleSourceScanner(staleMillis, includes, config.getExcludes()));
        config.setSourceFiles(staleSources);
        return staleSources.toArray(new File[staleSources.size()]);
    }

    private Set<File> computeStaleSources(CompilerConfiguration compilerConfiguration, SourceInclusionScanner scanner) throws CompilerException {
        scanner.addSourceMapping((SourceMapping)new SuffixMapping(".groovy", ".class"));
        scanner.addSourceMapping((SourceMapping)new SuffixMapping(".java", ".class"));
        File outputDirectory = new File(compilerConfiguration.getOutputLocation());
        TreeSet<File> staleSources = new TreeSet<File>();
        for (String sourceRoot : compilerConfiguration.getSourceLocations()) {
            File sourcePath = new File(sourceRoot);
            if (!sourcePath.isDirectory() || sourcePath.equals(compilerConfiguration.getGeneratedSourcesDirectory())) continue;
            if (this.verbose) {
                this.getLogger().info("Looking for sources in source root: " + sourceRoot);
            }
            try {
                staleSources.addAll(scanner.getIncludedSources(sourcePath, outputDirectory));
            }
            catch (InclusionScanException e) {
                throw new CompilerException("Error scanning source root: '" + sourceRoot + "' for stale files to recompile.", (Throwable)e);
            }
        }
        return staleSources;
    }

    private CompilerMessage formatResult(boolean result, int globalErrorsCount, int globalWarningsCount) {
        if (result) {
            return new CompilerMessage("Success!", CompilerMessage.Kind.NOTE);
        }
        CompilerMessage.Kind kind = globalErrorsCount > 0 ? CompilerMessage.Kind.ERROR : (globalWarningsCount > 0 ? CompilerMessage.Kind.WARNING : CompilerMessage.Kind.NOTE);
        String error = globalErrorsCount == 1 ? "error" : "errors";
        String warning = globalWarningsCount == 1 ? "warning" : "warnings";
        return new CompilerMessage("Found " + globalErrorsCount + " " + error + " and " + globalWarningsCount + " " + warning + ".", kind);
    }

    private Map<String, String> composeSourceFiles(File[] sourceFiles) {
        DeduplicatingHashMap<String, String> sources = new DeduplicatingHashMap<String, String>(this.getLogger(), sourceFiles.length);
        for (File sourceFile : sourceFiles) {
            sources.put(sourceFile.getPath(), null);
        }
        return sources;
    }

    public String[] createCommandLine(CompilerConfiguration config) throws CompilerException {
        String release;
        File[] sourceFiles;
        File srcTestGroovy;
        File srcMainGroovy;
        File destinationDir = new File(config.getOutputLocation());
        if (!destinationDir.exists()) {
            destinationDir.mkdirs();
        }
        File workingDirectory = config.getWorkingDirectory();
        if (destinationDir.getName().equals("classes") && (srcMainGroovy = new File(workingDirectory, "src/main/groovy")).exists() && !config.getSourceLocations().contains(srcMainGroovy.getAbsolutePath())) {
            config.addSourceLocation(srcMainGroovy.getAbsolutePath());
        }
        if (destinationDir.getName().equals("test-classes") && (srcTestGroovy = new File(workingDirectory, "src/test/groovy")).exists() && !config.getSourceLocations().contains(srcTestGroovy.getAbsolutePath())) {
            config.addSourceLocation(srcTestGroovy.getAbsolutePath());
        }
        if ((sourceFiles = this.recalculateStaleFiles(config)).length == 0) {
            return new String[0];
        }
        this.getLogger().info("Using Groovy-Eclipse compiler to compile both Java and Groovy files");
        this.getLogger().debug(String.format("Compiling %d source file%s to %s", sourceFiles.length, sourceFiles.length == 1 ? "" : "s", destinationDir.getAbsolutePath()));
        DeduplicatingHashMap<String, String> args = new DeduplicatingHashMap<String, String>(this.getLogger());
        this.verbose = config.isVerbose();
        if (this.verbose) {
            args.put("-verbose", null);
        }
        String cp = GroovyEclipseCompiler.getPathString((List)config.getClasspathEntries());
        if (this.verbose) {
            this.getLogger().info("Classpath: " + cp);
        }
        if (GroovyEclipseCompiler.isNotBlank(cp)) {
            args.put("-cp", cp.trim());
        }
        String mp = GroovyEclipseCompiler.getPathString((List)config.getModulepathEntries());
        if (this.verbose) {
            this.getLogger().info("Modulepath: " + mp);
        }
        if (GroovyEclipseCompiler.isNotBlank(mp)) {
            args.put("-p", mp.trim());
        }
        if (GroovyEclipseCompiler.isNotBlank(config.getOutputLocation())) {
            args.put("-d", config.getOutputLocation().trim());
        }
        if (config.getGeneratedSourcesDirectory() != null) {
            args.put("-s", config.getGeneratedSourcesDirectory().getAbsolutePath());
        }
        if (config.isDebug()) {
            if (GroovyEclipseCompiler.isNotBlank(config.getDebugLevel())) {
                args.put("-g:" + config.getDebugLevel().trim(), null);
            } else {
                args.put("-g", null);
            }
        }
        if (GroovyEclipseCompiler.isNotBlank(config.getSourceEncoding())) {
            args.put("-encoding", config.getSourceEncoding().trim());
        }
        if (GroovyEclipseCompiler.isNotBlank(release = config.getReleaseVersion())) {
            args.put("--release", release.trim());
        } else {
            Object target;
            String source = config.getSourceVersion();
            if (GroovyEclipseCompiler.isNotBlank(source)) {
                args.put("-source", source.trim());
            }
            if (GroovyEclipseCompiler.isNotBlank((String)(target = config.getTargetVersion()))) {
                args.put("-target", ((String)target).trim());
            }
        }
        if (config.isShowDeprecation()) {
            args.put("-deprecation", null);
        }
        if (!config.isShowWarnings()) {
            args.put("-nowarn", null);
        }
        if (config.isParameters()) {
            args.put("-parameters", null);
        }
        if ("none".equals(config.getProc())) {
            args.put("-proc:none", null);
        } else if ("only".equals(config.getProc())) {
            args.put("-proc:only", null);
        }
        if (config.getAnnotationProcessors() != null) {
            StringBuilder processor = new StringBuilder();
            for (String item : config.getAnnotationProcessors()) {
                if (!GroovyEclipseCompiler.isNotBlank(item)) continue;
                processor.append(item.trim()).append(',');
            }
            if (processor.length() > 0) {
                processor.setLength(processor.length() - 1);
                args.put("-processor", processor.toString());
            }
        }
        if (config.getProcessorPathEntries() != null) {
            StringBuilder processorpath = new StringBuilder();
            for (String item : config.getProcessorPathEntries()) {
                if (!GroovyEclipseCompiler.isNotBlank(item)) continue;
                processorpath.append(item.trim()).append(';');
            }
            if (processorpath.length() > 0) {
                processorpath.setLength(processorpath.length() - 1);
                args.put("-processorpath", processorpath.toString());
            }
        }
        for (Map.Entry entry : config.getCustomCompilerArgumentsAsMap().entrySet()) {
            String key = (String)entry.getKey();
            if (GroovyEclipseCompiler.startsWithHyphen(key)) {
                if ("-javaAgentClass".equals(key)) {
                    this.setJavaAgentClass((String)entry.getValue());
                    continue;
                }
                if (!key.startsWith("-J")) {
                    args.put(key, (String)entry.getValue());
                    continue;
                }
                this.vmArgs.add(key.substring(2));
                continue;
            }
            if ("org.osgi.framework.system.packages".equals(key)) continue;
            args.put("-" + key, (String)entry.getValue());
        }
        args.putAll(this.composeSourceFiles(sourceFiles));
        return GroovyEclipseCompiler.flattenArgumentsMap(args);
    }

    private CompilerResult compileOutOfProcess(CompilerConfiguration config, String executable, String groovyEclipseLocation, String[] args) throws CompilerException {
        int returnCode;
        Commandline cli = new Commandline();
        cli.setWorkingDirectory(config.getWorkingDirectory().getAbsolutePath());
        cli.setExecutable(executable);
        try {
            if (GroovyEclipseCompiler.isNotBlank(this.javaAgentClass)) {
                cli.addArguments(new String[]{"-javaagent:" + this.getAdditionnalJavaAgentLocation()});
            }
            if (GroovyEclipseCompiler.isNotBlank(config.getMeminitial())) {
                cli.addArguments(new String[]{"-Xms" + config.getMeminitial()});
            }
            if (GroovyEclipseCompiler.isNotBlank(config.getMaxmem())) {
                cli.addArguments(new String[]{"-Xmx" + config.getMaxmem()});
            }
            if (!this.vmArgs.isEmpty()) {
                cli.addArguments(this.vmArgs.toArray(new String[this.vmArgs.size()]));
            }
            cli.addArguments(new String[]{"-jar", groovyEclipseLocation});
            if (this.verbose) {
                this.getLogger().info("Compiler arguments: " + Arrays.toString(args));
            }
            File argumentsFile = this.createFileWithArguments(args, config.getOutputLocation());
            cli.addArguments(new String[]{"@" + argumentsFile.getCanonicalPath()});
        }
        catch (IOException e) {
            throw new CompilerException("Error creating file with javac arguments", (Throwable)e);
        }
        CommandLineUtils.StringStreamConsumer out = new CommandLineUtils.StringStreamConsumer();
        CommandLineUtils.StringStreamConsumer err = new CommandLineUtils.StringStreamConsumer();
        if (this.getLogger().isDebugEnabled()) {
            File commandLineFile = new File(config.getOutputLocation(), "greclipse." + (Os.isFamily((String)"windows") ? "bat" : "sh"));
            try {
                FileUtils.fileWrite((String)commandLineFile.getAbsolutePath(), (String)cli.toString().replaceAll("'", ""));
                if (!Os.isFamily((String)"windows")) {
                    Runtime.getRuntime().exec(new String[]{"chmod", "a+x", commandLineFile.getAbsolutePath()});
                }
            }
            catch (IOException e) {
                this.getLogger().warn("Unable to write '" + commandLineFile.getName() + "' debug script file", (Throwable)e);
            }
        }
        this.getLogger().info(this.verbose ? cli.toString() : "Compiling in a forked process using " + groovyEclipseLocation);
        try {
            returnCode = CommandLineUtils.executeCommandLine((Commandline)cli, (StreamConsumer)out, (StreamConsumer)err);
        }
        catch (Exception e) {
            throw new CompilerException("Error while executing the external compiler.", (Throwable)e);
        }
        List<CompilerMessage> messages = this.parseMessages(returnCode, out.getOutput(), config.isShowWarnings() || config.isVerbose());
        if (returnCode != 0 && messages.isEmpty()) {
            if (GroovyEclipseCompiler.isBlank(err.getOutput())) {
                throw new CompilerException("Unknown error trying to execute the external compiler: " + EOL + cli.toString());
            }
            messages.add(new CompilerMessage("Failure executing groovy-eclipse compiler:" + EOL + err.getOutput(), CompilerMessage.Kind.ERROR));
        } else if (GroovyEclipseCompiler.isNotBlank(err.getOutput())) {
            this.getLogger().warn("Error output from groovy-eclipse compiler:" + EOL + err.getOutput());
        }
        return new CompilerResult(returnCode == 0, messages);
    }

    private List<CompilerMessage> parseMessages(int exitCode, String input, boolean showWarnings) {
        ArrayList<CompilerMessage> parsedMessages = new ArrayList<CompilerMessage>();
        for (String msg : input.split(PROBLEM_SEPARATOR)) {
            if (GroovyEclipseCompiler.isBlank(msg)) continue;
            CompilerMessage message = this.parseMessage(msg, showWarnings, false);
            if (message != null) {
                if (!showWarnings && message.getKind() != CompilerMessage.Kind.ERROR) continue;
                parsedMessages.add(message);
                continue;
            }
            StringBuilder unrecognized = new StringBuilder();
            for (String line : msg.split("\n")) {
                if (line.indexOf(". WARNING") > 0 || line.indexOf(". ERROR") > 0) {
                    message = this.parseMessage(line, showWarnings, true);
                    if (!showWarnings && message.getKind() != CompilerMessage.Kind.ERROR) continue;
                    parsedMessages.add(message);
                    continue;
                }
                if (PROBLEM_SEPARATOR.equals(line)) continue;
                unrecognized.append(line).append("\n");
            }
            if (unrecognized.length() <= 0) continue;
            message = this.parseMessage(unrecognized.toString(), showWarnings, true);
            if (!showWarnings && message.getKind() == CompilerMessage.Kind.WARNING) continue;
            parsedMessages.add(message);
        }
        return parsedMessages;
    }

    private CompilerMessage parseMessage(String msgText, boolean showWarning, boolean force) {
        Matcher m = Pattern.compile("^\\d+\\. (ERROR|WARNING|INFO) in (.+?) \\(at line (\\d+)\\)").matcher(msgText);
        boolean isNormal = m.find();
        CompilerMessage.Kind kind = CompilerMessage.Kind.NOTE;
        if (isNormal) {
            if (m.group(1).equals("ERROR")) {
                kind = CompilerMessage.Kind.ERROR;
            } else if (m.group(1).equals("WARNING")) {
                kind = CompilerMessage.Kind.WARNING;
            }
        }
        if (isNormal) {
            String[] parts = msgText.split("\r?\n", 2);
            try {
                String file = m.group(2);
                int line = Integer.parseInt(m.group(3));
                int lastLineIndex = parts[1].lastIndexOf("\n\t");
                int startColumn = parts[1].indexOf(94, lastLineIndex) - 1 - lastLineIndex;
                int endColumn = parts[1].lastIndexOf(94) - 1 - lastLineIndex;
                return new CompilerMessage(file, kind, line, startColumn, line, endColumn, EOL + msgText.trim());
            }
            catch (RuntimeException e) {
                if (force) {
                    return new CompilerMessage(msgText.trim(), kind);
                }
                return null;
            }
        }
        if (force) {
            return new CompilerMessage(msgText.trim(), kind);
        }
        return null;
    }

    private File createFileWithArguments(String[] args, String outputDirectory) throws IOException {
        File tempFile;
        if (this.getLogger().isDebugEnabled()) {
            tempFile = File.createTempFile(GroovyEclipseCompiler.class.getName(), ".txt", new File(outputDirectory));
        } else {
            tempFile = File.createTempFile(GroovyEclipseCompiler.class.getName(), ".txt");
            tempFile.deleteOnExit();
        }
        try (PrintWriter writer = new PrintWriter(new FileWriter(tempFile));){
            for (String arg : args) {
                String argValue = arg.replace(File.separatorChar, '/');
                writer.write("\"" + argValue + "\"");
                writer.println();
            }
            writer.flush();
        }
        return tempFile;
    }

    private String getAdditionnalJavaAgentLocation() throws CompilerException {
        return this.getClassLocation(this.getJavaAgentClass());
    }

    private String getGroovyEclipseBatchLocation() throws CompilerException {
        return this.getClassLocation("org.eclipse.jdt.internal.compiler.batch.Main");
    }

    private String getClassLocation(String className) throws CompilerException {
        Class<?> cls;
        try {
            cls = Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            throw new CompilerException("Cannot find the requested className <" + className + "> in classpath");
        }
        ProtectionDomain pDomain = cls.getProtectionDomain();
        CodeSource cSource = pDomain.getCodeSource();
        if (cSource != null) {
            File file;
            URL loc = cSource.getLocation();
            try {
                file = new File(URLDecoder.decode(loc.getPath(), "UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                this.getLogger().warn("Unsupported Encoding for URL: " + loc, (Throwable)e);
                file = new File(loc.getPath());
            }
            if (this.verbose) {
                this.getLogger().info("Found location <" + file.getPath() + "> for className <" + className + ">");
            }
            return file.getPath();
        }
        throw new CompilerException("Cannot find the location of the requested className <" + className + "> in classpath");
    }

    private String getJavaExecutable() throws IOException {
        String javaCommand = "java" + (Os.isFamily((String)"windows") ? ".exe" : "");
        String javaHome = System.getProperty("java.home");
        File javaExe = Os.isName((String)"AIX") ? new File(javaHome + File.separator + ".." + File.separator + "sh", javaCommand) : (Os.isName((String)"Mac OS X") ? new File(javaHome + File.separator + "bin", javaCommand) : new File(javaHome + File.separator + ".." + File.separator + "bin", javaCommand));
        if (!javaExe.isFile()) {
            Properties env = CommandLineUtils.getSystemEnvVars();
            javaHome = env.getProperty("JAVA_HOME");
            if (GroovyEclipseCompiler.isBlank(javaHome)) {
                throw new IOException("The environment variable JAVA_HOME is not correctly set.");
            }
            if (!new File(javaHome).isDirectory()) {
                throw new IOException("The environment variable JAVA_HOME=" + javaHome + " doesn't exist or is not a valid directory.");
            }
            javaExe = new File(env.getProperty("JAVA_HOME") + File.separator + "bin", javaCommand);
        }
        if (!javaExe.isFile()) {
            throw new IOException("The javadoc executable '" + javaExe + "' doesn't exist or is not a file. Verify the JAVA_HOME environment variable.");
        }
        return javaExe.getAbsolutePath();
    }

    private static String[] flattenArgumentsMap(Map<String, String> args) {
        ArrayList<String> argsList = new ArrayList<String>(args.size() * 2);
        for (Map.Entry<String, String> entry : args.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            if (key == null || key.length() <= 0) continue;
            argsList.add(key);
            if (!GroovyEclipseCompiler.isNotBlank(value)) continue;
            argsList.add(value);
        }
        return argsList.toArray(new String[0]);
    }

    private static boolean isBlank(String str) {
        return str == null || str.trim().length() == 0;
    }

    private static boolean isNotBlank(String str) {
        return !GroovyEclipseCompiler.isBlank(str);
    }

    private static boolean startsWithHyphen(Object key) {
        return key instanceof CharSequence && ((CharSequence)key).charAt(0) == '-';
    }

    private static class DeduplicatingHashMap<K, V>
    extends LinkedHashMap<K, V> {
        private static final long serialVersionUID = -589299605523895999L;
        private Logger logger;

        public DeduplicatingHashMap(Logger logger) {
            this.logger = logger;
        }

        public DeduplicatingHashMap(Logger logger, int initialCapacity) {
            super(initialCapacity);
            this.logger = logger;
        }

        @Override
        public V put(K k, V v) {
            if (this.containsKey(k) && this.logger.isDebugEnabled()) {
                this.logger.debug("Replacing compiler argument \"" + k + "\" old value: " + this.get(k) + " with: " + v);
            }
            return super.put(k, v);
        }

        @Override
        public void putAll(Map<? extends K, ? extends V> m) {
            for (Map.Entry<K, V> e : m.entrySet()) {
                this.put(e.getKey(), e.getValue());
            }
        }
    }
}

