/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.compiler;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;
import java.security.CodeSource;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import org.codehaus.plexus.compiler.AbstractCompiler;
import org.codehaus.plexus.compiler.CompilerConfiguration;
import org.codehaus.plexus.compiler.CompilerError;
import org.codehaus.plexus.compiler.CompilerException;
import org.codehaus.plexus.compiler.CompilerOutputStyle;
import org.codehaus.plexus.compiler.util.scan.InclusionScanException;
import org.codehaus.plexus.compiler.util.scan.SourceInclusionScanner;
import org.codehaus.plexus.compiler.util.scan.StaleSourceScanner;
import org.codehaus.plexus.compiler.util.scan.mapping.SourceMapping;
import org.codehaus.plexus.compiler.util.scan.mapping.SuffixMapping;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.Os;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.cli.CommandLineException;
import org.codehaus.plexus.util.cli.CommandLineUtils;
import org.codehaus.plexus.util.cli.Commandline;
import org.codehaus.plexus.util.cli.StreamConsumer;
import org.eclipse.jdt.core.compiler.CompilationProgress;
import org.eclipse.jdt.internal.compiler.batch.Main;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GroovyEclipseCompiler
extends AbstractCompiler {
    private static final String[] WARNING_PREFIXES = new String[]{"warning: ", "\u8b66\u544a: ", "\u8b66\u544a\uff1a "};
    private static final String[] NOTE_PREFIXES = new String[]{"Note: ", "\u6ce8: ", "\u6ce8\u610f\uff1a "};
    boolean verbose;

    public GroovyEclipseCompiler() {
        super(CompilerOutputStyle.ONE_OUTPUT_FILE_PER_INPUT_FILE, "", ".class", null);
    }

    public List compile(CompilerConfiguration config) throws CompilerException {
        List<CompilerError> messages;
        String[] args = this.createCommandLine(config);
        if (args.length == 0) {
            this.getLogger().info("Nothing to compile - all classes are up to date");
            return Collections.emptyList();
        }
        if (config.isFork()) {
            String executable = config.getExecutable();
            if (StringUtils.isEmpty((String)executable)) {
                try {
                    executable = this.getJavaExecutable();
                }
                catch (IOException e) {
                    this.getLogger().warn("Unable to autodetect 'java' path, using 'java' from the environment.");
                    executable = "java";
                }
            }
            String groovyEclipseLocation = this.getGroovyEclipseBatchLocation();
            messages = this.compileOutOfProcess(config, executable, groovyEclipseLocation, args);
        } else {
            Progress progress = new Progress();
            Main main = new Main(new PrintWriter(System.out), new PrintWriter(System.err), false, null, (CompilationProgress)progress);
            boolean result = main.compile(args);
            messages = this.formatResult(main, result);
        }
        return messages;
    }

    private File[] recalculateStaleFiles(CompilerConfiguration config) throws CompilerException {
        config.setSourceFiles(null);
        long staleMillis = 0L;
        Set<String> includes = config.getIncludes();
        if (includes == null || includes.isEmpty()) {
            includes = Collections.singleton("**/*");
        }
        StaleSourceScanner scanner = new StaleSourceScanner(staleMillis, includes, config.getExcludes());
        Set<File> staleSources = this.computeStaleSources(config, (SourceInclusionScanner)scanner);
        config.setSourceFiles(staleSources);
        File[] sourceFiles = staleSources.toArray(new File[0]);
        return sourceFiles;
    }

    private boolean startsWithHyphen(Object key) {
        return null != key && String.class.isInstance(key) && ((String)key).startsWith("-");
    }

    private List<CompilerError> formatResult(Main main, boolean result) {
        if (result) {
            return Collections.EMPTY_LIST;
        }
        String error = main.globalErrorsCount == 1 ? "error" : "errors";
        String warning = main.globalWarningsCount == 1 ? "warning" : "warnings";
        return Collections.singletonList(new CompilerError("Found " + main.globalErrorsCount + " " + error + " and " + main.globalWarningsCount + " " + warning + ".", true));
    }

    private List<String> composeSourceFiles(File[] sourceFiles) {
        ArrayList<String> sources = new ArrayList<String>(sourceFiles.length);
        for (int i = 0; i < sourceFiles.length; ++i) {
            sources.add(sourceFiles[i].getPath());
        }
        return sources;
    }

    public String[] createCommandLine(CompilerConfiguration config) throws CompilerException {
        File[] sourceFiles;
        File destinationDir = new File(config.getOutputLocation());
        if (!destinationDir.exists()) {
            destinationDir.mkdirs();
        }
        if ((sourceFiles = this.recalculateStaleFiles(config)).length == 0) {
            return new String[0];
        }
        this.getLogger().info("Using Groovy-Eclipse compiler to compile both Java and Groovy files");
        this.getLogger().info("Compiling " + sourceFiles.length + " " + "source file" + (sourceFiles.length == 1 ? "" : "s") + " to " + destinationDir.getAbsolutePath());
        ArrayList<String> args = new ArrayList<String>();
        String cp = AbstractCompiler.getPathString((List)config.getClasspathEntries());
        this.verbose = config.isVerbose();
        if (this.verbose) {
            this.getLogger().info("Classpath: " + cp);
        }
        if (cp.length() > 0) {
            args.add("-cp");
            args.add(cp);
        }
        if (config.getOutputLocation() != null && config.getOutputLocation().length() > 0) {
            args.add("-d");
            args.add(config.getOutputLocation());
        }
        if (config.isDebug()) {
            if (config.getDebugLevel() != null && config.getDebugLevel().trim().length() > 0) {
                args.add("-g:" + config.getDebugLevel());
            } else {
                args.add("-g");
            }
        }
        if ("none".equals(config.getProc())) {
            args.add("-proc:none");
        } else if ("only".equals(config.getProc())) {
            args.add("-proc:only");
        }
        if (config.getGeneratedSourcesDirectory() != null) {
            args.add("-s");
            args.add(config.getGeneratedSourcesDirectory().getAbsolutePath());
        }
        String source = config.getSourceVersion();
        args.add("-source");
        if (source != null && source.length() > 0) {
            args.add(source);
        } else {
            args.add("1.5");
        }
        String target = config.getTargetVersion();
        args.add("-target");
        if (target != null && target.length() > 0) {
            args.add(target);
        } else {
            args.add("1.5");
        }
        if (config.isShowDeprecation()) {
            args.add("-deprecation");
        }
        if (!config.isShowWarnings()) {
            args.add("-nowarn");
        }
        if (config.getAnnotationProcessors() != null) {
            StringBuilder procArg = new StringBuilder();
            for (String proc : config.getAnnotationProcessors()) {
                if (proc == null || proc.trim().length() <= 0) continue;
                procArg.append(proc);
                procArg.append(",");
            }
            if (procArg.length() > 0) {
                args.add("-processor ");
                procArg.replace(procArg.length() - 1, procArg.length(), "");
                args.add("\"" + procArg.toString() + "\"");
            }
        }
        if (this.verbose) {
            args.add("-verbose");
        }
        if (this.verbose) {
            this.getLogger().info("All args: " + args);
        }
        if (config.getSourceEncoding() != null) {
            args.add("-encoding");
            args.add(config.getSourceEncoding());
        }
        for (Map.Entry entry : config.getCustomCompilerArguments().entrySet()) {
            Object key = entry.getKey();
            if (this.startsWithHyphen(key)) {
                args.add((String)key);
                continue;
            }
            if (key == null) continue;
            args.add("-" + key);
            if (null == entry.getValue()) continue;
            args.add("\"" + entry.getValue() + "\"");
        }
        args.addAll(this.composeSourceFiles(sourceFiles));
        return args.toArray(new String[args.size()]);
    }

    private Set<File> computeStaleSources(CompilerConfiguration compilerConfiguration, SourceInclusionScanner scanner) throws CompilerException {
        SuffixMapping mappingGroovy = new SuffixMapping(".groovy", ".class");
        SuffixMapping mappingJava = new SuffixMapping(".java", ".class");
        scanner.addSourceMapping((SourceMapping)mappingGroovy);
        scanner.addSourceMapping((SourceMapping)mappingJava);
        File outputDirectory = new File(compilerConfiguration.getOutputLocation());
        HashSet<File> staleSources = new HashSet<File>();
        for (String sourceRoot : compilerConfiguration.getSourceLocations()) {
            File rootFile = new File(sourceRoot);
            if (!rootFile.isDirectory()) continue;
            try {
                staleSources.addAll(scanner.getIncludedSources(rootFile, outputDirectory));
            }
            catch (InclusionScanException e) {
                throw new CompilerException("Error scanning source root: '" + sourceRoot + "' " + "for stale files to recompile.", (Throwable)e);
            }
        }
        return staleSources;
    }

    private List<CompilerError> compileOutOfProcess(CompilerConfiguration config, String executable, String groovyEclipseLocation, String[] args) throws CompilerException {
        List<CompilerError> messages;
        int returnCode;
        CommandLineUtils.StringStreamConsumer err;
        CommandLineUtils.StringStreamConsumer out;
        Commandline cli;
        block13: {
            cli = new Commandline();
            cli.setWorkingDirectory(config.getWorkingDirectory().getAbsolutePath());
            cli.setExecutable(executable);
            try {
                cli.addArguments(new String[]{"-jar", groovyEclipseLocation});
                File argumentsFile = this.createFileWithArguments(args, config.getOutputLocation());
                cli.addArguments(new String[]{"@" + argumentsFile.getCanonicalPath().replace(File.separatorChar, '/')});
                if (!StringUtils.isEmpty((String)config.getMaxmem())) {
                    cli.addArguments(new String[]{"-J-Xmx" + config.getMaxmem()});
                }
                if (!StringUtils.isEmpty((String)config.getMeminitial())) {
                    cli.addArguments(new String[]{"-J-Xms" + config.getMeminitial()});
                }
            }
            catch (IOException e) {
                throw new CompilerException("Error creating file with javac arguments", (Throwable)e);
            }
            out = new CommandLineUtils.StringStreamConsumer();
            err = new CommandLineUtils.StringStreamConsumer();
            if (this.getLogger() != null && this.getLogger().isDebugEnabled()) {
                File commandLineFile = new File(config.getOutputLocation(), "greclipse." + (Os.isFamily((String)"windows") ? "bat" : "sh"));
                try {
                    FileUtils.fileWrite((String)commandLineFile.getAbsolutePath(), (String)cli.toString().replaceAll("'", ""));
                    if (!Os.isFamily((String)"windows")) {
                        Runtime.getRuntime().exec(new String[]{"chmod", "a+x", commandLineFile.getAbsolutePath()});
                    }
                }
                catch (IOException e) {
                    if (this.getLogger() == null || !this.getLogger().isWarnEnabled()) break block13;
                    this.getLogger().warn("Unable to write '" + commandLineFile.getName() + "' debug script file", (Throwable)e);
                }
            }
        }
        try {
            this.getLogger().info("Compiling in a forked process using " + groovyEclipseLocation);
            returnCode = CommandLineUtils.executeCommandLine((Commandline)cli, (StreamConsumer)out, (StreamConsumer)err);
            messages = this.parseModernStream(returnCode, new BufferedReader(new StringReader(err.getOutput())));
        }
        catch (CommandLineException e) {
            throw new CompilerException("Error while executing the external compiler.", (Throwable)e);
        }
        catch (IOException e) {
            throw new CompilerException("Error while executing the external compiler.", (Throwable)e);
        }
        if (returnCode != 0 && messages.isEmpty()) {
            if (err.getOutput().length() == 0) {
                throw new CompilerException("Unknown error trying to execute the external compiler: " + EOL + cli.toString());
            }
            messages.add(new CompilerError("Failure executing groovy-eclipse compiler:" + EOL + err.getOutput(), true));
        }
        return messages;
    }

    List<CompilerError> parseModernStream(int exitCode, BufferedReader input) throws IOException {
        ArrayList<CompilerError> errors = new ArrayList<CompilerError>();
        while (true) {
            String line;
            StringBuffer buffer = new StringBuffer();
            do {
                if ((line = input.readLine()) == null) {
                    return errors;
                }
                if (buffer.length() == 0 && line.startsWith("error: ")) {
                    errors.add(new CompilerError(line, true));
                    continue;
                }
                if (buffer.length() == 0 && GroovyEclipseCompiler.isNote(line)) continue;
                buffer.append(line);
                buffer.append(EOL);
            } while (!line.endsWith("^"));
            errors.add(GroovyEclipseCompiler.parseModernError(exitCode, buffer.toString()));
        }
    }

    private static boolean isNote(String line) {
        for (int i = 0; i < NOTE_PREFIXES.length; ++i) {
            if (!line.startsWith(NOTE_PREFIXES[i])) continue;
            return true;
        }
        return false;
    }

    static CompilerError parseModernError(int exitCode, String error) {
        StringTokenizer tokens = new StringTokenizer(error, ":");
        boolean isError = exitCode != 0;
        try {
            int endcolumn;
            boolean tokenIsAnInteger;
            String previousToken = null;
            String currentToken = null;
            do {
                previousToken = currentToken;
                currentToken = tokens.nextToken();
                tokenIsAnInteger = true;
                try {
                    Integer.parseInt(currentToken);
                }
                catch (NumberFormatException e) {
                    tokenIsAnInteger = false;
                }
            } while (!tokenIsAnInteger);
            String file = previousToken;
            String lineIndicator = currentToken;
            int startOfFileName = previousToken.lastIndexOf("]");
            if (startOfFileName > -1) {
                file = file.substring(startOfFileName + 2);
            }
            if (file.length() == 1) {
                file = new StringBuffer(file).append(":").append(tokens.nextToken()).toString();
            }
            int line = Integer.parseInt(lineIndicator);
            StringBuffer msgBuffer = new StringBuffer();
            String msg = tokens.nextToken(EOL).substring(2);
            isError = exitCode != 0;
            String warnPrefix = GroovyEclipseCompiler.getWarnPrefix(msg);
            if (warnPrefix != null) {
                isError = false;
                msg = msg.substring(warnPrefix.length());
            }
            msgBuffer.append(msg);
            msgBuffer.append(EOL);
            String context = tokens.nextToken(EOL);
            String pointer = tokens.nextToken(EOL);
            if (tokens.hasMoreTokens()) {
                msgBuffer.append(context);
                msgBuffer.append(EOL);
                msgBuffer.append(pointer);
                msgBuffer.append(EOL);
                context = tokens.nextToken(EOL);
                try {
                    pointer = tokens.nextToken(EOL);
                }
                catch (NoSuchElementException e) {
                    pointer = context;
                    context = null;
                }
            }
            String message = msgBuffer.toString();
            int startcolumn = pointer.indexOf("^");
            int n = endcolumn = context == null ? startcolumn : context.indexOf(" ", startcolumn);
            if (endcolumn == -1) {
                endcolumn = context.length();
            }
            return new CompilerError(file, isError, line, startcolumn, line, endcolumn, message.trim());
        }
        catch (NoSuchElementException e) {
            return new CompilerError("no more tokens - could not parse error message: " + error, isError);
        }
        catch (NumberFormatException e) {
            return new CompilerError("could not parse error message: " + error, isError);
        }
        catch (Exception e) {
            return new CompilerError("could not parse error message: " + error, isError);
        }
    }

    private static String getWarnPrefix(String msg) {
        for (int i = 0; i < WARNING_PREFIXES.length; ++i) {
            if (!msg.startsWith(WARNING_PREFIXES[i])) continue;
            return WARNING_PREFIXES[i];
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File createFileWithArguments(String[] args, String outputDirectory) throws IOException {
        PrintWriter writer = null;
        try {
            File tempFile;
            if (this.getLogger() != null && this.getLogger().isDebugEnabled()) {
                tempFile = File.createTempFile(GroovyEclipseCompiler.class.getName(), "arguments", new File(outputDirectory));
            } else {
                tempFile = File.createTempFile(GroovyEclipseCompiler.class.getName(), "arguments");
                tempFile.deleteOnExit();
            }
            writer = new PrintWriter(new FileWriter(tempFile));
            for (int i = 0; i < args.length; ++i) {
                String argValue = args[i].replace(File.separatorChar, '/');
                writer.write("\"" + argValue + "\"");
                writer.println();
            }
            writer.flush();
            File file = tempFile;
            return file;
        }
        finally {
            if (writer != null) {
                writer.close();
            }
        }
    }

    private String getGroovyEclipseBatchLocation() throws CompilerException {
        Class<Main> cls = Main.class;
        ProtectionDomain pDomain = cls.getProtectionDomain();
        CodeSource cSource = pDomain.getCodeSource();
        if (cSource != null) {
            File file;
            URL loc = cSource.getLocation();
            try {
                file = new File(URLDecoder.decode(loc.getPath(), "UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                this.getLogger().warn("Unsupported Encoding for URL: " + loc, (Throwable)e);
                file = new File(loc.getPath());
            }
            return file.getPath();
        }
        throw new CompilerException("Cannot find the location of groovy-eclipse-batch jar");
    }

    private String getJavaExecutable() throws IOException {
        String javaCommand = "java" + (Os.isFamily((String)"windows") ? ".exe" : "");
        String javaHome = System.getProperty("java.home");
        File javaExe = Os.isName((String)"AIX") ? new File(javaHome + File.separator + ".." + File.separator + "sh", javaCommand) : (Os.isName((String)"Mac OS X") ? new File(javaHome + File.separator + "bin", javaCommand) : new File(javaHome + File.separator + ".." + File.separator + "bin", javaCommand));
        if (!javaExe.isFile()) {
            Properties env = CommandLineUtils.getSystemEnvVars();
            javaHome = env.getProperty("JAVA_HOME");
            if (StringUtils.isEmpty((String)javaHome)) {
                throw new IOException("The environment variable JAVA_HOME is not correctly set.");
            }
            if (!new File(javaHome).isDirectory()) {
                throw new IOException("The environment variable JAVA_HOME=" + javaHome + " doesn't exist or is not a valid directory.");
            }
            javaExe = new File(env.getProperty("JAVA_HOME") + File.separator + "bin", javaCommand);
        }
        if (!javaExe.isFile()) {
            throw new IOException("The javadoc executable '" + javaExe + "' doesn't exist or is not a file. Verify the JAVA_HOME environment variable.");
        }
        return javaExe.getAbsolutePath();
    }

    private class Progress
    extends CompilationProgress {
        int numCompiled = 0;

        private Progress() {
        }

        public void begin(int remainingWork) {
        }

        public void done() {
        }

        public boolean isCanceled() {
            return false;
        }

        public void setTaskName(String newTaskName) {
        }

        public void worked(int workIncrement, int remainingWork) {
            if (GroovyEclipseCompiler.this.verbose) {
                String file = remainingWork == 1 ? "file" : "files";
                GroovyEclipseCompiler.this.getLogger().info(remainingWork + " " + file + " left.");
            }
            ++this.numCompiled;
        }
    }
}

