/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core.search;

import java.io.EOFException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicLong;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.preferences.IPreferencesService;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.IParallelizable;
import org.eclipse.jdt.core.search.SearchParticipant;
import org.eclipse.jdt.core.search.SearchPattern;
import org.eclipse.jdt.internal.compiler.env.AccessRuleSet;
import org.eclipse.jdt.internal.core.JavaModelManager;
import org.eclipse.jdt.internal.core.index.FileIndexLocation;
import org.eclipse.jdt.internal.core.index.Index;
import org.eclipse.jdt.internal.core.index.IndexLocation;
import org.eclipse.jdt.internal.core.search.AbstractSearchScope;
import org.eclipse.jdt.internal.core.search.IndexQueryRequestor;
import org.eclipse.jdt.internal.core.search.JavaSearchParticipant;
import org.eclipse.jdt.internal.core.search.indexing.ReadWriteMonitor;
import org.eclipse.jdt.internal.core.search.matching.MatchLocator;
import org.eclipse.jdt.internal.core.search.processing.IJob;
import org.eclipse.jdt.internal.core.search.processing.JobManager;
import org.eclipse.jdt.internal.core.util.Util;

public class PatternSearchJob
implements IJob {
    protected SearchPattern pattern;
    protected IJavaSearchScope scope;
    protected SearchParticipant participant;
    protected IndexQueryRequestor requestor;
    protected boolean areIndexesReady;
    protected AtomicLong executionTime = new AtomicLong(0L);
    boolean parallel;
    public static final String ENABLE_PARALLEL_SEARCH = "enableParallelJavaIndexSearch";
    public static final boolean ENABLE_PARALLEL_SEARCH_DEFAULT = true;

    public PatternSearchJob(SearchPattern pattern, SearchParticipant participant, IJavaSearchScope scope, IndexQueryRequestor requestor) {
        this.pattern = pattern;
        this.participant = participant;
        this.scope = scope;
        this.requestor = requestor;
    }

    @Override
    public boolean belongsTo(String jobFamily) {
        return true;
    }

    @Override
    public void cancel() {
    }

    @Override
    public void ensureReadyToRun() {
        if (!this.areIndexesReady) {
            this.getIndexes(null);
        }
    }

    @Override
    public boolean execute(IProgressMonitor progressMonitor) {
        SubMonitor subMonitor = SubMonitor.convert(progressMonitor, 3);
        boolean isComplete = true;
        this.executionTime.set(0L);
        long startTime = System.currentTimeMillis();
        Index[] indexes = this.getIndexes(subMonitor.split(1));
        try {
            int max = indexes.length;
            SubMonitor loopMonitor = subMonitor.split(2).setWorkRemaining(max);
            this.parallel = this.canRunInParallel();
            if (this.parallel) {
                isComplete = this.performParallelSearch(indexes, loopMonitor);
            } else {
                int i = 0;
                while (i < max) {
                    isComplete &= this.search(indexes[i], this.requestor, loopMonitor.split(1));
                    ++i;
                }
            }
            if (JobManager.VERBOSE) {
                if (this.parallel) {
                    long wallClockTime = System.currentTimeMillis() - startTime;
                    Util.verbose("-> execution time: " + wallClockTime + "ms - " + this);
                    Util.verbose("-> cumulative execution time (" + ForkJoinPool.getCommonPoolParallelism() + "): " + this.executionTime.get() + "ms - " + this);
                } else {
                    Util.verbose("-> execution time: " + this.executionTime.get() + "ms - " + this);
                }
            }
            boolean bl = isComplete;
            return bl;
        }
        finally {
            SubMonitor.done(progressMonitor);
        }
    }

    private boolean performParallelSearch(Index[] indexes, SubMonitor loopMonitor) {
        boolean isComplete = true;
        ArrayList<Future> futures = new ArrayList<Future>(indexes.length);
        ForkJoinPool commonPool = ForkJoinPool.commonPool();
        ParallelSearchMonitor monitor = new ParallelSearchMonitor(loopMonitor);
        try {
            if (this.scope instanceof IParallelizable) {
                ((IParallelizable)((Object)this.scope)).initBeforeSearch(monitor);
            }
            Index[] indexArray = indexes;
            int n = indexes.length;
            int n2 = 0;
            while (n2 < n) {
                Index index = indexArray[n2];
                futures.add(commonPool.submit(() -> this.search(index, monitor)));
                ++n2;
            }
            for (Future future : futures) {
                loopMonitor.split(1);
                try {
                    IndexResult result = (IndexResult)future.get();
                    isComplete &= result.complete;
                    result.matches.forEach(m -> {
                        boolean continueSearch = this.requestor.acceptIndexMatch(m.documentPath, m.indexRecord, this.participant, m.access);
                        if (!continueSearch) {
                            throw new OperationCanceledException();
                        }
                    });
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw new OperationCanceledException();
                }
                catch (ExecutionException e) {
                    if (e.getCause() instanceof RuntimeException) {
                        throw (RuntimeException)e.getCause();
                    }
                    throw new RuntimeException(e);
                }
            }
        }
        catch (JavaModelException e) {
            monitor.setCanceled(true);
            throw new RuntimeException("Error initializing scope: " + this.scope, e);
        }
        catch (Exception e) {
            monitor.setCanceled(true);
            throw e;
        }
        return isComplete;
    }

    public Index[] getIndexes(IProgressMonitor progressMonitor) {
        int length;
        IndexLocation[] indexLocations;
        if (this.participant instanceof JavaSearchParticipant) {
            indexLocations = ((JavaSearchParticipant)this.participant).selectIndexURLs(this.pattern, this.scope);
            length = indexLocations.length;
        } else {
            IPath[] paths = this.participant.selectIndexes(this.pattern, this.scope);
            length = paths.length;
            indexLocations = new IndexLocation[paths.length];
            int i = 0;
            int len = paths.length;
            while (i < len) {
                indexLocations[i] = new FileIndexLocation(paths[i].toFile(), true);
                ++i;
            }
        }
        Index[] indexes = JavaModelManager.getIndexManager().getIndexes(indexLocations, progressMonitor);
        this.areIndexesReady = indexes.length == length;
        return indexes;
    }

    @Override
    public boolean waitNeeded() {
        return true;
    }

    @Override
    public String getJobFamily() {
        return "";
    }

    private IndexResult search(Index index, IProgressMonitor progressMonitor) {
        ArrayList<IndexMatch> matches = new ArrayList<IndexMatch>();
        boolean complete = this.search(index, PatternSearchJob.collectTo(matches, progressMonitor), progressMonitor);
        return new IndexResult(complete, matches);
    }

    public boolean search(Index index, IndexQueryRequestor queryRequestor, IProgressMonitor progressMonitor) {
        if (index == null) {
            return true;
        }
        if (progressMonitor != null && progressMonitor.isCanceled()) {
            throw new OperationCanceledException();
        }
        ReadWriteMonitor monitor = index.monitor;
        if (monitor == null) {
            return true;
        }
        try {
            monitor.enterRead();
            long start = System.currentTimeMillis();
            SearchPattern searchPattern = this.pattern;
            IJavaSearchScope searchScope = this.scope;
            if (this.parallel) {
                searchPattern = PatternSearchJob.clone(searchPattern);
                searchScope = PatternSearchJob.clone(searchScope);
            }
            MatchLocator.findIndexMatches(searchPattern, index, queryRequestor, this.participant, searchScope, progressMonitor);
            this.executionTime.addAndGet(System.currentTimeMillis() - start);
            return true;
        }
        catch (IOException e) {
            if (e instanceof EOFException) {
                e.printStackTrace();
            }
            return false;
        }
        finally {
            monitor.exitRead();
        }
    }

    private static IJavaSearchScope clone(IJavaSearchScope searchScope) {
        if (searchScope instanceof AbstractSearchScope) {
            try {
                searchScope = ((AbstractSearchScope)searchScope).clone();
            }
            catch (CloneNotSupportedException e) {
                Util.log(new Status(2, "org.eclipse.jdt.core", "PatternSearchJob could not clone " + searchScope, (Throwable)e));
            }
        }
        return searchScope;
    }

    private static SearchPattern clone(SearchPattern searchPattern) {
        if (searchPattern instanceof Cloneable) {
            try {
                searchPattern = searchPattern.clone();
            }
            catch (CloneNotSupportedException e) {
                Util.log(new Status(2, "org.eclipse.jdt.core", "PatternSearchJob could not clone " + searchPattern, (Throwable)e));
            }
        }
        return searchPattern;
    }

    public String toString() {
        return "searching " + this.pattern.toString();
    }

    private boolean canRunInParallel() {
        return this.isParallelSearchEnabled() && IParallelizable.isParallelSearchSupported(this.scope) && IParallelizable.isParallelSearchSupported(this.participant) && IParallelizable.isParallelSearchSupported(this.pattern);
    }

    private boolean isParallelSearchEnabled() {
        IPreferencesService preferenceService = Platform.getPreferencesService();
        if (preferenceService == null) {
            return true;
        }
        return preferenceService.getBoolean("org.eclipse.jdt.core", ENABLE_PARALLEL_SEARCH, true, null);
    }

    private static IndexQueryRequestor collectTo(final List<IndexMatch> collectTo, final IProgressMonitor monitor) {
        return new IndexQueryRequestor(){

            @Override
            public boolean acceptIndexMatch(String documentPath, SearchPattern indexRecord, SearchParticipant participant, AccessRuleSet access) {
                collectTo.add(new IndexMatch(documentPath, indexRecord, access));
                return !monitor.isCanceled();
            }
        };
    }

    static class IndexMatch {
        final String documentPath;
        final SearchPattern indexRecord;
        final AccessRuleSet access;

        IndexMatch(String documentPath, SearchPattern indexRecord, AccessRuleSet access) {
            this.documentPath = documentPath;
            this.indexRecord = indexRecord;
            this.access = access;
        }
    }

    static class IndexResult {
        final boolean complete;
        final List<IndexMatch> matches;

        IndexResult(boolean complete, List<IndexMatch> matches) {
            this.complete = complete;
            this.matches = matches;
        }
    }

    static class ParallelSearchMonitor
    extends NullProgressMonitor {
        private volatile boolean canceled;
        private IProgressMonitor original;

        public ParallelSearchMonitor(IProgressMonitor original) {
            this.original = original;
        }

        @Override
        public boolean isCanceled() {
            return this.canceled || this.original.isCanceled();
        }

        @Override
        public void setCanceled(boolean canceled) {
            this.canceled = canceled;
        }
    }
}

