/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.ast;

import java.lang.reflect.Modifier;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.tools.GenericsUtils;
import org.codehaus.groovy.ast.tools.WideningCategories;

public class GenericsType
extends ASTNode {
    public static final GenericsType[] EMPTY_ARRAY = new GenericsType[0];
    private String name;
    private ClassNode type;
    private ClassNode lowerBound;
    private ClassNode[] upperBounds;
    private boolean placeholder;
    private boolean resolved;
    private boolean wildcard;

    public GenericsType(ClassNode type, ClassNode[] upperBounds, ClassNode lowerBound) {
        this.setType(type);
        this.lowerBound = lowerBound;
        this.upperBounds = upperBounds;
        this.placeholder = type.isGenericsPlaceHolder();
        this.setName(this.placeholder ? type.getUnresolvedName() : type.getName());
    }

    public GenericsType(ClassNode basicType) {
        this(basicType, null, null);
    }

    public GenericsType() {
    }

    public ClassNode getType() {
        return this.type;
    }

    public void setType(ClassNode type) {
        this.type = Objects.requireNonNull(type);
    }

    public String toString() {
        return GenericsType.toString(this, new HashSet<String>());
    }

    private static String toString(GenericsType gt, Set<String> visited) {
        ClassNode type = gt.getType();
        boolean wildcard = gt.isWildcard();
        boolean placeholder = gt.isPlaceholder();
        ClassNode lowerBound = gt.getLowerBound();
        ClassNode[] upperBounds = gt.getUpperBounds();
        if (placeholder) {
            visited.add(gt.getName());
        }
        StringBuilder ret = new StringBuilder(wildcard || placeholder ? gt.getName() : GenericsType.genericsBounds(type, visited));
        if (lowerBound != null) {
            ret.append(" super ").append(GenericsType.genericsBounds(lowerBound, visited));
        } else if (!(upperBounds == null || placeholder && upperBounds.length == 1 && !upperBounds[0].isGenericsPlaceHolder() && upperBounds[0].getName().equals("java.lang.Object"))) {
            ret.append(" extends ");
            int i = 0;
            int n = upperBounds.length;
            while (i < n) {
                if (i != 0) {
                    ret.append(" & ");
                }
                ret.append(GenericsType.genericsBounds(upperBounds[i], visited));
                ++i;
            }
        }
        return ret.toString();
    }

    private static String nameOf(ClassNode theType) {
        StringBuilder ret = new StringBuilder();
        if (theType.isArray()) {
            ret.append(GenericsType.nameOf(theType.getComponentType()));
            ret.append("[]");
        } else {
            ret.append(theType.getName());
        }
        return ret.toString();
    }

    private static String genericsBounds(ClassNode theType, Set<String> visited) {
        StringBuilder ret = new StringBuilder();
        if (theType.isArray()) {
            ret.append(GenericsType.nameOf(theType));
        } else if (theType.getOuterClass() != null) {
            String parentClassNodeName = theType.getOuterClass().getName();
            if (Modifier.isStatic(theType.getModifiers()) || theType.isInterface()) {
                ret.append(parentClassNodeName);
            } else {
                ret.append(GenericsType.genericsBounds(theType.getOuterClass(), new HashSet<String>()));
            }
            ret.append('.');
            ret.append(theType.getName(), parentClassNodeName.length() + 1, theType.getName().length());
        } else {
            ret.append(theType.getName());
        }
        GenericsType[] genericsTypes = theType.getGenericsTypes();
        if (genericsTypes == null || genericsTypes.length == 0) {
            return ret.toString();
        }
        if (genericsTypes.length == 1 && genericsTypes[0].isPlaceholder() && theType.getName().equals("java.lang.Object")) {
            return genericsTypes[0].getName();
        }
        ret.append('<');
        int i = 0;
        int n = genericsTypes.length;
        while (i < n) {
            GenericsType type;
            if (i != 0) {
                ret.append(", ");
            }
            if ((type = genericsTypes[i]).isPlaceholder() && visited.contains(type.getName())) {
                ret.append(type.getName());
            } else {
                ret.append(GenericsType.toString(type, visited));
            }
            ++i;
        }
        ret.append('>');
        return ret.toString();
    }

    public String getName() {
        return this.isWildcard() ? "?" : this.name;
    }

    public void setName(String name) {
        this.name = Objects.requireNonNull(name);
    }

    public boolean isResolved() {
        return this.resolved || this.isPlaceholder();
    }

    public void setResolved(boolean resolved) {
        this.resolved = resolved;
    }

    public boolean isPlaceholder() {
        return this.placeholder;
    }

    public void setPlaceholder(boolean placeholder) {
        this.placeholder = placeholder;
        this.getType().setGenericsPlaceHolder(placeholder);
    }

    public boolean isWildcard() {
        return this.wildcard;
    }

    public void setWildcard(boolean wildcard) {
        this.wildcard = wildcard;
    }

    public ClassNode getLowerBound() {
        return this.lowerBound;
    }

    public ClassNode[] getUpperBounds() {
        return this.upperBounds;
    }

    public void setLowerBound(ClassNode bound) {
        this.lowerBound = bound;
    }

    public void setUpperBounds(ClassNode[] bounds) {
        this.upperBounds = bounds;
    }

    public void setPlaceHolder(boolean placeholder) {
        this.placeholder = placeholder;
    }

    public boolean isCompatibleWith(ClassNode classNode) {
        GenericsType[] genericsTypes = classNode.getGenericsTypes();
        if (genericsTypes != null && genericsTypes.length == 0) {
            return true;
        }
        if (classNode.isGenericsPlaceHolder()) {
            if (genericsTypes == null) {
                return true;
            }
            if (this.isWildcard()) {
                if (this.getLowerBound() != null) {
                    ClassNode lowerBound = this.getLowerBound();
                    return genericsTypes[0].name.equals(lowerBound.getUnresolvedName());
                }
                if (this.getUpperBounds() != null) {
                    ClassNode[] classNodeArray = this.getUpperBounds();
                    int n = classNodeArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        ClassNode upperBound = classNodeArray[n2];
                        if (genericsTypes[0].name.equals(upperBound.getUnresolvedName())) {
                            return true;
                        }
                        ++n2;
                    }
                    return false;
                }
            }
            return genericsTypes[0].name.equals(this.name);
        }
        if (this.isWildcard() || this.isPlaceholder()) {
            ClassNode lowerBound = this.getLowerBound();
            if (lowerBound != null) {
                if (!GenericsType.implementsInterfaceOrIsSubclassOf(lowerBound, classNode)) {
                    return false;
                }
                return this.checkGenerics(classNode);
            }
            ClassNode[] upperBounds = this.getUpperBounds();
            if (upperBounds != null) {
                ClassNode[] classNodeArray = upperBounds;
                int n = upperBounds.length;
                int n3 = 0;
                while (n3 < n) {
                    ClassNode upperBound = classNodeArray[n3];
                    if (!GenericsType.implementsInterfaceOrIsSubclassOf(classNode, upperBound)) {
                        return false;
                    }
                    ++n3;
                }
                return this.checkGenerics(classNode);
            }
            return true;
        }
        return this.getType().equals(classNode) && GenericsType.compareGenericsWithBound(classNode, this.type);
    }

    private static boolean implementsInterfaceOrIsSubclassOf(ClassNode type, ClassNode superOrInterface) {
        if (type.equals(superOrInterface) || type.isDerivedFrom(superOrInterface) || type.implementsInterface(superOrInterface)) {
            return true;
        }
        if (ClassHelper.GROOVY_OBJECT_TYPE.equals(superOrInterface) && type.getCompileUnit() != null) {
            return true;
        }
        if (superOrInterface instanceof WideningCategories.LowestUpperBoundClassNode) {
            WideningCategories.LowestUpperBoundClassNode lub = (WideningCategories.LowestUpperBoundClassNode)superOrInterface;
            boolean result = GenericsType.implementsInterfaceOrIsSubclassOf(type, lub.getSuperClass());
            if (result) {
                ClassNode[] classNodeArray = lub.getInterfaces();
                int n = classNodeArray.length;
                int n2 = 0;
                while (n2 < n) {
                    ClassNode face = classNodeArray[n2];
                    result = GenericsType.implementsInterfaceOrIsSubclassOf(type, face);
                    if (!result) break;
                    ++n2;
                }
            }
            if (result) {
                return true;
            }
        }
        if (type.isArray() && superOrInterface.isArray()) {
            return GenericsType.implementsInterfaceOrIsSubclassOf(type.getComponentType(), superOrInterface.getComponentType());
        }
        return false;
    }

    private boolean checkGenerics(ClassNode classNode) {
        ClassNode lowerBound = this.getLowerBound();
        if (lowerBound != null) {
            return GenericsType.compareGenericsWithBound(classNode, lowerBound);
        }
        ClassNode[] upperBounds = this.getUpperBounds();
        if (upperBounds != null) {
            ClassNode[] classNodeArray = upperBounds;
            int n = upperBounds.length;
            int n2 = 0;
            while (n2 < n) {
                ClassNode upperBound = classNodeArray[n2];
                if (!GenericsType.compareGenericsWithBound(classNode, upperBound)) {
                    return false;
                }
                ++n2;
            }
        }
        return true;
    }

    private static boolean compareGenericsWithBound(ClassNode classNode, ClassNode bound) {
        if (classNode == null) {
            return false;
        }
        if (bound.getGenericsTypes() == null || classNode.getGenericsTypes() == null && classNode.redirect().getGenericsTypes() != null) {
            return true;
        }
        if (!classNode.equals(bound)) {
            boolean success;
            if (bound.isInterface()) {
                for (ClassNode face : classNode.getAllInterfaces()) {
                    if (!face.equals(bound)) continue;
                    if (face.getGenericsTypes() != null) {
                        face = GenericsUtils.parameterizeType(classNode, face);
                    }
                    return GenericsType.compareGenericsWithBound(face, bound);
                }
            }
            if (bound instanceof WideningCategories.LowestUpperBoundClassNode && (success = GenericsType.compareGenericsWithBound(classNode, bound.getSuperClass()))) {
                ClassNode[] classNodeArray = bound.getInterfaces();
                int n = classNodeArray.length;
                int n2 = 0;
                while (n2 < n) {
                    ClassNode face = classNodeArray[n2];
                    if (!(success &= GenericsType.compareGenericsWithBound(classNode, face))) break;
                    ++n2;
                }
                if (success) {
                    return true;
                }
            }
            if (classNode.equals(ClassHelper.OBJECT_TYPE)) {
                return false;
            }
            ClassNode superClass = classNode.getUnresolvedSuperClass();
            if (superClass == null) {
                superClass = ClassHelper.OBJECT_TYPE;
            } else if (superClass.getGenericsTypes() != null) {
                superClass = GenericsUtils.parameterizeType(classNode, superClass);
            }
            return GenericsType.compareGenericsWithBound(superClass, bound);
        }
        GenericsType[] cnTypes = classNode.getGenericsTypes();
        if (cnTypes == null) {
            cnTypes = classNode.redirect().getGenericsTypes();
        }
        if (cnTypes == null) {
            return true;
        }
        GenericsType[] redirectBoundGenericTypes = bound.redirect().getGenericsTypes();
        Map<GenericsTypeName, GenericsType> boundPlaceHolders = GenericsUtils.extractPlaceholders(bound);
        Map<GenericsTypeName, GenericsType> classNodePlaceholders = GenericsUtils.extractPlaceholders(classNode);
        boolean match = true;
        int i = 0;
        while (redirectBoundGenericTypes != null && i < redirectBoundGenericTypes.length && match) {
            GenericsTypeName name;
            GenericsType redirectBoundType = redirectBoundGenericTypes[i];
            GenericsType classNodeType = cnTypes[i];
            if (classNodeType.isPlaceholder()) {
                name = new GenericsTypeName(classNodeType.getName());
                if (redirectBoundType.isPlaceholder()) {
                    GenericsType genericsType;
                    GenericsTypeName gtn = new GenericsTypeName(redirectBoundType.getName());
                    match = name.equals(gtn);
                    if (!match && (genericsType = boundPlaceHolders.get(gtn)) != null) {
                        if (genericsType.isPlaceholder()) {
                            match = true;
                        } else if (genericsType.isWildcard()) {
                            match = genericsType.getUpperBounds() != null ? classNodeType.isCompatibleWith(genericsType.getUpperBounds()[0]) : (genericsType.getLowerBound() != null ? classNodeType.isCompatibleWith(genericsType.getLowerBound()) : true);
                        }
                    }
                } else {
                    match = classNodePlaceholders.getOrDefault(name, classNodeType).isCompatibleWith(redirectBoundType.getType());
                }
            } else if (redirectBoundType.isPlaceholder()) {
                if (classNodeType.isPlaceholder()) {
                    match = classNodeType.getName().equals(redirectBoundType.getName());
                } else {
                    name = new GenericsTypeName(redirectBoundType.getName());
                    if (boundPlaceHolders.containsKey(name)) {
                        redirectBoundType = boundPlaceHolders.get(name);
                        if (redirectBoundType.isPlaceholder()) {
                            redirectBoundType = classNodePlaceholders.getOrDefault(name, redirectBoundType);
                        } else if (redirectBoundType.isWildcard()) {
                            if (redirectBoundType.getLowerBound() != null) {
                                GenericsType gt = new GenericsType(redirectBoundType.getLowerBound());
                                if (gt.isPlaceholder()) {
                                    gt = classNodePlaceholders.getOrDefault(new GenericsTypeName(gt.getName()), gt);
                                }
                                match = classNodeType.isWildcard() ? (classNodeType.getLowerBound() != null || classNodeType.getUpperBounds() != null ? classNodeType.checkGenerics(gt.getType()) : false) : GenericsType.implementsInterfaceOrIsSubclassOf(gt.getType(), classNodeType.getType());
                            } else if (redirectBoundType.getUpperBounds() != null) {
                                ClassNode[] classNodeArray = redirectBoundType.getUpperBounds();
                                int n = classNodeArray.length;
                                int n3 = 0;
                                while (n3 < n) {
                                    ClassNode upperBound = classNodeArray[n3];
                                    GenericsType gt = new GenericsType(upperBound);
                                    if (gt.isPlaceholder()) {
                                        gt = classNodePlaceholders.getOrDefault(new GenericsTypeName(gt.getName()), gt);
                                    }
                                    match = classNodeType.isWildcard() ? (classNodeType.getLowerBound() != null ? gt.checkGenerics(classNodeType.getLowerBound()) : (classNodeType.getUpperBounds() != null ? gt.checkGenerics(classNodeType.getUpperBounds()[0]) : false)) : GenericsType.implementsInterfaceOrIsSubclassOf(classNodeType.getType(), gt.getType());
                                    if (!match) break;
                                    ++n3;
                                }
                            }
                            return match;
                        }
                    }
                    match = redirectBoundType.isCompatibleWith(classNodeType.getType());
                }
            } else {
                match = redirectBoundType.isWildcard() || classNodeType.isCompatibleWith(redirectBoundType.getType());
            }
            ++i;
        }
        return match;
    }

    public static class GenericsTypeName {
        private String name;

        public GenericsTypeName(String name) {
            this.name = Objects.requireNonNull(name);
        }

        public String getName() {
            return this.name;
        }

        public boolean equals(Object that) {
            if (this == that) {
                return true;
            }
            if (!(that instanceof GenericsTypeName)) {
                return false;
            }
            return this.getName().equals(((GenericsTypeName)that).getName());
        }

        public int hashCode() {
            return this.getName().hashCode();
        }

        public String toString() {
            return this.getName();
        }
    }
}

