/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.groovy.search;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.AnnotationNode;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.ConstructorNode;
import org.codehaus.groovy.ast.FieldNode;
import org.codehaus.groovy.ast.GenericsType;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.ast.PropertyNode;
import org.codehaus.groovy.ast.expr.BinaryExpression;
import org.codehaus.groovy.ast.expr.DeclarationExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.MethodCallExpression;
import org.codehaus.groovy.ast.expr.MethodPointerExpression;
import org.codehaus.groovy.ast.expr.StaticMethodCallExpression;
import org.codehaus.groovy.ast.expr.TupleExpression;
import org.codehaus.groovy.ast.tools.GenericsUtils;
import org.eclipse.jdt.groovy.core.util.GroovyUtils;
import org.eclipse.jdt.groovy.search.GenericsMapper;
import org.eclipse.jdt.groovy.search.VariableScope;

public class TypeLookupResult {
    public final TypeConfidence confidence;
    public final ClassNode declaringType;
    public final ClassNode type;
    public final ASTNode declaration;
    public final VariableScope scope;
    public final String extraDoc;
    public boolean isGroovy;
    public AnnotationNode enclosingAnnotation;
    public BinaryExpression enclosingAssignment;

    public TypeLookupResult(ClassNode type, ClassNode declaringType, ASTNode declaration, TypeConfidence confidence, VariableScope scope) {
        this(type, declaringType, declaration, confidence, scope, null);
    }

    public TypeLookupResult(ClassNode type, ClassNode declaringType, ASTNode declaration, TypeConfidence confidence, VariableScope scope, String extraDoc) {
        this.confidence = confidence;
        this.type = type;
        this.declaringType = declaringType;
        this.declaration = declaration;
        this.scope = scope;
        this.extraDoc = extraDoc;
    }

    public TypeLookupResult resolveTypeParameterization(ClassNode objExprType, boolean isStatic) {
        if (this.declaringType != null && (this.declaration instanceof FieldNode || this.declaration instanceof PropertyNode || this.declaration instanceof MethodNode && !(this.declaration instanceof ConstructorNode))) {
            ClassNode objectType = objExprType;
            if (objectType == null) {
                objectType = this.isGroovy || !isStatic ? this.scope.getDelegateOrThis() : this.declaringType;
            }
            if (ClassHelper.isPrimitiveType(objectType)) {
                objectType = ClassHelper.getWrapper(objectType);
            }
            if (!(this.declaration instanceof MethodNode)) {
                GenericsMapper mapper = GenericsMapper.gatherGenerics(objectType, this.declaringType);
                ClassNode maybe = VariableScope.resolveTypeParameterization(mapper, VariableScope.clone(this.type));
                if (!maybe.toString(false).equals(this.type.toString(false))) {
                    TypeLookupResult result = new TypeLookupResult(maybe, this.declaringType, this.declaration, this.confidence, this.scope, this.extraDoc);
                    result.enclosingAnnotation = this.enclosingAnnotation;
                    result.isGroovy = this.isGroovy;
                    return result;
                }
            } else {
                MethodNode method = (MethodNode)this.declaration;
                if (!isStatic && method.getName().equals("getClass") && method.getParameters().length == 0) {
                    ClassNode classType = VariableScope.clone(method.getReturnType());
                    classType.getGenericsTypes()[0].setUpperBounds(new ClassNode[]{objectType});
                    return new TypeLookupResult(classType, method.getDeclaringClass(), method, this.confidence, this.scope, this.extraDoc);
                }
                if (!GroovyUtils.isUsingGenerics(method) || !GenericsUtils.hasUnresolvedGenerics(method.getReturnType()) && !GroovyUtils.getParameterTypes(method.getParameters()).stream().anyMatch(GenericsUtils::hasUnresolvedGenerics)) {
                    return this;
                }
                ArrayList<ClassNode> argumentTypes = new ArrayList<ClassNode>();
                if (this.isGroovy) {
                    argumentTypes.add(objectType);
                }
                ClassNode targetType = null;
                if (this.scope.getEnclosingNode() instanceof MethodPointerExpression) {
                    GenericsMapper mapper = GenericsMapper.gatherGenerics(argumentTypes, objectType, method, new GenericsType[0]);
                    method = VariableScope.resolveTypeParameterization(mapper, method);
                    VariableScope.CallAndType cat = this.scope.getEnclosingMethodCallExpression();
                    if (cat != null && cat.declaration instanceof MethodNode && cat.call.getArguments() instanceof TupleExpression) {
                        int index = ((TupleExpression)cat.call.getArguments()).getExpressions().indexOf(this.scope.getEnclosingNode());
                        Parameter[] params = ((MethodNode)cat.declaration).getParameters();
                        if (index != -1 && params.length > 0 && (targetType = params[Math.min(index, params.length - 1)].getType()).isArray() && index >= params.length - 1) {
                            targetType = objectType.getComponentType();
                        }
                    } else if (TypeLookupResult.testEnclosingAssignment(this.scope, rhs -> rhs == this.scope.getEnclosingNode())) {
                        targetType = this.scope.getEnclosingAssignment().getLeftExpression().getType();
                    }
                    if (targetType != null) {
                        if (targetType.equals(VariableScope.CLOSURE_CLASS_NODE)) {
                            ClassNode returnType = Optional.of(targetType).map(ClassNode::getGenericsTypes).filter(Objects::nonNull).map(gts -> gts[0].getType()).orElse(VariableScope.OBJECT_CLASS_NODE);
                            mapper = GenericsMapper.gatherGenerics(Collections.singletonList(returnType), this.declaringType, TypeLookupResult.returnTypeStub(method), new GenericsType[0]);
                            method = VariableScope.resolveTypeParameterization(mapper, method);
                        } else {
                            MethodNode sam = ClassHelper.findSAM(targetType);
                            if (sam != null) {
                                mapper = GenericsMapper.gatherGenerics(GroovyUtils.getParameterTypes(sam.getParameters()), this.declaringType, method, new GenericsType[0]);
                                method = VariableScope.resolveTypeParameterization(mapper, method);
                                mapper = GenericsMapper.gatherGenerics(targetType);
                                method = VariableScope.resolveTypeParameterization(mapper, method);
                            }
                        }
                    }
                } else {
                    if (this.scope.getMethodCallArgumentTypes() != null) {
                        argumentTypes.addAll(this.scope.getMethodCallArgumentTypes());
                    }
                    GenericsMapper mapper = GenericsMapper.gatherGenerics(argumentTypes, objectType, method, this.scope.getMethodCallGenericsTypes());
                    method = VariableScope.resolveTypeParameterization(mapper, method);
                    if (this.scope.getMethodCallGenericsTypes() == null && GenericsUtils.hasUnresolvedGenerics(method.getReturnType()) && argumentTypes.size() == (this.isGroovy ? 1 : 0) && TypeLookupResult.testEnclosingAssignment(this.scope, rhs -> rhs instanceof StaticMethodCallExpression && rhs == this.scope.getCurrentNode() || rhs instanceof MethodCallExpression && ((MethodCallExpression)rhs).getMethod() == this.scope.getCurrentNode())) {
                        targetType = this.scope.getEnclosingAssignment().getLeftExpression().getType();
                        mapper = GenericsMapper.gatherGenerics(Collections.singletonList(targetType), this.declaringType, TypeLookupResult.returnTypeStub(method), new GenericsType[0]);
                        method = VariableScope.resolveTypeParameterization(mapper, method);
                    }
                }
                if (method != this.declaration) {
                    TypeLookupResult result = new TypeLookupResult(method.getReturnType(), method.getDeclaringClass(), method, this.confidence, this.scope, this.extraDoc);
                    result.enclosingAnnotation = this.enclosingAnnotation;
                    result.isGroovy = this.isGroovy;
                    return result;
                }
            }
        }
        return this;
    }

    private static MethodNode returnTypeStub(MethodNode node) {
        MethodNode stub = new MethodNode("", 0, VariableScope.VOID_CLASS_NODE, new Parameter[]{new Parameter(node.getReturnType(), "")}, null, null);
        stub.setDeclaringClass(node.getDeclaringClass());
        stub.setGenericsTypes(node.getGenericsTypes());
        return stub;
    }

    private static boolean testEnclosingAssignment(VariableScope scope, Predicate<Expression> rhsTest) {
        return Optional.ofNullable(scope.getEnclosingAssignment()).filter(bexp -> bexp instanceof DeclarationExpression).map(BinaryExpression::getRightExpression).filter(rhsTest).isPresent();
    }

    public static enum TypeConfidence {
        EXACT,
        INFERRED,
        LOOSELY_INFERRED,
        UNKNOWN;


        public static TypeConfidence findLessPrecise(TypeConfidence left, TypeConfidence right) {
            return left.isLessThan(right) ? left : right;
        }

        public boolean isLessThan(TypeConfidence that) {
            return this.ordinal() > that.ordinal();
        }

        public boolean isAtLeast(TypeConfidence that) {
            return this.ordinal() <= that.ordinal();
        }
    }
}

