/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.jdt.groovy.internal.compiler.ast;

import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.jdt.groovy.internal.compiler.ast.GroovyClassScope;
import org.eclipse.jdt.groovy.core.util.ArrayUtils;
import org.eclipse.jdt.internal.compiler.CompilationResult;
import org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.eclipse.jdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.CompilationUnitDeclaration;
import org.eclipse.jdt.internal.compiler.ast.FieldDeclaration;
import org.eclipse.jdt.internal.compiler.ast.Initializer;
import org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.jdt.internal.compiler.lookup.ClassScope;
import org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.eclipse.jdt.internal.compiler.parser.Parser;

public class GroovyTypeDeclaration
extends TypeDeclaration {
    private final ClassNode classNode;
    private GroovyTypeDeclaration[] anonymousTypes;
    private static final GroovyTypeDeclaration[] NO_TYPES = new GroovyTypeDeclaration[0];

    public GroovyTypeDeclaration(CompilationResult compilationResult, ClassNode classNode) {
        super(compilationResult);
        this.classNode = classNode;
    }

    public ClassNode getClassNode() {
        return this.classNode;
    }

    @Override
    public void parseMethods(Parser parser, CompilationUnitDeclaration unit) {
    }

    @Override
    public boolean isScannerUsableOnThisDeclaration() {
        return false;
    }

    @Override
    public ClassScope newClassScope(Scope outer) {
        return new GroovyClassScope(outer, this);
    }

    @Override
    public void resolve() {
        int n;
        int n2;
        ASTNode[] aSTNodeArray;
        if (this.memberTypes != null && this.memberTypes.length > 0) {
            aSTNodeArray = this.memberTypes;
            n2 = this.memberTypes.length;
            n = 0;
            while (n < n2) {
                ASTNode type = aSTNodeArray[n];
                ((TypeDeclaration)type).resolve(this.scope);
                ++n;
            }
        }
        aSTNodeArray = this.methods;
        n2 = this.methods.length;
        n = 0;
        while (n < n2) {
            ASTNode method = aSTNodeArray[n];
            ((AbstractMethodDeclaration)method).resolve(this.scope);
            if (((AbstractMethodDeclaration)method).isClinit()) {
                ((AbstractMethodDeclaration)method).resolveStatements();
            }
            ++n;
        }
        aSTNodeArray = this.fields;
        n2 = this.fields.length;
        n = 0;
        while (n < n2) {
            ASTNode field = aSTNodeArray[n];
            if (field instanceof Initializer) {
                ((FieldDeclaration)field).resolve(((FieldDeclaration)field).isStatic() ? this.staticInitializerScope : this.initializerScope);
            }
            ++n;
        }
    }

    public GroovyTypeDeclaration[] getAnonymousTypes() {
        return this.anonymousTypes != null ? this.anonymousTypes : NO_TYPES;
    }

    public void addAnonymousType(GroovyTypeDeclaration anonymousType) {
        this.anonymousTypes = (GroovyTypeDeclaration[])ArrayUtils.add(this.getAnonymousTypes(), anonymousType);
    }
}

