/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.groovy.search;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.Variable;
import org.codehaus.groovy.ast.expr.ClosureExpression;
import org.codehaus.groovy.ast.expr.ClosureListExpression;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.ast.expr.ConstructorCallExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.GStringExpression;
import org.codehaus.groovy.ast.expr.VariableExpression;
import org.codehaus.groovy.ast.stmt.BlockStatement;
import org.codehaus.groovy.ast.stmt.ForStatement;
import org.eclipse.jdt.groovy.search.ITypeLookupExtension;
import org.eclipse.jdt.groovy.search.TypeLookupResult;
import org.eclipse.jdt.groovy.search.VariableScope;

public abstract class AbstractSimplifiedTypeLookup
implements ITypeLookupExtension {
    private Boolean isStatic;
    private Expression currentExpression;

    protected TypeLookupResult.TypeConfidence checkConfidence(Expression node, TypeLookupResult.TypeConfidence originalConfidence, ASTNode declaration, String extraDoc) {
        return originalConfidence == null ? this.confidence() : originalConfidence;
    }

    protected TypeLookupResult.TypeConfidence confidence() {
        return TypeLookupResult.TypeConfidence.LOOSELY_INFERRED;
    }

    protected Expression getCurrentExpression() {
        return this.currentExpression;
    }

    protected Variable getDeclaredVariable(String name, VariableScope scope) {
        Variable var = null;
        VariableScope.VariableInfo info = scope.lookupName(name);
        if (info != null) {
            org.codehaus.groovy.ast.VariableScope groovyScope = null;
            if (info.scopeNode instanceof MethodNode) {
                groovyScope = ((MethodNode)info.scopeNode).getVariableScope();
            } else if (info.scopeNode instanceof ForStatement) {
                groovyScope = ((ForStatement)info.scopeNode).getVariableScope();
            } else if (info.scopeNode instanceof BlockStatement) {
                groovyScope = ((BlockStatement)info.scopeNode).getVariableScope();
            } else if (info.scopeNode instanceof ClosureExpression) {
                groovyScope = ((ClosureExpression)info.scopeNode).getVariableScope();
            } else if (info.scopeNode instanceof ClosureListExpression) {
                groovyScope = ((ClosureListExpression)info.scopeNode).getVariableScope();
            }
            while (groovyScope != null && (var = groovyScope.getDeclaredVariable(name)) == null) {
                groovyScope = groovyScope.getParent();
            }
        }
        return var;
    }

    protected boolean isQuotedString() {
        return this.currentExpression instanceof GStringExpression || this.currentExpression instanceof ConstantExpression && (this.currentExpression.getEnd() < 1 || this.currentExpression.getLength() != this.currentExpression.getText().length());
    }

    protected boolean isStatic() {
        return this.isStatic;
    }

    @Override
    public final TypeLookupResult lookupType(Expression expression, VariableScope scope, ClassNode objectExpressionType, boolean isStaticObjectExpression) {
        boolean isCtorCall = expression instanceof ConstructorCallExpression;
        if (isCtorCall || expression instanceof VariableExpression || expression instanceof ConstantExpression && (expression.getEnd() < 1 || expression.getLength() == expression.getText().length())) {
            List<Object> declaringTypes;
            String name = isCtorCall ? "<init>" : expression.getText();
            Variable variable = this.getDeclaredVariable(name, scope);
            if (variable != null && !variable.isDynamicTyped()) {
                return null;
            }
            if (isCtorCall) {
                declaringTypes = Collections.singletonList(new TypeAndScope(expression.getType(), scope));
            } else if (objectExpressionType != null) {
                declaringTypes = Collections.singletonList(new TypeAndScope(objectExpressionType, scope));
            } else {
                declaringTypes = new ArrayList();
                TypeAndScope.populate(declaringTypes, scope, scope.getEnclosingClosureResolveStrategy());
            }
            try {
                this.currentExpression = expression;
                for (TypeAndScope typeAndScope : declaringTypes) {
                    ClassNode declaringType = typeAndScope.declaringType;
                    if (declaringType.isUsingGenerics() && declaringType.equals(VariableScope.CLASS_CLASS_NODE)) {
                        declaringType = declaringType.getGenericsTypes()[0].getType();
                        this.isStatic = Boolean.TRUE;
                    } else {
                        this.isStatic = isStaticObjectExpression;
                    }
                    TypeAndDeclaration result = this.lookupTypeAndDeclaration(declaringType, name, typeAndScope.variableScope);
                    if (result == null) continue;
                    TypeLookupResult.TypeConfidence confidence = this.checkConfidence(expression, result.confidence, result.declaration, result.extraDoc);
                    TypeLookupResult typeLookupResult = new TypeLookupResult(result.type, result.declaringType != null ? result.declaringType : declaringType, result.declaration, confidence, typeAndScope.variableScope, result.extraDoc);
                    return typeLookupResult;
                }
            }
            finally {
                this.currentExpression = null;
                this.isStatic = null;
            }
        }
        return null;
    }

    protected abstract TypeAndDeclaration lookupTypeAndDeclaration(ClassNode var1, String var2, VariableScope var3);

    public static class TypeAndDeclaration {
        protected final ClassNode type;
        protected final ASTNode declaration;
        protected final ClassNode declaringType;
        protected final String extraDoc;
        protected final TypeLookupResult.TypeConfidence confidence;

        public TypeAndDeclaration(ClassNode type, ASTNode declaration, ClassNode declaringType, String extraDoc, TypeLookupResult.TypeConfidence confidence) {
            this.type = type;
            this.declaration = declaration;
            this.declaringType = declaringType;
            this.extraDoc = extraDoc;
            this.confidence = confidence;
        }

        public TypeAndDeclaration(ClassNode type, ASTNode declaration, ClassNode declaringType, String extraDoc) {
            this(type, declaration, declaringType, extraDoc, null);
        }

        public TypeAndDeclaration(ClassNode type, ASTNode declaration, ClassNode declaringType) {
            this(type, declaration, declaringType, null);
        }

        public TypeAndDeclaration(ClassNode type, ASTNode declaration) {
            this(type, declaration, null);
        }
    }

    private static class TypeAndScope {
        final ClassNode declaringType;
        final VariableScope variableScope;

        private TypeAndScope(ClassNode declaringType, VariableScope variableScope) {
            this.declaringType = Objects.requireNonNull(declaringType);
            this.variableScope = Objects.requireNonNull(variableScope);
        }

        private static void populate(List<TypeAndScope> types, VariableScope scope, int resolveStrategy) {
            if (resolveStrategy == 1 || resolveStrategy == 3) {
                ClassNode delegate = scope.getDelegate();
                types.add(new TypeAndScope(delegate, scope));
            }
            if (resolveStrategy < 3) {
                ClassNode delegate;
                ClassNode owner = scope.getOwner();
                if (owner != null) {
                    VariableScope outer = (VariableScope)owner.getNodeMetaData("outer.scope");
                    if (outer != null) {
                        VariableScope.CallAndType cat = outer.getEnclosingMethodCallExpression();
                        TypeAndScope.populate(types, outer, cat == null ? 0 : cat.getResolveStrategy(outer.getEnclosingClosure()));
                    } else {
                        types.add(new TypeAndScope(owner, scope));
                    }
                } else {
                    owner = scope.getThis();
                    if (owner != null) {
                        types.add(new TypeAndScope(owner, scope));
                    }
                }
                if (resolveStrategy < 1 && scope.getEnclosingClosure() != null && (delegate = scope.getDelegate()) != null && !delegate.equals(owner)) {
                    types.add(new TypeAndScope(delegate, scope));
                }
            }
            if (resolveStrategy <= 4 && (resolveStrategy > 0 || scope.getEnclosingClosure() != null)) {
                types.add(new TypeAndScope(VariableScope.CLOSURE_CLASS_NODE, scope));
            }
        }
    }
}

