/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.groovy.search;

import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.GenericsType;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.transform.stc.StaticTypeCheckingSupport;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.groovy.core.util.GroovyUtils;
import org.eclipse.jdt.groovy.search.VariableScope;
import org.eclipse.jdt.internal.core.util.Util;

public class GenericsMapper {
    private final Deque<Map<String, ClassNode>> allGenerics = new LinkedList<Map<String, ClassNode>>();

    public static GenericsMapper gatherGenerics(ClassNode resolvedType, ClassNode declaringType) {
        GenericsMapper mapper = new GenericsMapper();
        ClassNode rCandidate = resolvedType;
        ClassNode uCandidate = resolvedType.redirect();
        Iterator<ClassNode> rIterator = GenericsMapper.getTypeHierarchy(rCandidate, true);
        Iterator<ClassNode> uIterator = GenericsMapper.getTypeHierarchy(uCandidate, false);
        while (rIterator.hasNext() && uIterator.hasNext()) {
            rCandidate = rIterator.next();
            uCandidate = uIterator.next();
            GenericsType[] rgts = GroovyUtils.getGenericsTypes(rCandidate);
            GenericsType[] ugts = GroovyUtils.getGenericsTypes(uCandidate);
            int n = ugts.length;
            if (n > 0 && rgts.length == 0) {
                rgts = new GenericsType[n];
                int i = 0;
                while (i < n) {
                    rgts[i] = new GenericsType(Optional.ofNullable(ugts[i].getUpperBounds()).map(bounds -> bounds[0]).orElse(VariableScope.OBJECT_CLASS_NODE));
                    ++i;
                }
            }
            assert (rgts.length == ugts.length);
            Map resolved = n > 0 ? new TreeMap() : Collections.EMPTY_MAP;
            int i = 0;
            while (i < n) {
                resolved.put(ugts[i].getName(), mapper.resolveParameter(rgts[i], 0));
                ++i;
            }
            mapper.allGenerics.add(resolved);
            if (rCandidate.getName().equals(declaringType.getName())) break;
        }
        return mapper;
    }

    public static GenericsMapper gatherGenerics(List<ClassNode> argumentTypes, ClassNode delegateOrThisType, MethodNode methodDeclaration, GenericsType ... methodGenerics) {
        GenericsMapper mapper;
        block15: {
            Map<Object, Object> resolved;
            GenericsType[] ugts;
            block16: {
                mapper = GenericsMapper.gatherGenerics(delegateOrThisType, methodDeclaration.getDeclaringClass());
                ugts = GroovyUtils.getGenericsTypes(methodDeclaration);
                if (ugts.length <= 0) break block15;
                if (mapper.allGenerics.isEmpty() || (resolved = mapper.allGenerics.removeLast()).isEmpty()) {
                    resolved = new TreeMap();
                }
                mapper.allGenerics.add(resolved);
                if (methodGenerics == null || methodGenerics.length <= 0) break block16;
                assert (methodGenerics.length == ugts.length);
                int i = 0;
                while (i < ugts.length) {
                    resolved.put(ugts[i].getName(), methodGenerics[i].getType());
                    ++i;
                }
                break block15;
            }
            if (argumentTypes == null) break block15;
            GenericsType[] genericsTypeArray = ugts;
            int n = ugts.length;
            int n2 = 0;
            while (n2 < n) {
                GenericsType ugt = genericsTypeArray[n2];
                Parameter[] methodParameters = methodDeclaration.getParameters();
                int i = 0;
                int n3 = GenericsMapper.isVargs(methodParameters) ? argumentTypes.size() : Math.min(argumentTypes.size(), methodParameters.length);
                while (i < n3) {
                    ClassNode rbt = argumentTypes.get(i);
                    ClassNode ubt = methodParameters[Math.min(i, methodParameters.length - 1)].getType();
                    while (rbt.isArray() && ubt.isArray()) {
                        rbt = rbt.getComponentType();
                        ubt = ubt.getComponentType();
                    }
                    if (ubt.isGenericsPlaceHolder() && ubt.getUnresolvedName().equals(ugt.getName())) {
                        if (GroovyUtils.isAssignable(rbt, ubt)) {
                            GenericsMapper.saveParameterType(resolved, ugt.getName(), rbt, true);
                        }
                    } else {
                        GenericsType[] ubt_gts = GroovyUtils.getGenericsTypes(ubt);
                        int j = 0;
                        block4: while (j < ubt_gts.length) {
                            ClassNode ubt_gt_t = GroovyUtils.getBaseType(ubt_gts[j].getType());
                            if (ubt_gt_t.isGenericsPlaceHolder() && ubt_gt_t.getUnresolvedName().equals(ugt.getName()) && ubt.redirect().isUsingGenerics()) {
                                if (rbt.equals(ClassHelper.CLOSURE_TYPE) && !ubt.equals(ClassHelper.CLOSURE_TYPE) && !ubt.isGenericsPlaceHolder()) {
                                    MethodNode sam;
                                    if (rbt.isUsingGenerics() && (sam = ClassHelper.findSAM(ubt)) != null) {
                                        GenericsMapper um = GenericsMapper.gatherGenerics(ubt, ubt.redirect());
                                        HashMap<String, ClassNode> rm = new HashMap<String, ClassNode>();
                                        GenericsMapper.readGenericsLinks(rm, rbt.getGenericsTypes()[0].getType(), sam.getReturnType());
                                        for (Map.Entry entry : rm.entrySet()) {
                                            ClassNode ut = um.findParameter((String)entry.getKey(), null);
                                            if (ut == null) continue;
                                            HashMap<String, ClassNode> map = new HashMap<String, ClassNode>();
                                            GenericsMapper.readGenericsLinks(map, (ClassNode)entry.getValue(), ut);
                                            ClassNode rt = (ClassNode)map.get(ugt.getName());
                                            if (rt == null || !GroovyUtils.isAssignable(rt, ubt_gt_t)) continue;
                                            GenericsMapper.saveParameterType(resolved, ugt.getName(), rt, false);
                                            break block4;
                                        }
                                    }
                                } else {
                                    String key = GroovyUtils.getGenericsTypes(ubt.redirect())[j].getName();
                                    GenericsMapper map = GenericsMapper.gatherGenerics(rbt, ubt.redirect());
                                    ClassNode rt = map.findParameter(key, null);
                                    if (rt == null || !GroovyUtils.isAssignable(rt, ubt_gt_t)) break;
                                    GenericsMapper.saveParameterType(resolved, ugt.getName(), rt, false);
                                    break;
                                }
                            }
                            ++j;
                        }
                    }
                    ++i;
                }
                ++n2;
            }
        }
        return mapper;
    }

    public ClassNode resolveParameter(GenericsType topGT, int depth) {
        if (this.allGenerics.isEmpty()) {
            if (!topGT.isWildcard()) {
                return topGT.getType();
            }
            if (topGT.getLowerBound() != null) {
                return topGT.getLowerBound();
            }
            if (topGT.getUpperBounds() != null) {
                return topGT.getUpperBounds()[0];
            }
            return VariableScope.OBJECT_CLASS_NODE;
        }
        if (depth > 10) {
            Util.log(new Status(2, "org.eclipse.jdt.groovy.core", "GRECLIPSE-1040: prevent infinite recursion when resolving type parameters on generics type: " + topGT));
            return topGT.getType();
        }
        ClassNode origType = this.findParameter(topGT.getName(), topGT.getType());
        if (origType.getGenericsTypes() != null) {
            GenericsType[] genericsTypes;
            origType = VariableScope.clone(origType);
            GenericsType[] genericsTypeArray = genericsTypes = origType.getGenericsTypes();
            int n = genericsTypes.length;
            int n2 = 0;
            while (n2 < n) {
                GenericsType genericsType = genericsTypeArray[n2];
                if (!genericsType.getName().equals(topGT.getName())) {
                    genericsType.setType(this.findParameter(genericsType.getName(), this.resolveParameter(genericsType, depth + 1)));
                    genericsType.setLowerBound(null);
                    genericsType.setUpperBounds(null);
                    genericsType.setName(genericsType.getType().getName());
                }
                ++n2;
            }
        }
        return origType;
    }

    protected boolean hasGenerics() {
        return !this.allGenerics.isEmpty() && !this.allGenerics.getLast().isEmpty();
    }

    protected ClassNode findParameter(String parameterName, ClassNode defaultType) {
        if (this.allGenerics.isEmpty()) {
            return defaultType;
        }
        ClassNode type = this.allGenerics.getLast().get(parameterName);
        if (type == null) {
            return defaultType;
        }
        return type;
    }

    protected static Iterator<ClassNode> getTypeHierarchy(ClassNode type, boolean useResolved) {
        LinkedHashSet<ClassNode> hierarchy = new LinkedHashSet<ClassNode>();
        VariableScope.createTypeHierarchy(type, hierarchy, useResolved);
        hierarchy.remove(VariableScope.GROOVY_OBJECT_CLASS_NODE);
        hierarchy.remove(VariableScope.OBJECT_CLASS_NODE);
        return hierarchy.iterator();
    }

    protected static boolean isVargs(Parameter[] parameters) {
        Parameter last;
        ClassNode type;
        return parameters.length > 0 && (type = (last = parameters[parameters.length - 1]).getType()).isArray();
    }

    protected static void readGenericsLinks(Map<String, ClassNode> map, ClassNode rt, ClassNode ut) {
        if (rt == null || ut == null || rt == ut || GroovyUtils.getBaseType(ut).getGenericsTypes() == null) {
            return;
        }
        if (ut.isGenericsPlaceHolder()) {
            map.put(ut.getUnresolvedName(), rt);
        } else if (rt.isArray() && ut.isArray()) {
            GenericsMapper.readGenericsLinks(map, rt.getComponentType(), ut.getComponentType());
        } else if (rt.equals(ut) || !StaticTypeCheckingSupport.implementsInterfaceOrIsSubclassOf(rt, ut)) {
            GenericsMapper.readGenericsLinks(map, rt.getGenericsTypes(), ut.getGenericsTypes());
        } else {
            ClassNode superClass = ClassHelper.getNextSuperClass(ClassHelper.getWrapper(rt), ut);
            GenericsMapper.readGenericsLinks(map, StaticTypeCheckingSupport.getCorrectedClassNode(rt, superClass, true), ut);
        }
    }

    protected static void readGenericsLinks(Map<String, ClassNode> map, ClassNode[] rt, ClassNode[] ut) {
        if (rt == null || ut == null || rt.length != ut.length) {
            return;
        }
        int i = 0;
        int n = rt.length;
        while (i < n) {
            ClassNode rti = rt[i];
            ClassNode uti = ut[i];
            if (uti.isGenericsPlaceHolder()) {
                map.put(uti.getUnresolvedName(), uti);
            } else if (uti.isUsingGenerics()) {
                GenericsMapper.readGenericsLinks(map, rti.getGenericsTypes(), uti.getGenericsTypes());
            }
            ++i;
        }
    }

    protected static void readGenericsLinks(Map<String, ClassNode> map, GenericsType[] rt, GenericsType[] ut) {
        if (rt == null || ut == null || rt.length != ut.length) {
            return;
        }
        int i = 0;
        int n = rt.length;
        while (i < n) {
            GenericsType rti = rt[i];
            GenericsType uti = ut[i];
            if (uti.isPlaceholder()) {
                map.put(uti.getName(), rti.getType());
            } else if (uti.isWildcard()) {
                if (rti.isWildcard()) {
                    GenericsMapper.readGenericsLinks(map, rti.getLowerBound(), uti.getLowerBound());
                    GenericsMapper.readGenericsLinks(map, rti.getUpperBounds(), uti.getUpperBounds());
                } else {
                    ClassNode cu = rti.getType();
                    GenericsMapper.readGenericsLinks(map, cu, uti.getLowerBound());
                    ClassNode[] upperBounds = uti.getUpperBounds();
                    if (upperBounds != null) {
                        ClassNode[] classNodeArray = upperBounds;
                        int n2 = upperBounds.length;
                        int n3 = 0;
                        while (n3 < n2) {
                            ClassNode cn = classNodeArray[n3];
                            GenericsMapper.readGenericsLinks(map, cu, cn);
                            ++n3;
                        }
                    }
                }
            } else {
                GenericsMapper.readGenericsLinks(map, rti.getType(), uti.getType());
            }
            ++i;
        }
    }

    protected static void saveParameterType(Map<String, ClassNode> map, String key, ClassNode val, boolean weak) {
        ClassNode old = map.remove(key);
        if (old != null && !old.equals(val) && !old.equals(VariableScope.OBJECT_CLASS_NODE) && weak) {
            val = old;
        }
        map.put(key, val);
    }
}

