/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.groovy.search;

import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.jdt.groovy.model.GroovyClassFileWorkingCopy;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.search.SearchParticipant;
import org.eclipse.jdt.core.search.SearchRequestor;
import org.eclipse.jdt.core.search.TypeDeclarationMatch;
import org.eclipse.jdt.groovy.search.ITypeRequestor;
import org.eclipse.jdt.groovy.search.TypeLookupResult;
import org.eclipse.jdt.internal.core.search.indexing.IIndexConstants;
import org.eclipse.jdt.internal.core.search.matching.TypeDeclarationPattern;
import org.eclipse.jdt.internal.core.util.Util;

public class TypeDeclarationSearchRequestor
implements ITypeRequestor,
IIndexConstants {
    private final char[] simpleNamePattern;
    private final char typeSuffix;
    private final SearchRequestor requestor;
    private final SearchParticipant participant;
    private TypeDeclarationPattern pattern;

    public TypeDeclarationSearchRequestor(TypeDeclarationPattern pattern, SearchRequestor requestor, SearchParticipant participant) {
        this.pattern = pattern;
        this.simpleNamePattern = pattern.simpleName;
        this.typeSuffix = pattern.typeSuffix;
        this.requestor = requestor;
        this.participant = participant;
    }

    public ITypeRequestor.VisitStatus acceptASTNode(ASTNode node, TypeLookupResult result, IJavaElement enclosingElement) {
        ClassNode orig;
        ClassNode redirect;
        if (node instanceof ClassNode && (redirect = (orig = (ClassNode)node).redirect()).getNameEnd() > 0 && orig == redirect && this.pattern.matchesName(this.simpleNamePattern, orig.getNameWithoutPackage().toCharArray())) {
            boolean matchFound;
            switch (this.typeSuffix) {
                case 'C': {
                    matchFound = this.isClass(orig);
                    break;
                }
                case '\n': {
                    matchFound = orig.isInterface() || this.isClass(orig);
                    break;
                }
                case '\t': {
                    matchFound = orig.isInterface() || orig.isEnum();
                    break;
                }
                case 'I': {
                    matchFound = orig.isInterface();
                    break;
                }
                case '\u000b': {
                    matchFound = orig.isInterface() || orig.isAnnotationDefinition();
                    break;
                }
                case 'E': {
                    matchFound = orig.isEnum();
                    break;
                }
                case 'A': {
                    matchFound = orig.isAnnotationDefinition();
                    break;
                }
                default: {
                    matchFound = true;
                }
            }
            if (matchFound) {
                try {
                    IJavaElement realElement = enclosingElement.getOpenable() instanceof GroovyClassFileWorkingCopy ? ((GroovyClassFileWorkingCopy)enclosingElement.getOpenable()).convertToBinary(enclosingElement) : enclosingElement;
                    this.requestor.acceptSearchMatch(new TypeDeclarationMatch(realElement, 0, orig.getNameStart(), orig.getNameEnd() - orig.getNameStart() + 1, this.participant, realElement.getResource()));
                }
                catch (CoreException e) {
                    Util.log(e, "Exception with groovy search requestor. Looking inside " + enclosingElement);
                }
            }
        }
        return ITypeRequestor.VisitStatus.CONTINUE;
    }

    private boolean isClass(ClassNode orig) {
        return !orig.isInterface() && !orig.isAnnotationDefinition() && !orig.isEnum();
    }
}

