/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.groovy.search;

import groovy.lang.GroovySystem;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.AnnotatedNode;
import org.codehaus.groovy.ast.AnnotationNode;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.ConstructorNode;
import org.codehaus.groovy.ast.DynamicVariable;
import org.codehaus.groovy.ast.FieldNode;
import org.codehaus.groovy.ast.ImportNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.ast.PropertyNode;
import org.codehaus.groovy.ast.Variable;
import org.codehaus.groovy.ast.expr.AttributeExpression;
import org.codehaus.groovy.ast.expr.BitwiseNegationExpression;
import org.codehaus.groovy.ast.expr.BooleanExpression;
import org.codehaus.groovy.ast.expr.CastExpression;
import org.codehaus.groovy.ast.expr.ClassExpression;
import org.codehaus.groovy.ast.expr.ClosureExpression;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.ast.expr.ConstructorCallExpression;
import org.codehaus.groovy.ast.expr.EmptyExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.FieldExpression;
import org.codehaus.groovy.ast.expr.GStringExpression;
import org.codehaus.groovy.ast.expr.MethodCallExpression;
import org.codehaus.groovy.ast.expr.MethodPointerExpression;
import org.codehaus.groovy.ast.expr.PropertyExpression;
import org.codehaus.groovy.ast.expr.StaticMethodCallExpression;
import org.codehaus.groovy.ast.expr.VariableExpression;
import org.codehaus.groovy.classgen.asm.OptimizingStatementWriter;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.transform.trait.Traits;
import org.codehaus.jdt.groovy.model.GroovyCompilationUnit;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.groovy.core.util.GroovyUtils;
import org.eclipse.jdt.groovy.core.util.ReflectionUtils;
import org.eclipse.jdt.groovy.search.AccessorSupport;
import org.eclipse.jdt.groovy.search.CategoryTypeLookup;
import org.eclipse.jdt.groovy.search.GenericsMapper;
import org.eclipse.jdt.groovy.search.ITypeLookupExtension;
import org.eclipse.jdt.groovy.search.TypeLookupResult;
import org.eclipse.jdt.groovy.search.VariableScope;

public class SimpleTypeLookup
implements ITypeLookupExtension {
    protected GroovyCompilationUnit unit;
    protected static final AccessorSupport[] READER = new AccessorSupport[]{AccessorSupport.GETTER, AccessorSupport.ISSER};
    protected static final AccessorSupport[] WRITER = new AccessorSupport[]{AccessorSupport.SETTER};

    @Override
    public void initialize(GroovyCompilationUnit unit, VariableScope topLevelScope) {
        this.unit = unit;
    }

    @Override
    public TypeLookupResult lookupType(Expression node, VariableScope scope, ClassNode objectExpressionType, boolean isStaticObjectExpression) {
        ClassNode declaringType = Optional.ofNullable(GroovyUtils.getWrapperTypeIfPrimitive(objectExpressionType)).orElseGet(() -> SimpleTypeLookup.findDeclaringType(node, scope));
        boolean isPrimary = objectExpressionType == null;
        boolean isStatic = isStaticObjectExpression || isPrimary && scope.isStatic();
        return this.findType(node, declaringType, scope, isPrimary, isStatic);
    }

    @Override
    public TypeLookupResult lookupType(FieldNode node, VariableScope scope) {
        return new TypeLookupResult(node.getType(), node.getDeclaringClass(), node, TypeLookupResult.TypeConfidence.EXACT, scope);
    }

    @Override
    public TypeLookupResult lookupType(MethodNode node, VariableScope scope) {
        return new TypeLookupResult(node.getReturnType(), node.getDeclaringClass(), node, TypeLookupResult.TypeConfidence.EXACT, scope);
    }

    @Override
    public TypeLookupResult lookupType(ClassNode node, VariableScope scope) {
        ClassNode type = node;
        if (node.getOuterClass() != null) {
            if (!node.isRedirectNode() && GroovyUtils.isAnonymous(node)) {
                type = node.getUnresolvedSuperClass(false);
                if (type == VariableScope.OBJECT_CLASS_NODE) {
                    type = node.getInterfaces()[0];
                }
            } else if (SimpleTypeLookup.isTraitHelper(node)) {
                type = node.getOuterClass();
            }
        }
        return new TypeLookupResult(type, type, node, TypeLookupResult.TypeConfidence.EXACT, scope);
    }

    @Override
    public TypeLookupResult lookupType(Parameter node, VariableScope scope) {
        ClassNode type = Optional.ofNullable(scope.lookupNameInCurrentScope(node.getName())).map(info -> info.type).orElse(node.getType());
        return new TypeLookupResult(type, scope.getEnclosingTypeDeclaration(), node, TypeLookupResult.TypeConfidence.EXACT, scope);
    }

    protected static ClassNode findDeclaringType(Expression node, VariableScope scope) {
        Variable var;
        if (node instanceof ClassExpression || node instanceof ConstructorCallExpression) {
            return node.getType();
        }
        if (node instanceof FieldExpression) {
            return ((FieldExpression)node).getField().getDeclaringClass();
        }
        if (node instanceof StaticMethodCallExpression) {
            return null;
        }
        if (node instanceof ConstantExpression && scope.isMethodCall()) {
            ClassNode ownerType = scope.getEnclosingClosure() != null ? SimpleTypeLookup.getBaseDeclaringType(scope.getOwner()) : scope.getEnclosingTypeDeclaration();
            return ownerType;
        }
        if (node instanceof VariableExpression && (var = ((VariableExpression)node).getAccessedVariable()) != null && !(var instanceof Parameter) && !(var instanceof VariableExpression)) {
            ClassNode ownerType = scope.getEnclosingClosure() != null ? SimpleTypeLookup.getBaseDeclaringType(scope.getOwner()) : scope.getEnclosingTypeDeclaration();
            return ownerType;
        }
        return VariableScope.OBJECT_CLASS_NODE;
    }

    protected TypeLookupResult findType(Expression node, ClassNode declaringType, VariableScope scope, boolean isPrimaryExpression, boolean isStaticObjectExpression) {
        MethodNode target;
        ClassNode nodeType = node.getType();
        TypeLookupResult.TypeConfidence confidence = TypeLookupResult.TypeConfidence.EXACT;
        if (scope.isMethodCall() && (target = SimpleTypeLookup.getMethodTarget(node)) != null) {
            return new TypeLookupResult(target.getReturnType(), target.getDeclaringClass(), target, confidence, scope);
        }
        if (node instanceof VariableExpression) {
            return this.findTypeForVariable((VariableExpression)node, scope, declaringType);
        }
        if (node instanceof ConstantExpression) {
            if (isPrimaryExpression) {
                if (scope.isMethodCall()) {
                    VariableExpression call = new VariableExpression(new DynamicVariable(node.getText(), false));
                    TypeLookupResult result = this.findTypeForVariable(call, scope, declaringType);
                    if (SimpleTypeLookup.isCompatible((AnnotatedNode)result.declaration, isStaticObjectExpression)) {
                        return result;
                    }
                    if (isStaticObjectExpression) {
                        return this.findTypeForVariable(call, scope, VariableScope.newClassClassNode(declaringType));
                    }
                }
            } else {
                VariableScope outer = (VariableScope)declaringType.getNodeMetaData("outer.scope");
                if (outer != null) {
                    try {
                        outer.setMethodCallArgumentTypes(scope.getMethodCallArgumentTypes());
                        TypeLookupResult typeLookupResult = this.findTypeForVariable(new VariableExpression(new DynamicVariable(node.getText(), false)), outer, declaringType);
                        return typeLookupResult;
                    }
                    finally {
                        outer.setMethodCallArgumentTypes(null);
                    }
                }
                if (scope.getEnclosingNode() instanceof AttributeExpression) {
                    ClassNode clazz = !isStaticObjectExpression ? declaringType : declaringType.getGenericsTypes()[0].getType();
                    FieldNode field = null;
                    if (!SimpleTypeLookup.isSuperObjectExpression(scope)) {
                        field = clazz.getDeclaredField(node.getText());
                        clazz = clazz.getSuperClass();
                    }
                    while (field == null && clazz != null) {
                        field = clazz.getDeclaredField(node.getText());
                        if (field != null && (field.isPrivate() || !field.isPublic() && !field.isProtected() && !Objects.equals(clazz.getPackage(), scope.getEnclosingTypeDeclaration().getPackage()))) {
                            field = null;
                        }
                        clazz = clazz.getSuperClass();
                    }
                    if (SimpleTypeLookup.isCompatible(field, isStaticObjectExpression)) {
                        return new TypeLookupResult(field.getType(), field.getDeclaringClass(), field, confidence, scope);
                    }
                    if (!SimpleTypeLookup.isSuperObjectExpression(scope)) {
                        return new TypeLookupResult(VariableScope.VOID_CLASS_NODE, null, null, TypeLookupResult.TypeConfidence.UNKNOWN, scope);
                    }
                }
                if ("new".equals(node.getText()) && isStaticObjectExpression && SimpleTypeLookup.isStaticReferenceToInstanceMethod(scope)) {
                    return new TypeLookupResult(declaringType.getGenericsTypes()[0].getType(), null, node, confidence, scope);
                }
                boolean isLhsExpression = scope.getWormhole().remove("lhs") == node;
                return this.findTypeForNameWithKnownObjectExpression(node.getText(), nodeType, declaringType, scope, isLhsExpression, isStaticObjectExpression);
            }
            ConstantExpression cexp = (ConstantExpression)node;
            if (cexp.isNullExpression()) {
                return new TypeLookupResult(VariableScope.NULL_TYPE, null, null, confidence, scope);
            }
            if (cexp.isTrueExpression() || cexp.isFalseExpression()) {
                return new TypeLookupResult(VariableScope.BOOLEAN_CLASS_NODE, null, null, confidence, scope);
            }
            if (cexp.isEmptyStringExpression() || VariableScope.STRING_CLASS_NODE.equals(nodeType)) {
                return new TypeLookupResult(VariableScope.STRING_CLASS_NODE, null, node, confidence, scope);
            }
            if (ClassHelper.isNumberType(nodeType) || VariableScope.BIG_DECIMAL_CLASS.equals(nodeType) || VariableScope.BIG_INTEGER_CLASS.equals(nodeType)) {
                return new TypeLookupResult(GroovyUtils.getWrapperTypeIfPrimitive(nodeType), null, null, confidence, scope);
            }
            return new TypeLookupResult(nodeType, null, null, TypeLookupResult.TypeConfidence.UNKNOWN, scope);
        }
        if (node instanceof BooleanExpression) {
            return new TypeLookupResult(VariableScope.BOOLEAN_CLASS_NODE, null, null, confidence, scope);
        }
        if (node instanceof GStringExpression) {
            return new TypeLookupResult(VariableScope.GSTRING_CLASS_NODE, null, null, confidence, scope);
        }
        if (node instanceof EmptyExpression) {
            return new TypeLookupResult(null, null, null, confidence, scope);
        }
        if (node instanceof CastExpression) {
            return new TypeLookupResult(nodeType, null, null, confidence, scope);
        }
        if (node instanceof ClassExpression) {
            ClassNode classType = VariableScope.newClassClassNode(nodeType);
            return new TypeLookupResult(classType, null, nodeType, confidence, scope);
        }
        if (node instanceof ClosureExpression) {
            ClassNode returnType;
            if (VariableScope.isPlainClosure(nodeType) && (returnType = (ClassNode)node.getNodeMetaData("returnType")) != null && !VariableScope.isVoidOrObject(returnType)) {
                GroovyUtils.updateClosureWithInferredTypes(nodeType, returnType, ((ClosureExpression)node).getParameters());
            }
            return new TypeLookupResult(nodeType, null, node, confidence, scope);
        }
        if (node instanceof BitwiseNegationExpression) {
            ClassNode type = ((BitwiseNegationExpression)node).getExpression().getType();
            if (VariableScope.STRING_CLASS_NODE.equals(type)) {
                type = VariableScope.PATTERN_CLASS_NODE;
            }
            return new TypeLookupResult(type, null, null, confidence, scope);
        }
        if (node instanceof ConstructorCallExpression) {
            AnnotatedNode declaration;
            List<ConstructorNode> declaredConstructors;
            ConstructorCallExpression call = (ConstructorCallExpression)node;
            ClassNode resolvedDeclaringType = declaringType;
            if (call.isSpecialCall()) {
                nodeType = VariableScope.VOID_CLASS_NODE;
                resolvedDeclaringType = scope.getEnclosingMethodDeclaration().getDeclaringClass();
                if (call.isSuperCall()) {
                    resolvedDeclaringType = resolvedDeclaringType.getUnresolvedSuperClass(false);
                }
            } else if (call.isUsingAnonymousInnerClass()) {
                nodeType = this.lookupType((ClassNode)call.getType(), (VariableScope)scope).type;
                resolvedDeclaringType = resolvedDeclaringType.getUnresolvedSuperClass(false);
            }
            if ((declaredConstructors = resolvedDeclaringType.getDeclaredConstructors()).size() > 1) {
                List<ClassNode> callTypes = scope.getMethodCallArgumentTypes();
                if (callTypes != null && !callTypes.isEmpty() && callTypes.get(0).equals(declaringType.getOuterClass()) && (call.isUsingAnonymousInnerClass() ? !scope.isStatic() : !Flags.isStatic(declaringType.getModifiers()))) {
                    callTypes.remove(0);
                }
                declaration = SimpleTypeLookup.findMethodDeclaration0(declaredConstructors, callTypes, false);
            } else {
                declaration = !declaredConstructors.isEmpty() ? (ASTNode)declaredConstructors.get(0) : resolvedDeclaringType;
            }
            return new TypeLookupResult(nodeType, resolvedDeclaringType, declaration, confidence, scope);
        }
        if (node instanceof StaticMethodCallExpression) {
            LinkedList<MethodNode> candidates = new LinkedList<MethodNode>();
            BiConsumer<ClassNode, String> collector = (classNode, methodName) -> {
                if (classNode.isAbstract() || classNode.isInterface() || GroovyUtils.implementsTrait(classNode)) {
                    LinkedHashSet<ClassNode> hierarchy = new LinkedHashSet<ClassNode>();
                    VariableScope.createTypeHierarchy(classNode, hierarchy, false);
                    hierarchy.forEach(type -> {
                        boolean bl = candidates.addAll(type.getMethods((String)methodName));
                    });
                } else {
                    candidates.addAll(classNode.getMethods((String)methodName));
                }
            };
            String methodName2 = ((StaticMethodCallExpression)node).getMethod();
            collector.accept(((StaticMethodCallExpression)node).getOwnerType(), methodName2);
            candidates.removeIf(candidate -> !candidate.isStatic());
            MethodNode closestMatch = SimpleTypeLookup.findMethodDeclaration0(candidates, scope.getMethodCallArgumentTypes(), true);
            return new TypeLookupResult(closestMatch.getReturnType(), closestMatch.getDeclaringClass(), closestMatch, TypeLookupResult.TypeConfidence.INFERRED, scope);
        }
        if (VariableScope.OBJECT_CLASS_NODE.equals(nodeType)) {
            confidence = TypeLookupResult.TypeConfidence.UNKNOWN;
        }
        return new TypeLookupResult(nodeType, declaringType, null, confidence, scope);
    }

    protected TypeLookupResult findTypeForNameWithKnownObjectExpression(String name, ClassNode type, ClassNode declaringType, VariableScope scope, boolean isLhsExpression, boolean isStaticObjectExpression) {
        ClassNode typeParam;
        ClassNode resolvedDeclaringType;
        ClassNode resolvedType;
        TypeLookupResult.TypeConfidence confidence = TypeLookupResult.TypeConfidence.EXACT;
        boolean isFieldAccessDirect = SimpleTypeLookup.isThisObjectExpression(scope) ? scope.isFieldAccessDirect() : false;
        ASTNode declaration = this.findDeclaration(name, declaringType, isLhsExpression, isStaticObjectExpression, isFieldAccessDirect, scope.getMethodCallArgumentTypes());
        if (declaration instanceof MethodNode && scope.getEnclosingNode() instanceof PropertyExpression && !scope.isMethodCall() && (!AccessorSupport.isGetter((MethodNode)declaration) || name.equals(((MethodNode)declaration).getName()))) {
            declaration = null;
        }
        if (declaration != null) {
            resolvedType = SimpleTypeLookup.getTypeFromDeclaration(declaration);
            resolvedDeclaringType = SimpleTypeLookup.getDeclaringTypeFromDeclaration(declaration, declaringType);
        } else if ("call".equals(name)) {
            resolvedType = VariableScope.OBJECT_CLASS_NODE;
            resolvedDeclaringType = VariableScope.CLOSURE_CLASS_NODE;
            declaration = resolvedDeclaringType.getMethods("call").get(0);
        } else if ("this".equals(name) && VariableScope.CLASS_CLASS_NODE.equals(declaringType)) {
            resolvedType = resolvedDeclaringType = declaringType.getGenericsTypes()[0].getType();
            declaration = resolvedDeclaringType;
        } else {
            resolvedType = VariableScope.OBJECT_CLASS_NODE;
            resolvedDeclaringType = declaringType;
            confidence = TypeLookupResult.TypeConfidence.UNKNOWN;
        }
        if (declaration != null) {
            if (!VariableScope.CLASS_CLASS_NODE.equals(resolvedDeclaringType) && !VariableScope.CLASS_CLASS_NODE.equals(resolvedType)) {
                if (declaration instanceof FieldNode) {
                    FieldNode field = (FieldNode)declaration;
                    if (isStaticObjectExpression && !field.isStatic()) {
                        confidence = TypeLookupResult.TypeConfidence.UNKNOWN;
                    } else if (field.isPrivate()) {
                        if (SimpleTypeLookup.isSuperObjectExpression(scope)) {
                            confidence = TypeLookupResult.TypeConfidence.UNKNOWN;
                        } else if (SimpleTypeLookup.isThisObjectExpression(scope) && SimpleTypeLookup.isNotThisOrOuterClass(declaringType, resolvedDeclaringType)) {
                            confidence = TypeLookupResult.TypeConfidence.UNKNOWN;
                        }
                    }
                } else if (declaration instanceof PropertyNode) {
                    FieldNode underlyingField = ((PropertyNode)declaration).getField();
                    if (underlyingField != null) {
                        if (isStaticObjectExpression && !underlyingField.isStatic()) {
                            confidence = TypeLookupResult.TypeConfidence.UNKNOWN;
                        }
                    } else if (isStaticObjectExpression && !((PropertyNode)declaration).isStatic()) {
                        confidence = TypeLookupResult.TypeConfidence.UNKNOWN;
                    }
                } else if (declaration instanceof MethodNode) {
                    MethodNode method = (MethodNode)declaration;
                    if (isStaticObjectExpression && !method.isStatic() && !SimpleTypeLookup.isStaticReferenceToInstanceMethod(scope)) {
                        confidence = TypeLookupResult.TypeConfidence.UNKNOWN;
                    } else if (method.isPrivate() && SimpleTypeLookup.isThisObjectExpression(scope) && SimpleTypeLookup.isNotThisOrOuterClass(declaringType, resolvedDeclaringType)) {
                        confidence = TypeLookupResult.TypeConfidence.UNKNOWN;
                    } else if (!(!SimpleTypeLookup.isLooseMatch(scope.getMethodCallArgumentTypes(), method.getParameters()) || isStaticObjectExpression && SimpleTypeLookup.isStaticReferenceToUnambiguousMethod(scope, name, declaringType) || AccessorSupport.isGetter(method) && !scope.isMethodCall() && scope.getEnclosingNode() instanceof PropertyExpression)) {
                        confidence = TypeLookupResult.TypeConfidence.LOOSELY_INFERRED;
                    }
                    if (SimpleTypeLookup.isTraitHelper(resolvedDeclaringType) && method.getOriginal() != method) {
                        resolvedDeclaringType = method.getOriginal().getDeclaringClass();
                        declaration = method.getOriginal();
                    }
                }
                if (confidence.isAtLeast(TypeLookupResult.TypeConfidence.INFERRED) && isLhsExpression && SimpleTypeLookup.isCompoundAssignment(scope)) {
                    if (declaration instanceof MethodNode) {
                        confidence = TypeLookupResult.TypeConfidence.LOOSELY_INFERRED;
                    } else if (SimpleTypeLookup.findPropertyAccessorMethod(name, declaringType, false, isStaticObjectExpression, null).filter(getter -> !SimpleTypeLookup.isSynthetic(getter) && (!isFieldAccessDirect || !declaringType.equals(getter.getDeclaringClass()))).isPresent()) {
                        confidence = TypeLookupResult.TypeConfidence.LOOSELY_INFERRED;
                    }
                }
            } else if (VariableScope.CLASS_CLASS_NODE.equals(resolvedDeclaringType) && declaration instanceof MethodNode) {
                MethodNode classMethod = (MethodNode)declaration;
                if (isStaticObjectExpression && !classMethod.isStatic()) {
                    List argumentTypes = scope.getMethodCallArgumentTypes();
                    if (argumentTypes == null && !name.equals(classMethod.getName()) && !isLhsExpression) {
                        argumentTypes = Collections.EMPTY_LIST;
                    }
                    if (SimpleTypeLookup.isLooseMatch(argumentTypes, ((MethodNode)declaration).getParameters())) {
                        confidence = TypeLookupResult.TypeConfidence.UNKNOWN;
                    }
                }
            }
        }
        if (confidence.isLessThan(TypeLookupResult.TypeConfidence.INFERRED) && VariableScope.CLASS_CLASS_NODE.equals(declaringType) && GroovyUtils.getGenericsTypes(declaringType).length > 0 && !VariableScope.CLASS_CLASS_NODE.equals(typeParam = declaringType.getGenericsTypes()[0].getType()) && !VariableScope.OBJECT_CLASS_NODE.equals(typeParam)) {
            return this.findTypeForNameWithKnownObjectExpression(name, resolvedType, typeParam, scope, isLhsExpression, isStaticObjectExpression);
        }
        return new TypeLookupResult(resolvedType, resolvedDeclaringType, declaration, confidence, scope);
    }

    protected TypeLookupResult findTypeForVariable(VariableExpression var, VariableScope scope, ClassNode declaringType) {
        boolean isDirectAccess;
        ASTNode decl = var;
        ClassNode type = var.getType();
        ClassNode resolvedDeclaringType = declaringType;
        TypeLookupResult.TypeConfidence confidence = TypeLookupResult.TypeConfidence.EXACT;
        Variable accessedVar = var.getAccessedVariable();
        VariableScope.VariableInfo variableInfo = scope.lookupName(var.getName());
        int resolveStrategy = scope.getEnclosingClosureResolveStrategy();
        boolean isAssignTarget = scope.getWormhole().get("lhs") == var;
        boolean bl = isDirectAccess = accessedVar instanceof AnnotatedNode && resolvedDeclaringType.equals(((AnnotatedNode)((Object)accessedVar)).getDeclaringClass());
        if (accessedVar instanceof FieldNode && (!isDirectAccess || !scope.isFieldAccessDirect()) || isDirectAccess && resolveStrategy != 0 && resolveStrategy != 2) {
            accessedVar = new DynamicVariable(var.getName(), scope.isStatic());
        }
        if (accessedVar instanceof ASTNode) {
            decl = (ASTNode)((Object)accessedVar);
            if (decl instanceof FieldNode || decl instanceof MethodNode || decl instanceof PropertyNode) {
                PropertyNode prop;
                if (decl instanceof PropertyNode && (prop = (PropertyNode)decl).isDynamicTyped() && prop.getField().hasNoRealSourcePosition()) {
                    Optional<MethodNode> accessor = SimpleTypeLookup.findPropertyAccessorMethod(prop.getName(), resolvedDeclaringType, isAssignTarget, prop.isStatic(), scope.getMethodCallArgumentTypes());
                    decl = accessor.map(meth -> meth).orElse(decl);
                }
                type = SimpleTypeLookup.getTypeFromDeclaration(decl);
                resolvedDeclaringType = ((AnnotatedNode)decl).getDeclaringClass();
                if (decl instanceof MethodNode || !((Variable)((Object)decl)).isDynamicTyped()) {
                    variableInfo = null;
                }
            }
        } else if (accessedVar instanceof DynamicVariable) {
            ASTNode candidate = this.findDeclarationForDynamicVariable(var, resolvedDeclaringType = SimpleTypeLookup.getMorePreciseType(resolvedDeclaringType, variableInfo), scope, isAssignTarget, resolveStrategy);
            if (candidate != null && (!(candidate instanceof MethodNode) || scope.isMethodCall() || (AccessorSupport.isGetter((MethodNode)candidate) || AccessorSupport.isSetter((MethodNode)candidate)) && !var.getName().equals(((MethodNode)candidate).getName()))) {
                if (candidate instanceof FieldNode) {
                    FieldNode field = (FieldNode)candidate;
                    ClassNode owner = field.getDeclaringClass();
                    if (field.getName().contains("__") && GroovyUtils.implementsTrait(owner)) {
                        candidate = SimpleTypeLookup.findTraitField(field.getName(), owner).orElse(field);
                    } else if (field.isPrivate() && SimpleTypeLookup.isNotThisOrOuterClass(resolvedDeclaringType, field.getDeclaringClass())) {
                        confidence = TypeLookupResult.TypeConfidence.UNKNOWN;
                    }
                } else if (candidate instanceof MethodNode) {
                    MethodNode method = (MethodNode)candidate;
                    List<ClassNode> argumentTypes = scope.getMethodCallArgumentTypes();
                    if (argumentTypes != null && SimpleTypeLookup.isLooseMatch(argumentTypes, method.getParameters())) {
                        confidence = TypeLookupResult.TypeConfidence.LOOSELY_INFERRED;
                    }
                    if (method.isPrivate() && SimpleTypeLookup.isNotThisOrOuterClass(resolvedDeclaringType, method.getDeclaringClass())) {
                        confidence = TypeLookupResult.TypeConfidence.UNKNOWN;
                    }
                }
                if (confidence.isAtLeast(TypeLookupResult.TypeConfidence.INFERRED) && isAssignTarget && SimpleTypeLookup.isCompoundAssignment(scope) && (candidate instanceof MethodNode || !candidate.equals(this.findDeclarationForDynamicVariable(var, resolvedDeclaringType, scope, false, resolveStrategy)))) {
                    confidence = TypeLookupResult.TypeConfidence.LOOSELY_INFERRED;
                }
                decl = candidate;
                type = SimpleTypeLookup.getTypeFromDeclaration(decl);
                if (!VariableScope.CLOSURE_CLASS_NODE.equals(resolvedDeclaringType = SimpleTypeLookup.getDeclaringTypeFromDeclaration(decl, resolvedDeclaringType))) {
                    variableInfo = null;
                }
            } else {
                type = VariableScope.OBJECT_CLASS_NODE;
                confidence = TypeLookupResult.TypeConfidence.UNKNOWN;
                if (variableInfo != null && !scope.inScriptRunMethod()) {
                    variableInfo = null;
                }
            }
        }
        if (variableInfo != null) {
            type = variableInfo.type != null ? variableInfo.type : VariableScope.OBJECT_CLASS_NODE;
            resolvedDeclaringType = SimpleTypeLookup.getMorePreciseType(resolvedDeclaringType, variableInfo);
            if (VariableScope.isThisOrSuper(var)) {
                decl = type;
            }
            confidence = TypeLookupResult.TypeConfidence.INFERRED;
        }
        return new TypeLookupResult(type, resolvedDeclaringType, decl, confidence, scope);
    }

    protected ASTNode findDeclarationForDynamicVariable(VariableExpression var, ClassNode owner, VariableScope scope, boolean isAssignTarget, int resolveStrategy) {
        ASTNode candidate = null;
        List<ClassNode> callArgs = scope.getMethodCallArgumentTypes();
        if (resolveStrategy == 1 || resolveStrategy == 3) {
            candidate = this.findDeclaration(var.getName(), scope.getDelegate(), isAssignTarget, false, false, callArgs);
        }
        if (candidate == null && resolveStrategy < 3) {
            VariableScope outer = (VariableScope)owner.getNodeMetaData("outer.scope");
            if (outer != null) {
                try {
                    outer.setMethodCallArgumentTypes(callArgs);
                    candidate = this.findDeclarationForDynamicVariable(var, SimpleTypeLookup.getBaseDeclaringType(outer.getOwner()), outer, isAssignTarget, outer.getEnclosingClosureResolveStrategy());
                }
                finally {
                    outer.setMethodCallArgumentTypes(null);
                }
            } else {
                candidate = this.findDeclaration(var.getName(), owner, isAssignTarget, scope.isOwnerStatic(), scope.isFieldAccessDirect(), callArgs);
            }
            if (candidate == null && resolveStrategy < 1 && scope.getEnclosingClosure() != null) {
                candidate = this.findDeclaration(var.getName(), scope.getDelegate(), isAssignTarget, false, false, callArgs);
            }
            if (candidate == null && scope.getEnclosingClosure() == null && scope.getEnclosingMethodDeclaration() != null) {
                Parameter[] parameterArray = scope.getEnclosingMethodDeclaration().getParameters();
                int n = parameterArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Parameter parameter = parameterArray[n2];
                    if (parameter.getName().equals(var.getName())) {
                        candidate = parameter;
                        break;
                    }
                    ++n2;
                }
            }
        }
        if (candidate == null && resolveStrategy <= 4 && (resolveStrategy > 0 || scope.getEnclosingClosure() != null)) {
            candidate = this.findDeclaration(var.getName(), VariableScope.CLOSURE_CLASS_NODE, isAssignTarget, false, false, callArgs);
        }
        return candidate;
    }

    protected ASTNode findDeclaration(String name, ClassNode declaringType, boolean isLhsExpression, boolean isStaticExpression, boolean directFieldAccess, List<ClassNode> methodCallArgumentTypes) {
        MethodNode method;
        if (declaringType.isArray()) {
            if ("length".equals(name)) {
                return SimpleTypeLookup.createLengthField(declaringType);
            }
            return this.findDeclaration(name, VariableScope.OBJECT_CLASS_NODE, isLhsExpression, isStaticExpression, directFieldAccess, methodCallArgumentTypes);
        }
        if (!isLhsExpression && methodCallArgumentTypes != null && SimpleTypeLookup.isCompatible(method = this.findMethodDeclaration(name, declaringType, methodCallArgumentTypes, isStaticExpression), isStaticExpression)) {
            return method;
        }
        Optional<MethodNode> accessor = SimpleTypeLookup.findPropertyAccessorMethod(name, declaringType, isLhsExpression, isStaticExpression, methodCallArgumentTypes);
        if (accessor.filter(it -> !SimpleTypeLookup.isSynthetic(it) && (!directFieldAccess || !declaringType.equals(it.getDeclaringClass()))).isPresent()) {
            return accessor.get();
        }
        LinkedHashSet<ClassNode> typeHierarchy = new LinkedHashSet<ClassNode>();
        VariableScope.createTypeHierarchy(declaringType, typeHierarchy, true);
        for (ClassNode type : typeHierarchy) {
            Object property = type.getProperty(name);
            if (property == null && GroovyUtils.implementsTrait(declaringType) && Traits.isTrait(type)) {
                property = Optional.ofNullable((List)type.redirect().getNodeMetaData("trait.properties")).flatMap(list -> list.stream().filter(prop -> prop.getName().equals(name)).findFirst()).orElse(null);
            }
            if (!SimpleTypeLookup.isCompatible((AnnotatedNode)property, isStaticExpression)) continue;
            return property;
        }
        FieldNode field = declaringType.getField(name);
        if (SimpleTypeLookup.isCompatible(field, isStaticExpression)) {
            return field;
        }
        typeHierarchy.clear();
        VariableScope.findAllInterfaces(declaringType, typeHierarchy, true);
        for (ClassNode type : typeHierarchy) {
            if (type == declaringType || (field = type.getField(name)) == null || !field.isFinal() || !field.isStatic()) continue;
            return field;
        }
        if (accessor.isPresent()) {
            return accessor.get();
        }
        if (SimpleTypeLookup.getBaseDeclaringType(declaringType).getOuterClass() != null) {
            boolean isStatic = isStaticExpression || Flags.isStatic(declaringType.getModifiers());
            ASTNode declaration = this.findDeclaration(name, SimpleTypeLookup.getBaseDeclaringType(declaringType).getOuterClass(), isLhsExpression, isStatic, directFieldAccess, methodCallArgumentTypes);
            if (declaration != null) {
                return declaration;
            }
        }
        if (methodCallArgumentTypes == null) {
            return this.findMethodDeclaration(name, declaringType, methodCallArgumentTypes, isStaticExpression);
        }
        return null;
    }

    protected MethodNode findMethodDeclaration(String name, ClassNode declaringType, List<ClassNode> argumentTypes, boolean isStaticExpression) {
        if (!(declaringType.isAbstract() || declaringType.isInterface() || GroovyUtils.implementsTrait(declaringType))) {
            List<MethodNode> candidates = declaringType.getMethods(name);
            if (candidates.isEmpty()) {
                candidates = declaringType.getAllDeclaredMethods().stream().filter(meth -> meth.isDefault() && meth.getName().equals(name)).collect(Collectors.toList());
            }
            if (!candidates.isEmpty()) {
                return SimpleTypeLookup.findMethodDeclaration0(candidates, argumentTypes, isStaticExpression);
            }
            return null;
        }
        LinkedHashSet<ClassNode> types = new LinkedHashSet<ClassNode>();
        if (!declaringType.isInterface()) {
            types.add(declaringType);
        }
        VariableScope.findAllInterfaces(declaringType, types, true);
        if (!GroovyUtils.implementsTrait(declaringType)) {
            types.add(VariableScope.OBJECT_CLASS_NODE);
        }
        MethodNode outerCandidate = null;
        for (ClassNode type : types) {
            MethodNode innerCandidate = null;
            List<MethodNode> candidates = SimpleTypeLookup.getMethods(name, type);
            if (!candidates.isEmpty() && (innerCandidate = SimpleTypeLookup.findMethodDeclaration0(candidates, argumentTypes, isStaticExpression)) != null) {
                if (SimpleTypeLookup.isTraitBridge(innerCandidate)) continue;
                if (outerCandidate == null) {
                    outerCandidate = innerCandidate;
                }
            }
            if (innerCandidate == null || argumentTypes == null) continue;
            Parameter[] methodParameters = innerCandidate.getParameters();
            if (argumentTypes.isEmpty() && methodParameters.length == 0) {
                return innerCandidate;
            }
            if (argumentTypes.size() != methodParameters.length) continue;
            outerCandidate = innerCandidate;
            Boolean suitable = SimpleTypeLookup.isTypeCompatible(argumentTypes, methodParameters);
            if (Boolean.FALSE.equals(suitable) || !Boolean.TRUE.equals(suitable)) continue;
            return innerCandidate;
        }
        return outerCandidate;
    }

    /*
     * WARNING - void declaration
     */
    protected static MethodNode findMethodDeclaration0(List<? extends MethodNode> candidates, List<ClassNode> argumentTypes, boolean isStaticExpression) {
        void var3_9;
        void var3_7;
        Parameter[] parameters;
        if (argumentTypes == null) {
            for (MethodNode methodNode : candidates) {
                if (!SimpleTypeLookup.isCompatible(methodNode, isStaticExpression)) continue;
                return methodNode;
            }
            return candidates.get(0);
        }
        Object var3_6 = null;
        int argumentCount = argumentTypes.size();
        for (MethodNode methodNode : candidates) {
            parameters = methodNode.getParameters();
            if (parameters.length == 0) {
                if (argumentCount != 0) continue;
                return methodNode;
            }
            if (argumentCount != parameters.length && (argumentCount < parameters.length - 1 || !GenericsMapper.isVargs(parameters))) continue;
            Boolean suitable = SimpleTypeLookup.isTypeCompatible(argumentTypes, parameters);
            if (Boolean.TRUE.equals(suitable)) {
                return methodNode;
            }
            if (Boolean.FALSE.equals(suitable)) continue;
            MethodNode methodNode2 = SimpleTypeLookup.closer(methodNode, (MethodNode)var3_7, argumentTypes);
        }
        if (var3_7 == null && argumentCount > 0 && argumentTypes.stream().anyMatch(t -> ClassHelper.isPrimitiveType(ClassHelper.getUnwrapper(t)) || ClassHelper.OBJECT_TYPE.equals(t) || ClassHelper.STRING_TYPE.equals(t))) {
            for (MethodNode methodNode : candidates) {
                parameters = methodNode.getParameters();
                if (argumentCount != parameters.length && (argumentCount < parameters.length - 1 || !GenericsMapper.isVargs(parameters))) continue;
                if (SimpleTypeLookup.isCompatible(methodNode, isStaticExpression)) {
                    return methodNode;
                }
                MethodNode methodNode3 = methodNode;
            }
        }
        return var3_9;
    }

    protected static Optional<MethodNode> findPropertyAccessorMethod(String propertyName, ClassNode declaringType, boolean isLhsExpression, boolean isStaticExpression, List<ClassNode> methodCallArgumentTypes) {
        Stream<MethodNode> accessors = AccessorSupport.findAccessorMethodsForPropertyName(propertyName, declaringType, false, !isLhsExpression ? READER : WRITER);
        accessors = accessors.filter(accessor -> SimpleTypeLookup.isCompatible(accessor, isStaticExpression) && !SimpleTypeLookup.isTraitBridge(accessor));
        if (isLhsExpression) {
            accessors = accessors.sorted((m1, m2) -> m1 == SimpleTypeLookup.closer(m2, m1, methodCallArgumentTypes) ? -1 : 1);
        }
        return accessors.findFirst();
    }

    protected static MethodNode closer(MethodNode next, MethodNode last, List<ClassNode> args) {
        long d2;
        long d1;
        if (last != null && (d1 = CategoryTypeLookup.calculateParameterDistance(args, last.getParameters())) < (d2 = CategoryTypeLookup.calculateParameterDistance(args, next.getParameters()))) {
            return last;
        }
        return next;
    }

    protected static FieldNode createLengthField(ClassNode declaringType) {
        FieldNode lengthField = new FieldNode("length", 1, VariableScope.INTEGER_CLASS_NODE, declaringType, null);
        lengthField.setDeclaringClass(declaringType);
        return lengthField;
    }

    protected static ClassNode getBaseDeclaringType(ClassNode declaringType) {
        ClassNode typeParam;
        if (VariableScope.CLASS_CLASS_NODE.equals(declaringType) && declaringType.isUsingGenerics() && !VariableScope.CLASS_CLASS_NODE.equals(typeParam = declaringType.getGenericsTypes()[0].getType()) && !VariableScope.OBJECT_CLASS_NODE.equals(typeParam)) {
            return typeParam;
        }
        return declaringType;
    }

    protected static List<MethodNode> getMethods(String name, ClassNode type) {
        List<MethodNode> methods = type.getMethods(name);
        List traitMethods = (List)type.redirect().getNodeMetaData("trait.methods");
        if (traitMethods != null) {
            methods = new ArrayList<MethodNode>(methods);
            for (MethodNode method : traitMethods) {
                if (!method.getName().equals(name)) continue;
                methods.add(method);
            }
        }
        return methods;
    }

    protected static MethodNode getMethodTarget(Expression expr) {
        if (expr instanceof MethodCallExpression) {
            MethodNode target = ((MethodCallExpression)expr).getMethodTarget();
            return target;
        }
        OptimizingStatementWriter.StatementMeta meta = (OptimizingStatementWriter.StatementMeta)expr.getNodeMetaData(OptimizingStatementWriter.StatementMeta.class);
        if (meta != null) {
            MethodNode target = (MethodNode)ReflectionUtils.getPrivateField(OptimizingStatementWriter.StatementMeta.class, "target", meta);
            return target;
        }
        return null;
    }

    protected static ClassNode getMorePreciseType(ClassNode declaringType, VariableScope.VariableInfo info) {
        ClassNode maybeDeclaringType;
        ClassNode classNode = maybeDeclaringType = info != null ? info.declaringType : VariableScope.OBJECT_CLASS_NODE;
        if (maybeDeclaringType.equals(VariableScope.OBJECT_CLASS_NODE) && !VariableScope.OBJECT_CLASS_NODE.equals(declaringType)) {
            return declaringType;
        }
        return maybeDeclaringType;
    }

    protected static ClassNode getTypeFromDeclaration(ASTNode declaration) {
        ClassNode type;
        PropertyNode property;
        ASTNode decl = declaration;
        if (decl instanceof PropertyNode && (property = (PropertyNode)decl).getField() != null) {
            decl = property.getField();
        }
        if (decl instanceof FieldNode) {
            FieldNode field = (FieldNode)decl;
            type = field.getType();
        } else {
            type = decl instanceof ConstructorNode ? ((ConstructorNode)decl).getDeclaringClass() : (decl instanceof MethodNode ? ((MethodNode)decl).getReturnType() : (decl instanceof Expression ? ((Expression)decl).getType() : VariableScope.OBJECT_CLASS_NODE));
        }
        return type;
    }

    protected static ClassNode getDeclaringTypeFromDeclaration(ASTNode declaration, ClassNode inferredDeclaringType) {
        ClassNode declaringType = declaration instanceof FieldNode ? ((FieldNode)declaration).getDeclaringClass() : (declaration instanceof MethodNode ? ((MethodNode)declaration).getDeclaringClass() : (declaration instanceof PropertyNode ? ((PropertyNode)declaration).getDeclaringClass() : VariableScope.OBJECT_CLASS_NODE));
        if (declaringType.equals(inferredDeclaringType)) {
            return inferredDeclaringType;
        }
        return declaringType;
    }

    protected static Optional<FieldNode> findTraitField(String name, ClassNode type) {
        String[] parts = name.split("__");
        ClassNode[] classNodeArray = type.getInterfaces();
        int n = classNodeArray.length;
        int n2 = 0;
        while (n2 < n) {
            ClassNode face = classNodeArray[n2];
            if (face.getName().equals(parts[0].replace('_', '.'))) {
                List traitFields = (List)face.redirect().getNodeMetaData("trait.fields");
                return Optional.ofNullable(traitFields).flatMap(fields -> fields.stream().filter(f -> f.getName().equals(parts[1])).findFirst());
            }
            ++n2;
        }
        return Optional.empty();
    }

    protected static boolean isCompoundAssignment(VariableScope scope) {
        return scope.getEnclosingAssignmentOperator().filter(op -> op.getType() != 100).isPresent();
    }

    protected static Expression getObjectExpression(VariableScope scope) {
        ASTNode node = scope.getEnclosingNode();
        if (node instanceof PropertyExpression) {
            return ((PropertyExpression)node).getObjectExpression();
        }
        if (node instanceof AttributeExpression) {
            return ((AttributeExpression)node).getObjectExpression();
        }
        if (node instanceof MethodCallExpression) {
            return ((MethodCallExpression)node).getObjectExpression();
        }
        return null;
    }

    protected static boolean isThisObjectExpression(VariableScope scope) {
        Expression expr = SimpleTypeLookup.getObjectExpression(scope);
        return expr instanceof VariableExpression && ((VariableExpression)expr).isThisExpression();
    }

    protected static boolean isSuperObjectExpression(VariableScope scope) {
        Expression expr = SimpleTypeLookup.getObjectExpression(scope);
        return expr instanceof VariableExpression && ((VariableExpression)expr).isSuperExpression();
    }

    protected static boolean isStaticReferenceToInstanceMethod(VariableScope scope) {
        if (scope.getEnclosingNode() instanceof MethodPointerExpression && scope.getCurrentNode() instanceof ConstantExpression) {
            int majorVersion = Integer.parseInt(GroovySystem.getVersion().split("\\.")[0], 10);
            return majorVersion >= 3;
        }
        return false;
    }

    protected static boolean isStaticReferenceToUnambiguousMethod(VariableScope scope, String name, ClassNode type) {
        if (scope.getEnclosingNode() instanceof ImportNode) {
            long staticMethodCount = SimpleTypeLookup.getMethods(name, type).stream().filter(meth -> SimpleTypeLookup.isCompatible(meth, true)).count();
            return staticMethodCount == 1L;
        }
        return false;
    }

    protected static boolean isCompatible(AnnotatedNode declaration, boolean isStaticExpression) {
        if (declaration != null) {
            boolean isStatic = false;
            if (declaration instanceof FieldNode) {
                isStatic = ((FieldNode)declaration).isStatic();
            } else if (declaration instanceof MethodNode) {
                isStatic = ((MethodNode)declaration).isStatic();
            } else if (declaration instanceof PropertyNode) {
                isStatic = ((PropertyNode)declaration).isStatic();
            }
            if (!isStaticExpression || isStatic || VariableScope.CLASS_CLASS_NODE.equals(declaration.getDeclaringClass()) || VariableScope.OBJECT_CLASS_NODE.equals(declaration.getDeclaringClass())) {
                return true;
            }
        }
        return false;
    }

    protected static boolean isNotThisOrOuterClass(ClassNode thisType, ClassNode declaringClass) {
        return !thisType.equals(declaringClass) && !thisType.getOuterClasses().contains(declaringClass) && (!GroovyUtils.implementsTrait(thisType) || !thisType.implementsInterface(declaringClass));
    }

    protected static boolean isSynthetic(MethodNode method) {
        return method.isSynthetic() || method.getDeclaringClass().equals(VariableScope.CLOSURE_CLASS_NODE);
    }

    protected static boolean isTraitBridge(MethodNode method) {
        return method.getAnnotations().stream().map(AnnotationNode::getClassNode).anyMatch(Traits.TRAITBRIDGE_CLASSNODE::equals);
    }

    protected static boolean isTraitHelper(ClassNode candidate) {
        return Flags.isSynthetic(candidate.getModifiers()) && candidate.getName().endsWith("Helper") && candidate.getName().contains("$Trait$") && Traits.isTrait(candidate.getOuterClass());
    }

    protected static boolean isLooseMatch(List<ClassNode> arguments, Parameter[] parameters) {
        ClassNode lastType;
        int argCount;
        int n = argCount = arguments == null ? -1 : arguments.size();
        if (argCount != parameters.length && (!GenericsMapper.isVargs(parameters) || argCount != parameters.length - 1 && argCount <= parameters.length)) {
            return true;
        }
        return argCount > 0 && arguments.get(argCount - 1).equals(VariableScope.CLOSURE_CLASS_NODE) && !(lastType = GroovyUtils.getBaseType(parameters[parameters.length - 1].getType())).equals(VariableScope.CLOSURE_CLASS_NODE);
    }

    protected static Boolean isTypeCompatible(List<ClassNode> arguments, Parameter[] parameters) {
        Boolean result = Boolean.TRUE;
        int i = 0;
        int n = Math.max(arguments.size(), parameters.length);
        while (i < n) {
            ClassNode argument;
            ClassNode parameter = parameters[Math.min(i, parameters.length - 1)].getType();
            ClassNode classNode = argument = i < arguments.size() ? arguments.get(i) : parameter;
            if (i >= parameters.length) {
                assert (parameter.isArray());
                parameter = parameter.getComponentType();
            } else if (!(i != parameters.length - 1 || arguments.size() < parameters.length || !parameter.isArray() || argument.isArray() && GroovyUtils.isAssignable(argument, parameter))) {
                parameter = parameter.getComponentType();
            }
            Boolean partialResult = SimpleTypeLookup.isTypeCompatible(argument, parameter);
            if (partialResult == null) {
                result = null;
            } else if (!partialResult.booleanValue()) {
                return Boolean.FALSE;
            }
            ++i;
        }
        if (arguments.size() != parameters.length || !arguments.isEmpty() && DefaultGroovyMethods.last(arguments).isArray() != DefaultGroovyMethods.last(parameters).getType().isArray()) {
            return null;
        }
        return result;
    }

    protected static Boolean isTypeCompatible(ClassNode source, ClassNode target) {
        Boolean result = Boolean.TRUE;
        if (!target.equals(source) && (VariableScope.NULL_TYPE != source || ClassHelper.isPrimitiveType(target))) {
            result = !GroovyUtils.isAssignable(source, target) && (!VariableScope.CLOSURE_CLASS_NODE.equals(source) || !ClassHelper.isSAMType(target)) ? Boolean.FALSE : null;
        }
        return result;
    }
}

