/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.groovy.core;

import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.core.runtime.IAdapterManager;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jdt.groovy.core.GroovyResourceAdapter;
import org.eclipse.jdt.internal.core.util.Util;
import org.osgi.framework.BundleContext;
import org.osgi.service.prefs.BackingStoreException;

public class Activator
extends Plugin {
    public static final String USING_PROJECT_PROPERTIES = "org.codehaus.groovy.eclipse.preferences.compiler.project";
    public static final String GROOVY_CHECK_FOR_COMPILER_MISMATCH = "groovy.check.for.compiler.mismatch";
    public static final String GROOVY_COMPILER_LEVEL = "groovy.compiler.level";
    public static final String GROOVY_SCRIPT_FILTERS = "groovy.script.filters";
    public static final String DEFAULT_GROOVY_SCRIPT_FILTER = "**/*.dsld,y,**/*.gradle,n";
    public static final String GROOVY_SCRIPT_FILTERS_ENABLED = "groovy.script.filters.enabled";
    public static final boolean DEFAULT_SCRIPT_FILTERS_ENABLED = true;
    public static final String PLUGIN_ID = "org.eclipse.jdt.groovy.core";
    private static Activator plugin;
    private IAdapterFactory factory;

    public static Activator getDefault() {
        return plugin;
    }

    public Activator() {
        plugin = this;
    }

    @Override
    public void start(BundleContext context) throws Exception {
        super.start(context);
        this.factory = new GroovyResourceAdapter();
        IAdapterManager manager = Platform.getAdapterManager();
        manager.registerAdapters(this.factory, IResource.class);
    }

    @Override
    public void stop(BundleContext context) throws Exception {
        IAdapterManager manager = Platform.getAdapterManager();
        manager.unregisterAdapters(this.factory);
        this.factory = null;
        super.stop(context);
    }

    public static IEclipsePreferences getInstancePreferences() {
        return InstanceScope.INSTANCE.getNode(PLUGIN_ID);
    }

    public static IEclipsePreferences getProjectPreferences(IProject project) {
        if (project == null) {
            return null;
        }
        return new ProjectScope(project).getNode(PLUGIN_ID);
    }

    public String getGroovyCompilerLevel(IProject project) {
        IEclipsePreferences preferences = Activator.getProjectPreferences(project);
        if (preferences != null) {
            return preferences.get(GROOVY_COMPILER_LEVEL, null);
        }
        return null;
    }

    public void setGroovyCompilerLevel(IProject project, String level) {
        IEclipsePreferences preferences = Activator.getProjectPreferences(project);
        if (preferences != null) {
            preferences.put(GROOVY_COMPILER_LEVEL, level);
            try {
                preferences.flush();
            }
            catch (BackingStoreException e) {
                Util.log(e);
            }
        }
    }

    public List<String> getScriptFilters(IEclipsePreferences preferences) {
        String value;
        if (preferences == null) {
            preferences = Activator.getInstancePreferences();
        }
        if ((value = preferences.get(GROOVY_SCRIPT_FILTERS, DEFAULT_GROOVY_SCRIPT_FILTER)) == null || value.trim().length() < 1) {
            return Collections.emptyList();
        }
        String[] tokens = value.split(",");
        return Arrays.asList(tokens);
    }

    public void setScriptFilters(IEclipsePreferences preferences, String value) {
        if (preferences == null) {
            preferences = Activator.getInstancePreferences();
        }
        preferences.put(GROOVY_SCRIPT_FILTERS, value);
        try {
            preferences.flush();
        }
        catch (BackingStoreException e) {
            Util.log(e);
        }
    }

    public void setScriptFilters(IEclipsePreferences preferences, List<String> values) {
        String value;
        if (values == null || values.isEmpty()) {
            value = "";
        } else {
            StringBuilder buffer = new StringBuilder();
            Iterator<String> it = values.iterator();
            while (it.hasNext()) {
                buffer.append(it.next());
                if (!it.hasNext()) continue;
                buffer.append(',');
            }
            value = buffer.toString();
        }
        this.setScriptFilters(preferences, value);
    }
}

