/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.jdt.groovy.internal.compiler;

import java.util.Comparator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.codehaus.jdt.groovy.integration.LanguageSupportFactory;
import org.codehaus.jdt.groovy.model.GroovyNature;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourceAttributes;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.compiler.BuildContext;
import org.eclipse.jdt.core.compiler.CategorizedProblem;
import org.eclipse.jdt.core.compiler.CompilationParticipant;
import org.eclipse.jdt.groovy.core.util.ScriptFolderSelector;
import org.eclipse.jdt.internal.compiler.problem.DefaultProblem;
import org.eclipse.jdt.internal.core.util.Util;

public class ScriptFolderCompilationParticipant
extends CompilationParticipant {
    private IJavaProject project;

    @Override
    public boolean isActive(IJavaProject project) {
        boolean hasGroovyNature = GroovyNature.hasGroovyNature(project.getProject());
        if (!hasGroovyNature) {
            return false;
        }
        this.project = project;
        return true;
    }

    @Override
    public void buildStarting(BuildContext[] compiledFiles, boolean isBatch) {
        if (!this.sanityCheckBuilder(compiledFiles)) {
            return;
        }
        try {
            IProject iproject = this.project.getProject();
            if (compiledFiles == null || !ScriptFolderSelector.isEnabled(iproject)) {
                return;
            }
            ScriptFolderSelector selector = new ScriptFolderSelector(iproject);
            Map<IContainer, IContainer> sourceToOut = this.generateSourceToOut(this.project);
            BuildContext[] buildContextArray = compiledFiles;
            int n = compiledFiles.length;
            int n2 = 0;
            while (n2 < n) {
                IPath filePath;
                IContainer containingSourceFolder;
                BuildContext compiledFile = buildContextArray[n2];
                IFile file = compiledFile.getFile();
                if (selector.getFileKind(file) == ScriptFolderSelector.FileKind.SCRIPT && (containingSourceFolder = this.findContainingSourceFolder(sourceToOut, filePath = file.getFullPath())) != null) {
                    IPath packagePath = this.findPackagePath(filePath, containingSourceFolder);
                    IContainer out = sourceToOut.get(containingSourceFolder);
                    this.copyFile(file, packagePath, out);
                }
                ++n2;
            }
        }
        catch (CoreException e) {
            Util.log(e, "Error when copying scripts to output folder");
        }
    }

    private boolean sanityCheckBuilder(BuildContext[] files) {
        if (!LanguageSupportFactory.isGroovyLanguageSupportInstalled()) {
            BuildContext[] buildContextArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                BuildContext buildContext = buildContextArray[n2];
                buildContext.recordNewProblems(this.createProblem(buildContext));
                ++n2;
            }
        }
        try {
            ICommand[] buildSpec = this.project.getProject().getDescription().getBuildSpec();
            boolean found = false;
            Object[] objectArray = buildSpec;
            int n = buildSpec.length;
            int n3 = 0;
            while (n3 < n) {
                ICommand command = objectArray[n3];
                if (command.getBuilderName().equals("org.eclipse.jdt.core.javabuilder")) {
                    found = true;
                    break;
                }
                ++n3;
            }
            if (!found) {
                objectArray = files;
                n = files.length;
                n3 = 0;
                while (n3 < n) {
                    Object buildContext = objectArray[n3];
                    ((BuildContext)buildContext).recordNewProblems(this.createProblem((BuildContext)buildContext));
                    ++n3;
                }
            }
            return found;
        }
        catch (CoreException e) {
            Util.log(e);
            return false;
        }
    }

    private CategorizedProblem[] createProblem(BuildContext buildContext) {
        DefaultProblem problem = new DefaultProblem(buildContext.getFile().getFullPath().toOSString().toCharArray(), "Error compiling Groovy project.  Either the Groovy-JDT patch is not installed or JavaBuilder is not being used.", 0, new String[0], 1, 0, 0, 1, 0);
        return new CategorizedProblem[]{problem};
    }

    @Override
    public void buildFinished(IJavaProject project) {
    }

    private IPath findPackagePath(IPath filePath, IContainer containingSourceFolder) {
        IPath containerPath = containingSourceFolder.getFullPath();
        filePath = filePath.removeFirstSegments(containerPath.segmentCount());
        filePath = filePath.removeLastSegments(1);
        return filePath;
    }

    private IContainer findContainingSourceFolder(Map<IContainer, IContainer> sourceToOut, IPath filePath) {
        Set<IContainer> sourceFolders = sourceToOut.keySet();
        for (IContainer container : sourceFolders) {
            if (!container.getFullPath().isPrefixOf(filePath)) continue;
            return container;
        }
        return null;
    }

    private void copyFile(IFile file, IPath packagePath, IContainer outputFolder) throws CoreException {
        IContainer createdFolder = this.createFolder(packagePath, outputFolder, true);
        IFile toFile = createdFolder.getFile(new Path(file.getName()));
        if (toFile.exists()) {
            toFile.delete(true, null);
        }
        file.copy(toFile.getFullPath(), true, null);
        ResourceAttributes newAttrs = new ResourceAttributes();
        newAttrs.setReadOnly(false);
        newAttrs.setHidden(false);
        toFile.setResourceAttributes(newAttrs);
        toFile.setDerived(true, null);
        toFile.refreshLocal(0, null);
    }

    private IContainer createFolder(IPath packagePath, IContainer outputFolder, boolean derived) throws CoreException {
        if (!outputFolder.exists() && outputFolder instanceof IFolder) {
            ((IFolder)outputFolder).create(true, true, null);
        }
        if (packagePath.isEmpty()) {
            return outputFolder;
        }
        IFolder folder = outputFolder.getFolder(packagePath);
        folder.refreshLocal(0, null);
        if (!folder.exists()) {
            this.createFolder(packagePath.removeLastSegments(1), outputFolder, derived);
            folder.create(true, true, null);
            folder.setDerived(derived, null);
            folder.refreshLocal(0, null);
        }
        return folder;
    }

    private Map<IContainer, IContainer> generateSourceToOut(IJavaProject project) throws JavaModelException {
        IProject p = project.getProject();
        IWorkspaceRoot root = (IWorkspaceRoot)p.getParent();
        IClasspathEntry[] cp = project.getRawClasspath();
        IPath defaultOutPath = project.getOutputLocation();
        IContainer defaultOutContainer = defaultOutPath.segmentCount() > 1 ? root.getFolder(defaultOutPath) : p;
        TreeMap<IContainer, IContainer> sourceToOut = new TreeMap<IContainer, IContainer>(Comparator.comparing(c -> c.getFullPath().segmentCount()).reversed().thenComparing(c -> c.toString()));
        IClasspathEntry[] iClasspathEntryArray = cp;
        int n = cp.length;
        int n2 = 0;
        while (n2 < n) {
            IPath outPath;
            IContainer outContainer;
            IPath sourcePath;
            IContainer sourceContainer;
            IClasspathEntry cpe = iClasspathEntryArray[n2];
            if (cpe.getEntryKind() == 3 && !(sourceContainer = (sourcePath = cpe.getPath()).segmentCount() > 1 ? root.getFolder(sourcePath) : p).equals(outContainer = (outPath = cpe.getOutputLocation()) == null ? defaultOutContainer : (outPath.segmentCount() > 1 ? root.getFolder(outPath) : p))) {
                sourceToOut.put(sourceContainer, outContainer);
            }
            ++n2;
        }
        return sourceToOut;
    }
}

