/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.jdt.groovy.internal.compiler.ast;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.jdt.groovy.internal.compiler.ast.GroovyClassScope;
import org.codehaus.jdt.groovy.internal.compiler.ast.GroovyCompilationUnitDeclaration;
import org.codehaus.jdt.groovy.internal.compiler.ast.GroovyTypeDeclaration;
import org.codehaus.jdt.groovy.internal.compiler.ast.JDTResolver;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.ast.CompilationUnitDeclaration;
import org.eclipse.jdt.internal.compiler.ast.ImportReference;
import org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.jdt.internal.compiler.ast.TypeReference;
import org.eclipse.jdt.internal.compiler.env.AccessRestriction;
import org.eclipse.jdt.internal.compiler.env.INameEnvironment;
import org.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.jdt.internal.compiler.lookup.BinaryTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.ClassScope;
import org.eclipse.jdt.internal.compiler.lookup.CompilationUnitScope;
import org.eclipse.jdt.internal.compiler.lookup.ImportBinding;
import org.eclipse.jdt.internal.compiler.lookup.LookupEnvironment;
import org.eclipse.jdt.internal.compiler.lookup.PackageBinding;
import org.eclipse.jdt.internal.compiler.lookup.ProblemReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.eclipse.jdt.internal.compiler.lookup.SourceTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.problem.AbortCompilation;
import org.eclipse.jdt.internal.core.builder.AbortIncrementalBuildException;
import org.eclipse.jdt.internal.core.builder.NameEnvironment;

public class GroovyCompilationUnitScope
extends CompilationUnitScope {
    private Map<String, ClassNode> typenameToClassNodeCache = new HashMap<String, ClassNode>();
    private static final char[][] javaLang = CharOperation.splitOn('.', "java.lang".toCharArray());
    private static final char[][] javaIo = CharOperation.splitOn('.', "java.io".toCharArray());
    private static final char[][] javaNet = CharOperation.splitOn('.', "java.net".toCharArray());
    private static final char[][] javaUtil = CharOperation.splitOn('.', "java.util".toCharArray());
    private static final char[][] groovyLang = CharOperation.splitOn('.', "groovy.lang".toCharArray());
    private static final char[][] groovyUtil = CharOperation.splitOn('.', "groovy.util".toCharArray());
    private static final char[][] javaMathBigDecimal = CharOperation.splitOn('.', "java.math.BigDecimal".toCharArray());
    private static final char[][] javaMathBigInteger = CharOperation.splitOn('.', "java.math.BigInteger".toCharArray());
    private static final char[] GROOVY = "groovy".toCharArray();
    private static final char[] LANG = "lang".toCharArray();
    private static final char[][] GROOVY_LANG_GROOVYOBJECT = new char[][]{GROOVY, LANG, "GroovyObject".toCharArray()};
    private boolean isScript = false;

    public GroovyCompilationUnitScope(GroovyCompilationUnitDeclaration compilationUnitDeclaration, LookupEnvironment lookupEnvironment) {
        super(compilationUnitDeclaration, lookupEnvironment);
        INameEnvironment nameEnvironment = lookupEnvironment.nameEnvironment;
        if (nameEnvironment instanceof NameEnvironment) {
            ((NameEnvironment)nameEnvironment).avoidAdditionalGroovyAnswers = true;
        }
    }

    protected ImportBinding[] getDefaultImports() {
        ImportBinding[] defaultImports = super.getDefaultImports();
        ArrayList<ImportBinding> importBindings = new ArrayList<ImportBinding>();
        importBindings.add(defaultImports[0]);
        PackageBinding importBinding = this.environment.createPackage(javaIo);
        importBindings.add(new ImportBinding(javaIo, true, importBinding, null));
        importBinding = this.environment.createPackage(javaNet);
        importBindings.add(new ImportBinding(javaNet, true, importBinding, null));
        importBinding = this.environment.createPackage(javaUtil);
        importBindings.add(new ImportBinding(javaUtil, true, importBinding, null));
        importBinding = this.environment.createPackage(groovyLang);
        importBindings.add(new ImportBinding(groovyLang, true, importBinding, null));
        importBinding = this.environment.createPackage(groovyUtil);
        importBindings.add(new ImportBinding(groovyUtil, true, importBinding, null));
        ReferenceBinding jmBigDecimal = this.environment.getType(javaMathBigDecimal);
        importBindings.add(new ImportBinding(javaMathBigDecimal, false, jmBigDecimal, null));
        ReferenceBinding jmBigInteger = this.environment.getType(javaMathBigInteger);
        importBindings.add(new ImportBinding(javaMathBigInteger, false, jmBigInteger, null));
        CompilerOptions co = this.compilerOptions();
        String extraImports = co.groovyExtraImports;
        if (extraImports != null) {
            try {
                String filename = new String(this.referenceContext.getFileName());
                StringTokenizer st = new StringTokenizer(extraImports, ";");
                while (st.hasMoreTokens()) {
                    String onesuffix = st.nextToken();
                    int equals = onesuffix.indexOf(61);
                    boolean shouldApply = false;
                    String imports = null;
                    if (equals == -1) {
                        shouldApply = true;
                        imports = onesuffix;
                    } else {
                        String suffix = onesuffix.substring(0, equals);
                        shouldApply = filename.endsWith(suffix);
                        imports = onesuffix.substring(equals + 1);
                    }
                    StringTokenizer st2 = new StringTokenizer(imports, ",");
                    while (st2.hasMoreTokens()) {
                        String nextElement = st2.nextToken();
                        if (nextElement.endsWith(".*")) {
                            char[] withoutDotStar = nextElement.substring(0, nextElement.length() - 2).toCharArray();
                            char[][] cs = CharOperation.splitOn('.', withoutDotStar);
                            importBinding = this.environment.createPackage(cs);
                            importBindings.add(new ImportBinding(cs, true, importBinding, null));
                            continue;
                        }
                        int asIndex = nextElement.indexOf(" as ");
                        String asName = null;
                        if (asIndex != -1) {
                            asName = nextElement.substring(asIndex + 4).trim();
                            nextElement = nextElement.substring(0, asIndex).trim();
                        }
                        char[] type = nextElement.toCharArray();
                        char[][] cs = CharOperation.splitOn('.', type);
                        ReferenceBinding typeBinding = this.environment.getType(cs);
                        importBindings.add(new ImportBinding(cs, false, typeBinding, null));
                        if (asName == null) continue;
                        char[] asNameChars = asName.toCharArray();
                        char[][] cs2 = new char[][]{asNameChars};
                        importBindings.add(new ImportBinding(cs2, false, typeBinding, null));
                    }
                }
            }
            catch (Exception e) {
                new RuntimeException("Problem processing extraImports: " + extraImports, e).printStackTrace();
            }
        }
        return importBindings.toArray(new ImportBinding[importBindings.size()]);
    }

    protected ClassScope buildClassScope(Scope parent, TypeDeclaration typeDecl) {
        return new GroovyClassScope(parent, typeDecl);
    }

    public void augmentTypeHierarchy() {
        int i = 0;
        int length = this.topLevelTypes.length;
        while (i < length) {
            this.augmentTypeHierarchy(this.topLevelTypes[i]);
            ++i;
        }
    }

    private void augmentTypeHierarchy(SourceTypeBinding typeBinding) {
        ReferenceBinding[] superInterfaceBindings;
        if (typeBinding.isAnnotationType() || typeBinding.isInterface()) {
            return;
        }
        ReferenceBinding groovyLangObjectBinding = this.getGroovyLangObjectBinding();
        if (!typeBinding.implementsInterface(groovyLangObjectBinding, true) && (superInterfaceBindings = typeBinding.superInterfaces) != null) {
            int count = superInterfaceBindings.length;
            ReferenceBinding[] referenceBindingArray = superInterfaceBindings;
            superInterfaceBindings = new ReferenceBinding[count + 1];
            System.arraycopy(referenceBindingArray, 0, superInterfaceBindings, 0, count);
            superInterfaceBindings[count] = groovyLangObjectBinding;
            typeBinding.superInterfaces = superInterfaceBindings;
        }
    }

    private final ReferenceBinding getGroovyLangObjectBinding() {
        CompilationUnitScope unitScope = this.compilationUnitScope();
        unitScope.recordQualifiedReference(GROOVY_LANG_GROOVYOBJECT);
        return unitScope.environment.getResolvedType(GROOVY_LANG_GROOVYOBJECT, this);
    }

    protected void buildTypeBindings(AccessRestriction accessRestriction) {
        TypeDeclaration[] types = this.referenceContext.types;
        if (types != null) {
            TypeDeclaration[] typeDeclarationArray = types;
            int n = types.length;
            int n2 = 0;
            while (n2 < n) {
                TypeDeclaration type = typeDeclarationArray[n2];
                if (type instanceof GroovyTypeDeclaration) {
                    ((GroovyTypeDeclaration)type).fixAnonymousTypeBinding();
                }
                ++n2;
            }
        }
        super.buildTypeBindings(accessRestriction);
    }

    public ClassNode lookupClassNodeForSource(String typename, JDTResolver jdtResolver) {
        ProblemReferenceBinding prBinding;
        ClassNode node = this.typenameToClassNodeCache.get(typename);
        if (node != null) {
            return node;
        }
        char[][] compoundName = CharOperation.splitOn('.', typename.toCharArray());
        TypeBinding jdtBinding = null;
        try {
            jdtBinding = this.getType(compoundName, compoundName.length);
        }
        catch (AbortCompilation t) {
            if (t.silentException instanceof AbortIncrementalBuildException) {
                jdtBinding = null;
            }
            throw t;
        }
        if (jdtBinding != null) {
            if (jdtBinding instanceof SourceTypeBinding) {
                ClassNode classNode = jdtResolver.convertToClassNode(jdtBinding);
                if (classNode != null) {
                    this.typenameToClassNodeCache.put(typename, classNode);
                }
                return classNode;
            }
            if (jdtBinding instanceof BinaryTypeBinding) {
                ClassNode newNode = jdtResolver.convertToClassNode(jdtBinding);
                if (newNode != null) {
                    this.typenameToClassNodeCache.put(typename, newNode);
                }
                return newNode;
            }
        }
        if (jdtBinding != null && jdtBinding instanceof ProblemReferenceBinding && (prBinding = (ProblemReferenceBinding)jdtBinding).problemId() == 4) {
            jdtBinding = prBinding.closestMatch();
            if (jdtBinding != null && jdtBinding instanceof SourceTypeBinding) {
                return jdtResolver.convertToClassNode(jdtBinding);
            }
            if (jdtBinding != null && jdtBinding instanceof BinaryTypeBinding) {
                return jdtResolver.convertToClassNode(jdtBinding);
            }
        }
        return null;
    }

    public ClassNode lookupClassNodeForBinary(String typename, JDTResolver jdtResolver) {
        ProblemReferenceBinding prBinding;
        char[][] compoundName = CharOperation.splitOn('.', typename.toCharArray());
        TypeBinding jdtBinding = this.getType(compoundName, compoundName.length);
        if (jdtBinding != null && jdtBinding instanceof BinaryTypeBinding) {
            ClassNode classNode = jdtResolver.convertToClassNode(jdtBinding);
            return classNode;
        }
        if (jdtBinding != null && jdtBinding instanceof ProblemReferenceBinding && (prBinding = (ProblemReferenceBinding)jdtBinding).problemId() == 4 && (jdtBinding = prBinding.closestMatch()) != null && jdtBinding instanceof BinaryTypeBinding) {
            return jdtResolver.convertToClassNode(jdtBinding);
        }
        return null;
    }

    protected void checkPublicTypeNameMatchesFilename(TypeDeclaration typeDecl) {
    }

    protected void recordImportProblem(ImportReference importReference, Binding importBinding) {
    }

    protected boolean reportPackageIsNotExpectedPackage(CompilationUnitDeclaration compUnitDecl) {
        if (!this.isScript && compUnitDecl != null && compUnitDecl.compilationResult != null && compUnitDecl.compilationResult.compilationUnit != null) {
            String actuallyIs;
            char[][] packageName = compUnitDecl.compilationResult.compilationUnit.getPackageName();
            String shouldBe = packageName == null ? "" : CharOperation.toString(packageName);
            String string = actuallyIs = compUnitDecl.currentPackage == null ? "" : CharOperation.toString(compUnitDecl.currentPackage.tokens);
            if (actuallyIs.length() > 0 && !shouldBe.equals(actuallyIs)) {
                this.problemReporter().packageIsNotExpectedPackage(compUnitDecl);
                return true;
            }
        }
        return false;
    }

    protected void checkParameterizedTypes() {
    }

    public boolean reportInvalidType(TypeReference typeReference, TypeBinding resolvedType) {
        ProblemReferenceBinding problemRefBinding;
        return resolvedType instanceof ProblemReferenceBinding && (problemRefBinding = (ProblemReferenceBinding)resolvedType).problemId() == 3;
    }

    protected void reportImportProblem(ImportReference importReference, Binding importBinding) {
        ProblemReferenceBinding problemRefBinding;
        if (importBinding instanceof ProblemReferenceBinding && (problemRefBinding = (ProblemReferenceBinding)importBinding).problemId() == 1) {
            return;
        }
        this.problemReporter().importProblem(importReference, importBinding);
    }

    public boolean canSeeEverything() {
        return true;
    }

    public boolean checkTargetCompatibility() {
        return false;
    }

    protected boolean canBeSeenBy(ReferenceBinding type, PackageBinding fPackage) {
        return true;
    }

    public boolean scannerAvailable() {
        return false;
    }

    public void setIsScript(boolean isScript) {
        this.isScript = isScript;
    }

    public boolean isScript() {
        return this.isScript;
    }

    public ReferenceBinding selectBinding(ReferenceBinding newlyFound, ReferenceBinding originallyFound, boolean isDeclaredImport) {
        if (isDeclaredImport && originallyFound.fPackage != null) {
            char[][] packageName = originallyFound.fPackage.compoundName;
            if (CharOperation.equals(javaLang, packageName) || CharOperation.equals(javaIo, packageName) || CharOperation.equals(javaNet, packageName) || CharOperation.equals(javaUtil, packageName) || CharOperation.equals(groovyLang, packageName) || CharOperation.equals(groovyUtil, packageName)) {
                return newlyFound;
            }
            return originallyFound;
        }
        return null;
    }
}

