/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.jdt.groovy.internal.compiler.ast;

import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import org.codehaus.groovy.ast.PropertyNode;
import org.codehaus.groovy.runtime.MetaClassHelper;
import org.codehaus.jdt.groovy.internal.compiler.ast.EventListener;
import org.codehaus.jdt.groovy.internal.compiler.ast.GroovyTypeDeclaration;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.Argument;
import org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.jdt.internal.compiler.lookup.ClassScope;
import org.eclipse.jdt.internal.compiler.lookup.CompilationUnitScope;
import org.eclipse.jdt.internal.compiler.lookup.FieldBinding;
import org.eclipse.jdt.internal.compiler.lookup.LazilyResolvedMethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.MissingTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.eclipse.jdt.internal.compiler.lookup.SourceTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeConstants;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GroovyClassScope
extends ClassScope {
    public static EventListener debugListener = null;
    char[] GROOVY = "groovy".toCharArray();
    char[][] GROOVY_LANG_METACLASS = new char[][]{this.GROOVY, TypeConstants.LANG, "MetaClass".toCharArray()};
    char[][] GROOVY_LANG_GROOVYOBJECT = new char[][]{this.GROOVY, TypeConstants.LANG, "GroovyObject".toCharArray()};

    public GroovyClassScope(Scope parent, TypeDeclaration typeDecl) {
        super(parent, typeDecl);
    }

    @Override
    protected boolean connectSuperInterfaces() {
        boolean noProblems = super.connectSuperInterfaces();
        return noProblems;
    }

    public final ReferenceBinding getGroovyLangMetaClassBinding() {
        CompilationUnitScope unitScope = this.compilationUnitScope();
        unitScope.recordQualifiedReference(this.GROOVY_LANG_METACLASS);
        return unitScope.environment.getResolvedType(this.GROOVY_LANG_METACLASS, this);
    }

    @Override
    protected MethodBinding[] augmentMethodBindings(MethodBinding[] methodBindings) {
        SourceTypeBinding binding = this.referenceContext.binding;
        if (binding != null && (binding.isAnnotationType() || binding.isInterface())) {
            return methodBindings;
        }
        boolean implementsGroovyLangObject = false;
        ReferenceBinding[] superInterfaces = binding.superInterfaces;
        if (superInterfaces != null) {
            int i = 0;
            int max = superInterfaces.length;
            while (i < max) {
                char[][] interfaceName = superInterfaces[i].compoundName;
                if (CharOperation.equals(interfaceName, this.GROOVY_LANG_GROOVYOBJECT)) {
                    implementsGroovyLangObject = true;
                    break;
                }
                ++i;
            }
        }
        ArrayList<MethodBinding> groovyMethods = new ArrayList<MethodBinding>();
        if (implementsGroovyLangObject) {
            if (debugListener != null) {
                debugListener.record("augment: type " + new String(this.referenceContext.name) + " having GroovyObject methods added");
            }
            ReferenceBinding bindingJLO = this.getJavaLangObject();
            ReferenceBinding bindingJLS = this.getJavaLangString();
            ReferenceBinding bindingGLM = this.getGroovyLangMetaClassBinding();
            this.createMethod("invokeMethod", false, "", new TypeBinding[]{bindingJLS, bindingJLO}, bindingJLO, groovyMethods, methodBindings, null);
            this.createMethod("getProperty", false, "", new TypeBinding[]{bindingJLS}, bindingJLO, groovyMethods, methodBindings, null);
            this.createMethod("setProperty", false, "", new TypeBinding[]{bindingJLS, bindingJLO}, TypeBinding.VOID, groovyMethods, methodBindings, null);
            this.createMethod("getMetaClass", false, "", null, bindingGLM, groovyMethods, methodBindings, null);
            this.createMethod("setMetaClass", false, "", new TypeBinding[]{bindingGLM}, TypeBinding.VOID, groovyMethods, methodBindings, null);
        }
        if (this.referenceContext instanceof GroovyTypeDeclaration) {
            List<PropertyNode> properties;
            GroovyTypeDeclaration typeDeclaration = (GroovyTypeDeclaration)this.referenceContext;
            boolean useOldWay = false;
            if (useOldWay) {
                properties = typeDeclaration.properties;
                for (PropertyNode property : properties) {
                    String name = property.getName();
                    FieldBinding fBinding = typeDeclaration.binding.getField(name.toCharArray(), false);
                    if (fBinding == null || fBinding.type instanceof MissingTypeBinding) continue;
                    String getterName = "get" + MetaClassHelper.capitalize(name);
                    this.createMethod(getterName, property.isStatic(), "", null, fBinding.type, groovyMethods, methodBindings, typeDeclaration);
                    if (!fBinding.isFinal()) {
                        String setterName = "set" + MetaClassHelper.capitalize(name);
                        this.createMethod(setterName, property.isStatic(), "", new TypeBinding[]{fBinding.type}, TypeBinding.VOID, groovyMethods, methodBindings, typeDeclaration);
                    }
                    if (fBinding.type != TypeBinding.BOOLEAN) continue;
                    this.createMethod("is" + MetaClassHelper.capitalize(name), property.isStatic(), "", null, fBinding.type, groovyMethods, methodBindings, typeDeclaration);
                }
            } else {
                properties = typeDeclaration.properties;
                for (PropertyNode property : properties) {
                    String propertyType;
                    String name = property.getName();
                    String capitalizedName = MetaClassHelper.capitalize(name);
                    this.createGetterMethod(name, "get" + capitalizedName, property.isStatic(), groovyMethods, methodBindings, typeDeclaration);
                    if (!Modifier.isFinal(property.getModifiers())) {
                        this.createSetterMethod(name, "set" + capitalizedName, property.isStatic(), groovyMethods, methodBindings, typeDeclaration, property.getType().getName());
                    }
                    if (!(propertyType = property.getType().getName()).equals("boolean")) continue;
                    this.createGetterMethod(name, "is" + capitalizedName, property.isStatic(), groovyMethods, methodBindings, typeDeclaration);
                }
            }
        }
        MethodBinding[] newMethodBindings = groovyMethods.toArray(new MethodBinding[methodBindings.length + groovyMethods.size()]);
        System.arraycopy(methodBindings, 0, newMethodBindings, groovyMethods.size(), methodBindings.length);
        return newMethodBindings;
    }

    private void createMethod(String name, boolean isStatic, String signature, TypeBinding[] parameterTypes, TypeBinding returnType, List<MethodBinding> groovyMethods, MethodBinding[] existingMethods, GroovyTypeDeclaration typeDeclaration) {
        boolean found = false;
        MethodBinding[] methodBindingArray = existingMethods;
        int n = existingMethods.length;
        int n2 = 0;
        while (n2 < n) {
            MethodBinding existingMethod = methodBindingArray[n2];
            if (new String(existingMethod.selector).equals(name)) {
                ((SourceTypeBinding)existingMethod.declaringClass).resolveTypesFor(existingMethod);
                boolean equalParameters = true;
                if (parameterTypes == null) {
                    if (existingMethod.parameters.length != 0) {
                        equalParameters = false;
                    }
                } else if (existingMethod.parameters.length == parameterTypes.length) {
                    TypeBinding[] existingParams = existingMethod.parameters;
                    int p = 0;
                    int max = parameterTypes.length;
                    while (p < max) {
                        if (!CharOperation.equals(parameterTypes[p].signature(), existingParams[p].signature())) {
                            equalParameters = false;
                            break;
                        }
                        ++p;
                    }
                }
                if (equalParameters) {
                    found = true;
                    break;
                }
            }
            ++n2;
        }
        if (!found) {
            int modifiers = 1;
            if (isStatic) {
                modifiers |= 8;
            }
            if (this.referenceContext.binding.isInterface()) {
                modifiers |= 0x400;
            }
            char[] methodName = name.toCharArray();
            MethodBinding mb = new MethodBinding(modifiers, methodName, returnType, parameterTypes, null, this.referenceContext.binding);
            groovyMethods.add(mb);
        }
    }

    private void createGetterMethod(String propertyName, String name, boolean isStatic, List<MethodBinding> groovyMethods, MethodBinding[] existingMethods, GroovyTypeDeclaration typeDeclaration) {
        boolean found = false;
        char[] nameAsCharArray = name.toCharArray();
        MethodBinding[] methodBindingArray = existingMethods;
        int n = existingMethods.length;
        int n2 = 0;
        while (n2 < n) {
            MethodBinding existingMethod = methodBindingArray[n2];
            if (CharOperation.equals(nameAsCharArray, existingMethod.selector)) {
                if ((existingMethod.modifiers & 0x2000000) != 0) {
                    Argument[] arguments;
                    AbstractMethodDeclaration methodDecl = existingMethod.sourceMethod();
                    if (methodDecl != null && ((arguments = methodDecl.arguments) == null || arguments.length == 0)) {
                        found = true;
                    }
                } else {
                    TypeBinding[] existingParams = existingMethod.parameters;
                    if (existingParams == null || existingParams.length == 0) {
                        found = true;
                    }
                }
            }
            ++n2;
        }
        if (!found) {
            int modifiers = 1;
            if (isStatic) {
                modifiers |= 8;
            }
            if (this.referenceContext.binding.isInterface()) {
                modifiers |= 0x400;
            }
            LazilyResolvedMethodBinding mb = new LazilyResolvedMethodBinding(true, propertyName, modifiers, nameAsCharArray, null, (ReferenceBinding)this.referenceContext.binding);
            groovyMethods.add(mb);
        }
    }

    private void createSetterMethod(String propertyName, String name, boolean isStatic, List<MethodBinding> groovyMethods, MethodBinding[] existingMethods, GroovyTypeDeclaration typeDeclaration, String propertyType) {
        boolean found = false;
        char[] nameAsCharArray = name.toCharArray();
        MethodBinding[] methodBindingArray = existingMethods;
        int n = existingMethods.length;
        int n2 = 0;
        while (n2 < n) {
            MethodBinding existingMethod = methodBindingArray[n2];
            if (CharOperation.equals(nameAsCharArray, existingMethod.selector)) {
                if ((existingMethod.modifiers & 0x2000000) != 0) {
                    Argument[] arguments;
                    AbstractMethodDeclaration methodDecl = existingMethod.sourceMethod();
                    if (methodDecl != null && (arguments = methodDecl.arguments) != null && arguments.length == 1) {
                        found = true;
                    }
                } else {
                    TypeBinding[] existingParams = existingMethod.parameters;
                    if (existingParams != null && existingParams.length == 1) {
                        found = true;
                    }
                }
            }
            ++n2;
        }
        if (!found) {
            int modifiers = 1;
            if (isStatic) {
                modifiers |= 8;
            }
            if (this.referenceContext.binding.isInterface()) {
                modifiers |= 0x400;
            }
            char[] methodName = name.toCharArray();
            LazilyResolvedMethodBinding mb = new LazilyResolvedMethodBinding(false, propertyName, modifiers, methodName, null, (ReferenceBinding)this.referenceContext.binding);
            groovyMethods.add(mb);
        }
    }

    @Override
    public boolean shouldReport(int problem) {
        if (problem == 16777528) {
            return false;
        }
        if (problem == 67109268) {
            return false;
        }
        if (problem == 67109264) {
            return false;
        }
        if (problem == 67109424) {
            return false;
        }
        return problem != 67109667;
    }

    @Override
    public MethodBinding[] getAnyExtraMethods(char[] selector) {
        return null;
    }

    @Override
    protected ClassScope buildClassScope(Scope parent, TypeDeclaration typeDecl) {
        return new GroovyClassScope(parent, typeDecl);
    }
}

