/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.jdt.groovy.integration.internal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import org.codehaus.groovy.control.CompilerConfiguration;
import org.codehaus.groovy.control.ErrorCollector;
import org.codehaus.groovy.control.SourceUnit;
import org.codehaus.jdt.groovy.integration.EventHandler;
import org.codehaus.jdt.groovy.integration.LanguageSupport;
import org.codehaus.jdt.groovy.integration.internal.GroovyEventHandler;
import org.codehaus.jdt.groovy.integration.internal.ISearchScopeExpander;
import org.codehaus.jdt.groovy.integration.internal.MultiplexingCommentRecorderParser;
import org.codehaus.jdt.groovy.integration.internal.MultiplexingImportMatchLocatorParser;
import org.codehaus.jdt.groovy.integration.internal.MultiplexingIndexingParser;
import org.codehaus.jdt.groovy.integration.internal.MultiplexingMatchLocatorParser;
import org.codehaus.jdt.groovy.integration.internal.MultiplexingParser;
import org.codehaus.jdt.groovy.integration.internal.MultiplexingSourceElementRequestorParser;
import org.codehaus.jdt.groovy.internal.compiler.ast.GroovyCompilationUnitDeclaration;
import org.codehaus.jdt.groovy.internal.compiler.ast.GroovyErrorCollectorForJDT;
import org.codehaus.jdt.groovy.internal.compiler.ast.GroovyTypeDeclaration;
import org.codehaus.jdt.groovy.internal.compiler.ast.JDTResolver;
import org.codehaus.jdt.groovy.model.GroovyCompilationUnit;
import org.codehaus.jdt.groovy.model.GroovyNature;
import org.eclipse.core.resources.IProject;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.WorkingCopyOwner;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchPattern;
import org.eclipse.jdt.core.search.SearchRequestor;
import org.eclipse.jdt.groovy.core.util.ContentTypeUtils;
import org.eclipse.jdt.groovy.core.util.GroovyUtils;
import org.eclipse.jdt.groovy.core.util.ReflectionUtils;
import org.eclipse.jdt.groovy.search.ITypeRequestor;
import org.eclipse.jdt.groovy.search.TypeInferencingVisitorFactory;
import org.eclipse.jdt.groovy.search.TypeInferencingVisitorWithRequestor;
import org.eclipse.jdt.groovy.search.TypeRequestorFactory;
import org.eclipse.jdt.internal.compiler.CompilationResult;
import org.eclipse.jdt.internal.compiler.DefaultErrorHandlingPolicies;
import org.eclipse.jdt.internal.compiler.IProblemFactory;
import org.eclipse.jdt.internal.compiler.ISourceElementRequestor;
import org.eclipse.jdt.internal.compiler.SourceElementParser;
import org.eclipse.jdt.internal.compiler.ast.CompilationUnitDeclaration;
import org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.jdt.internal.compiler.env.ICompilationUnit;
import org.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.jdt.internal.compiler.parser.Parser;
import org.eclipse.jdt.internal.compiler.problem.DefaultProblemFactory;
import org.eclipse.jdt.internal.compiler.problem.ProblemReporter;
import org.eclipse.jdt.internal.core.BinaryMember;
import org.eclipse.jdt.internal.core.BinaryType;
import org.eclipse.jdt.internal.core.ClassFile;
import org.eclipse.jdt.internal.core.CompilationUnit;
import org.eclipse.jdt.internal.core.JavaElement;
import org.eclipse.jdt.internal.core.JavaModelManager;
import org.eclipse.jdt.internal.core.PackageFragment;
import org.eclipse.jdt.internal.core.search.indexing.IndexingParser;
import org.eclipse.jdt.internal.core.search.matching.ImportMatchLocatorParser;
import org.eclipse.jdt.internal.core.search.matching.MatchLocator;
import org.eclipse.jdt.internal.core.search.matching.MatchLocatorParser;
import org.eclipse.jdt.internal.core.search.matching.PossibleMatch;
import org.eclipse.jdt.internal.core.util.Util;

public class GroovyLanguageSupport
implements LanguageSupport {
    public static ISearchScopeExpander searchScopeExpander;

    public Parser getParser(Object requestor, CompilerOptions compilerOptions, ProblemReporter problemReporter, boolean parseLiteralExpressionsAsConstants, int variant) {
        if (variant == 1) {
            return new MultiplexingParser(requestor, compilerOptions, problemReporter, parseLiteralExpressionsAsConstants);
        }
        if (variant == 2) {
            return new MultiplexingCommentRecorderParser(requestor, compilerOptions, problemReporter, parseLiteralExpressionsAsConstants);
        }
        return new MultiplexingCommentRecorderParser(requestor, compilerOptions, problemReporter, parseLiteralExpressionsAsConstants, false);
    }

    public IndexingParser getIndexingParser(ISourceElementRequestor requestor, IProblemFactory problemFactory, CompilerOptions options, boolean reportLocalDeclarations, boolean optimizeStringLiterals, boolean useSourceJavadocParser) {
        return new MultiplexingIndexingParser(requestor, problemFactory, options, reportLocalDeclarations, optimizeStringLiterals, useSourceJavadocParser);
    }

    public MatchLocatorParser getMatchLocatorParserParser(ProblemReporter problemReporter, MatchLocator locator) {
        return new MultiplexingMatchLocatorParser(problemReporter, locator);
    }

    public ImportMatchLocatorParser getImportMatchLocatorParserParser(ProblemReporter problemReporter, MatchLocator locator) {
        return new MultiplexingImportMatchLocatorParser(problemReporter, locator);
    }

    public SourceElementParser getSourceElementParser(ISourceElementRequestor requestor, IProblemFactory problemFactory, CompilerOptions options, boolean reportLocalDeclarations, boolean optimizeStringLiterals, boolean useSourceJavadocParser) {
        ProblemReporter problemReporter = new ProblemReporter(DefaultErrorHandlingPolicies.proceedWithAllProblems(), options, new DefaultProblemFactory());
        return new MultiplexingSourceElementRequestorParser(problemReporter, requestor, problemFactory, options, reportLocalDeclarations, optimizeStringLiterals);
    }

    public CompilationUnit newCompilationUnit(PackageFragment parent, String name, WorkingCopyOwner owner) {
        if (ContentTypeUtils.isGroovyLikeFileName(name)) {
            return new GroovyCompilationUnit(parent, name, owner);
        }
        return new CompilationUnit(parent, name, owner);
    }

    public CompilationUnitDeclaration newCompilationUnitDeclaration(ICompilationUnit unit, ProblemReporter problemReporter, CompilationResult compilationResult, int sourceLength) {
        if (ContentTypeUtils.isGroovyLikeFileName(compilationResult.getFileName())) {
            CompilerConfiguration groovyCompilerConfig = new CompilerConfiguration();
            GroovyErrorCollectorForJDT errorCollector = new GroovyErrorCollectorForJDT(groovyCompilerConfig);
            SourceUnit groovySourceUnit = new SourceUnit(new String(compilationResult.getFileName()), new String(unit.getContents()), groovyCompilerConfig, null, (ErrorCollector)errorCollector);
            org.codehaus.groovy.control.CompilationUnit groovyCU = new org.codehaus.groovy.control.CompilationUnit(groovyCompilerConfig);
            JDTResolver resolver = new JDTResolver(groovyCU);
            groovyCU.setResolveVisitor(resolver);
            compilationResult.lineSeparatorPositions = GroovyUtils.getSourceLineSeparatorsIn(unit.getContents());
            groovyCU.addSource(groovySourceUnit);
            GroovyCompilationUnitDeclaration gcuDeclaration = new GroovyCompilationUnitDeclaration(problemReporter, compilationResult, sourceLength, groovyCU, groovySourceUnit, null);
            gcuDeclaration.processToPhase(3);
            if (gcuDeclaration.getModuleNode() != null) {
                gcuDeclaration.populateCompilationUnitDeclaration();
                TypeDeclaration[] typeDeclarationArray = gcuDeclaration.types;
                int n = gcuDeclaration.types.length;
                int n2 = 0;
                while (n2 < n) {
                    TypeDeclaration decl = typeDeclarationArray[n2];
                    GroovyTypeDeclaration gtDeclaration = (GroovyTypeDeclaration)decl;
                    resolver.record(gtDeclaration);
                    ++n2;
                }
            }
            return gcuDeclaration;
        }
        return new CompilationUnitDeclaration(problemReporter, compilationResult, sourceLength);
    }

    public boolean isInterestingProject(IProject project) {
        return GroovyNature.hasGroovyNature(project);
    }

    public boolean isSourceFile(String fileName, boolean isInterestingProject) {
        if (isInterestingProject) {
            return Util.isJavaLikeFileName(fileName);
        }
        return ContentTypeUtils.isJavaLikeButNotGroovyLikeExtension(fileName);
    }

    public boolean isInterestingSourceFile(String fileName) {
        return ContentTypeUtils.isGroovyLikeFileName(fileName);
    }

    public boolean maybePerformDelegatedSearch(PossibleMatch possibleMatch, SearchPattern pattern, SearchRequestor requestor) {
        ITypeRequestor typeRequestor;
        if (possibleMatch.openable != null && possibleMatch.openable.exists() && (typeRequestor = new TypeRequestorFactory().createRequestor(possibleMatch, pattern, requestor)) != null) {
            TypeInferencingVisitorWithRequestor visitor = new TypeInferencingVisitorFactory().createVisitor(possibleMatch);
            visitor.visitCompilationUnit(typeRequestor);
            return true;
        }
        return false;
    }

    public EventHandler getEventHandler() {
        return new GroovyEventHandler();
    }

    public void filterNonSourceMembers(BinaryType binaryType) {
        try {
            IJavaElement[] childrenArr = binaryType.getChildren();
            ArrayList<IJavaElement> children = new ArrayList<IJavaElement>(Arrays.asList(childrenArr));
            LinkedList<BinaryMember> removedChildren = new LinkedList<BinaryMember>();
            Iterator childIter = children.iterator();
            while (childIter.hasNext()) {
                BinaryMember binaryChild;
                ISourceRange iSourceRange;
                IJavaElement child = (IJavaElement)childIter.next();
                if (!(child instanceof BinaryMember) || (iSourceRange = (binaryChild = (BinaryMember)child).getSourceRange()) != null && iSourceRange.getOffset() != -1) continue;
                removedChildren.add(binaryChild);
                childIter.remove();
            }
            JavaElement[] newChildrenArr = children.toArray(new JavaElement[children.size()]);
            Object classFileInfo = ((ClassFile)binaryType.getParent()).getElementInfo();
            ReflectionUtils.setPrivateField(classFileInfo.getClass(), "binaryChildren", classFileInfo, newChildrenArr);
            JavaModelManager manager = JavaModelManager.getJavaModelManager();
            for (JavaElement javaElement : removedChildren) {
                if (javaElement instanceof BinaryType) {
                    manager.removeInfoAndChildren((JavaElement)javaElement.getParent());
                    continue;
                }
                manager.removeInfoAndChildren(javaElement);
            }
        }
        catch (JavaModelException e) {
            e.printStackTrace();
        }
    }

    public IJavaSearchScope expandSearchScope(IJavaSearchScope scope, SearchPattern pattern, SearchRequestor requestor) {
        if (searchScopeExpander != null) {
            return searchScopeExpander.expandSearchScope(scope, pattern, requestor);
        }
        return scope;
    }
}

