/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.transform.sc.transformers;

import java.util.Iterator;
import java.util.List;
import org.codehaus.groovy.ast.AnnotatedNode;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.expr.ArgumentListExpression;
import org.codehaus.groovy.ast.expr.BinaryExpression;
import org.codehaus.groovy.ast.expr.BooleanExpression;
import org.codehaus.groovy.ast.expr.ClassExpression;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.ast.expr.DeclarationExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.ListExpression;
import org.codehaus.groovy.ast.expr.MethodCallExpression;
import org.codehaus.groovy.ast.expr.TernaryExpression;
import org.codehaus.groovy.ast.expr.TupleExpression;
import org.codehaus.groovy.classgen.asm.sc.StaticTypesTypeChooser;
import org.codehaus.groovy.syntax.Token;
import org.codehaus.groovy.transform.sc.ListOfExpressionsExpression;
import org.codehaus.groovy.transform.sc.StaticCompilationMetadataKeys;
import org.codehaus.groovy.transform.sc.transformers.CompareIdentityExpression;
import org.codehaus.groovy.transform.sc.transformers.CompareToNullExpression;
import org.codehaus.groovy.transform.sc.transformers.StaticCompilationTransformer;
import org.codehaus.groovy.transform.stc.StaticTypeCheckingSupport;
import org.codehaus.groovy.transform.stc.StaticTypesMarker;

public class BinaryExpressionTransformer {
    private static final MethodNode COMPARE_TO_METHOD = ClassHelper.COMPARABLE_TYPE.getMethods("compareTo").get(0);
    private static final ConstantExpression CONSTANT_ZERO = new ConstantExpression(0, true);
    private static final ConstantExpression CONSTANT_MINUS_ONE = new ConstantExpression(-1, true);
    private static final ConstantExpression CONSTANT_ONE = new ConstantExpression(1, true);
    private final StaticCompilationTransformer staticCompilationTransformer;

    static {
        CONSTANT_ZERO.setType(ClassHelper.int_TYPE);
        CONSTANT_ONE.setType(ClassHelper.int_TYPE);
        CONSTANT_MINUS_ONE.setType(ClassHelper.int_TYPE);
    }

    public BinaryExpressionTransformer(StaticCompilationTransformer staticCompilationTransformer) {
        this.staticCompilationTransformer = staticCompilationTransformer;
    }

    Expression transformBinaryExpression(BinaryExpression bin) {
        Object[] list = (Object[])bin.getNodeMetaData((Object)StaticCompilationMetadataKeys.BINARY_EXP_TARGET);
        Token operation = bin.getOperation();
        int operationType = operation.getType();
        if (operationType == 123 || operationType == 120) {
            AnnotatedNode compareToNullExpression = null;
            if (BinaryExpressionTransformer.isNullConstant(bin.getLeftExpression())) {
                compareToNullExpression = new CompareToNullExpression(this.staticCompilationTransformer.transform(bin.getRightExpression()), operationType == 123);
            } else if (BinaryExpressionTransformer.isNullConstant(bin.getRightExpression())) {
                compareToNullExpression = new CompareToNullExpression(this.staticCompilationTransformer.transform(bin.getLeftExpression()), operationType == 123);
            }
            if (compareToNullExpression != null) {
                compareToNullExpression.setSourcePosition(bin);
                return compareToNullExpression;
            }
        }
        if (list != null) {
            if (operationType == 128) {
                ClassNode rightType;
                StaticTypesTypeChooser typeChooser = this.staticCompilationTransformer.getTypeChooser();
                ClassNode classNode = this.staticCompilationTransformer.getClassNode();
                ClassNode leftType = typeChooser.resolveType(bin.getLeftExpression(), classNode);
                if (leftType.implementsInterface(ClassHelper.COMPARABLE_TYPE) && (rightType = typeChooser.resolveType(bin.getRightExpression(), classNode)).implementsInterface(ClassHelper.COMPARABLE_TYPE)) {
                    Expression left = this.staticCompilationTransformer.transform(bin.getLeftExpression());
                    Expression right = this.staticCompilationTransformer.transform(bin.getRightExpression());
                    MethodCallExpression call = new MethodCallExpression(left, "compareTo", (Expression)new ArgumentListExpression(right));
                    call.setImplicitThis(false);
                    call.setMethodTarget(COMPARE_TO_METHOD);
                    CompareIdentityExpression compareIdentity = new CompareIdentityExpression(left, right);
                    compareIdentity.setSourcePosition(bin);
                    compareIdentity.putNodeMetaData((Object)StaticTypesMarker.INFERRED_RETURN_TYPE, ClassHelper.boolean_TYPE);
                    TernaryExpression result = new TernaryExpression(new BooleanExpression(compareIdentity), CONSTANT_ZERO, new TernaryExpression(new BooleanExpression(new CompareToNullExpression(left, true)), CONSTANT_MINUS_ONE, new TernaryExpression(new BooleanExpression(new CompareToNullExpression(right, true)), CONSTANT_ONE, call)));
                    compareIdentity.putNodeMetaData((Object)StaticTypesMarker.INFERRED_RETURN_TYPE, ClassHelper.int_TYPE);
                    result.putNodeMetaData((Object)StaticTypesMarker.INFERRED_TYPE, ClassHelper.int_TYPE);
                    TernaryExpression expr = (TernaryExpression)result.getFalseExpression();
                    expr.putNodeMetaData((Object)StaticTypesMarker.INFERRED_TYPE, ClassHelper.int_TYPE);
                    expr.getFalseExpression().putNodeMetaData((Object)StaticTypesMarker.INFERRED_TYPE, ClassHelper.int_TYPE);
                    return result;
                }
            }
            boolean isAssignment = StaticTypeCheckingSupport.isAssignment(operationType);
            MethodNode node = (MethodNode)list[0];
            String name = (String)list[1];
            Expression left = this.staticCompilationTransformer.transform(bin.getLeftExpression());
            Expression right = this.staticCompilationTransformer.transform(bin.getRightExpression());
            MethodCallExpression call = new MethodCallExpression(left, name, (Expression)new ArgumentListExpression(right));
            call.setImplicitThis(false);
            call.setMethodTarget(node);
            MethodNode adapter = StaticCompilationTransformer.BYTECODE_BINARY_ADAPTERS.get(operationType);
            if (adapter != null) {
                ClassExpression sba = new ClassExpression(StaticCompilationTransformer.BYTECODE_ADAPTER_CLASS);
                call = new MethodCallExpression((Expression)sba, "compareEquals", (Expression)new ArgumentListExpression(left, right));
                call.setMethodTarget(adapter);
                call.setImplicitThis(false);
            }
            if (!isAssignment) {
                return call;
            }
            return new BinaryExpression(left, Token.newSymbol("=", operation.getStartLine(), operation.getStartColumn()), call);
        }
        if (bin.getOperation().getType() == 100 && bin.getLeftExpression() instanceof TupleExpression && bin.getRightExpression() instanceof ListExpression) {
            ListOfExpressionsExpression cle = new ListOfExpressionsExpression();
            boolean isDeclaration = bin instanceof DeclarationExpression;
            List<Expression> leftExpressions = ((TupleExpression)bin.getLeftExpression()).getExpressions();
            List<Expression> rightExpressions = ((ListExpression)bin.getRightExpression()).getExpressions();
            Iterator<Expression> leftIt = leftExpressions.iterator();
            Iterator<Expression> rightIt = rightExpressions.iterator();
            while (leftIt.hasNext()) {
                Expression left = leftIt.next();
                if (!rightIt.hasNext()) continue;
                Expression right = rightIt.next();
                BinaryExpression bexp = isDeclaration ? new DeclarationExpression(left, bin.getOperation(), right) : new BinaryExpression(left, bin.getOperation(), right);
                bexp.setSourcePosition(right);
                cle.addExpression(bexp);
            }
            return this.staticCompilationTransformer.transform(cle);
        }
        return this.staticCompilationTransformer.superTransform(bin);
    }

    protected static boolean isNullConstant(Expression expression) {
        return expression instanceof ConstantExpression && ((ConstantExpression)expression).getValue() == null;
    }
}

