/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.groovy.search;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.ast.expr.FieldExpression;
import org.codehaus.groovy.ast.expr.StaticMethodCallExpression;
import org.codehaus.groovy.ast.expr.VariableExpression;
import org.codehaus.jdt.groovy.internal.compiler.ast.GroovyTypeDeclaration;
import org.codehaus.jdt.groovy.internal.compiler.ast.JDTClassNode;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.core.search.MethodDeclarationMatch;
import org.eclipse.jdt.core.search.MethodReferenceMatch;
import org.eclipse.jdt.core.search.SearchMatch;
import org.eclipse.jdt.core.search.SearchParticipant;
import org.eclipse.jdt.core.search.SearchRequestor;
import org.eclipse.jdt.groovy.core.util.ReflectionUtils;
import org.eclipse.jdt.groovy.search.ITypeRequestor;
import org.eclipse.jdt.groovy.search.TypeLookupResult;
import org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.SourceTypeBinding;
import org.eclipse.jdt.internal.core.search.matching.MethodPattern;
import org.eclipse.jdt.internal.core.util.Util;
import org.eclipse.jface.text.Position;

public class MethodReferenceSearchRequestor
implements ITypeRequestor {
    private static final int MAX_PARAMS = 10;
    private final SearchRequestor requestor;
    private final SearchParticipant participant;
    private final char[] name;
    private final String declaringQualifiedName;
    private final boolean findDeclarations;
    private final boolean findReferences;
    private char[][] parameterQualifications;
    private char[][] parameterSimpleNames;
    private final int declaredParameterCount;
    private final Set<Position> acceptedPositions = new HashSet<Position>();
    private Map<ClassNode, Boolean> cachedDeclaringNameMatches = new HashMap<ClassNode, Boolean>();
    private Map<ClassNode, boolean[]> cachedParameterCounts = new HashMap<ClassNode, boolean[]>();

    public MethodReferenceSearchRequestor(MethodPattern pattern, SearchRequestor requestor, SearchParticipant participant) {
        this.requestor = requestor;
        this.participant = participant;
        this.name = (char[])ReflectionUtils.getPrivateField(MethodPattern.class, "selector", pattern);
        char[] arr = (char[])ReflectionUtils.getPrivateField(MethodPattern.class, "declaringSimpleName", pattern);
        String declaringSimpleName = arr == null ? "" : new String(arr);
        arr = (char[])ReflectionUtils.getPrivateField(MethodPattern.class, "declaringQualification", pattern);
        String declaringQualification = arr == null || arr.length == 0 ? "" : String.valueOf(new String(arr)) + ".";
        this.declaringQualifiedName = String.valueOf(declaringQualification) + declaringSimpleName;
        this.findDeclarations = (Boolean)ReflectionUtils.getPrivateField(MethodPattern.class, "findDeclarations", pattern);
        this.findReferences = (Boolean)ReflectionUtils.getPrivateField(MethodPattern.class, "findReferences", pattern);
        this.parameterQualifications = pattern.parameterQualifications;
        this.parameterSimpleNames = pattern.parameterSimpleNames;
        this.declaredParameterCount = pattern.parameterSimpleNames == null ? 0 : pattern.parameterSimpleNames.length;
    }

    public ITypeRequestor.VisitStatus acceptASTNode(ASTNode node, TypeLookupResult result, IJavaElement enclosingElement) {
        Position position;
        StaticMethodCallExpression smnode;
        boolean doCheck = false;
        boolean isDeclaration = false;
        boolean isConstructorCall = false;
        int start = 0;
        int end = 0;
        if (result.declaringType == null) {
            return ITypeRequestor.VisitStatus.CONTINUE;
        }
        if (node instanceof ConstantExpression) {
            String cName = ((ConstantExpression)node).getText();
            if (cName != null && CharOperation.equals(this.name, cName.toCharArray())) {
                start = node.getStart();
                end = node.getEnd();
                doCheck = end > 0;
            }
        } else if (node instanceof FieldExpression) {
            if (CharOperation.equals(this.name, ((FieldExpression)node).getFieldName().toCharArray())) {
                start = node.getStart();
                end = node.getEnd();
                doCheck = end > 0;
            }
        } else if (node instanceof MethodNode) {
            MethodNode mnode = (MethodNode)node;
            if (CharOperation.equals(this.name, mnode.getName().toCharArray())) {
                isDeclaration = true;
                start = mnode.getNameStart();
                end = mnode.getNameEnd() + 1;
                doCheck = true;
            }
        } else if (node instanceof VariableExpression) {
            VariableExpression vnode = (VariableExpression)node;
            if (CharOperation.equals(this.name, vnode.getName().toCharArray())) {
                start = vnode.getStart();
                end = start + vnode.getName().length();
                doCheck = true;
            }
        } else if (node instanceof StaticMethodCallExpression && CharOperation.equals(this.name, (smnode = (StaticMethodCallExpression)node).getMethod().toCharArray())) {
            start = smnode.getStart();
            end = start + this.name.length;
            doCheck = true;
        }
        if (doCheck && end > 0 && !this.acceptedPositions.contains(position = new Position(start, end - start))) {
            int numberOfParameters = this.findNumberOfParameters(node, result);
            boolean isCompleteMatch = this.nameAndArgsMatch(this.removeArray(result.declaringType), numberOfParameters);
            if (isCompleteMatch) {
                SearchMatch match = null;
                if (isDeclaration && this.findDeclarations) {
                    match = new MethodDeclarationMatch(enclosingElement, this.getAccuracy(result.confidence, isCompleteMatch), start, end - start, this.participant, enclosingElement.getResource());
                } else if (!isDeclaration && this.findReferences) {
                    match = new MethodReferenceMatch(enclosingElement, this.getAccuracy(result.confidence, isCompleteMatch), start, end - start, isConstructorCall, false, false, false, this.participant, enclosingElement.getResource());
                }
                if (match != null) {
                    try {
                        this.requestor.acceptSearchMatch(match);
                        this.acceptedPositions.add(position);
                    }
                    catch (CoreException e) {
                        Util.log(e, "Error reporting search match inside of " + enclosingElement + " in resource " + enclosingElement.getResource());
                    }
                }
            }
        }
        return ITypeRequestor.VisitStatus.CONTINUE;
    }

    private int findNumberOfParameters(ASTNode node, TypeLookupResult result) {
        return node instanceof MethodNode && ((MethodNode)node).getParameters() != null ? ((MethodNode)node).getParameters().length : Math.max(0, result.scope.getMethodCallNumberOfArguments());
    }

    private boolean nameAndArgsMatch(ClassNode declaringType, int currentCallCount) {
        return this.matchOnName(declaringType) && this.matchOnNumberOfParameters(declaringType, currentCallCount);
    }

    private boolean matchOnName(ClassNode declaringType) {
        if (declaringType == null || declaringType.getName().equals("java.lang.Object") && declaringType.getDeclaredMethods(String.valueOf(this.name)).size() == 0) {
            return false;
        }
        if (this.declaringQualifiedName == null || this.declaringQualifiedName.equals("")) {
            return true;
        }
        Boolean maybeMatch = this.cachedDeclaringNameMatches.get(declaringType);
        if (maybeMatch != null) {
            return maybeMatch;
        }
        if (declaringType.getName().equals(this.declaringQualifiedName)) {
            this.cachedDeclaringNameMatches.put(declaringType, true);
            return true;
        }
        maybeMatch = this.matchOnName(declaringType.getSuperClass());
        if (!maybeMatch.booleanValue()) {
            ClassNode[] classNodeArray = declaringType.getInterfaces();
            int n = classNodeArray.length;
            int n2 = 0;
            while (n2 < n) {
                ClassNode iface = classNodeArray[n2];
                maybeMatch = this.matchOnName(iface);
                if (maybeMatch.booleanValue()) break;
                ++n2;
            }
        }
        this.cachedDeclaringNameMatches.put(declaringType, maybeMatch);
        return maybeMatch;
    }

    private boolean matchOnNumberOfParameters(ClassNode declaringType, int currentCallCount) {
        boolean methodParamNumberMatch;
        if (currentCallCount == this.declaredParameterCount) {
            methodParamNumberMatch = true;
        } else {
            boolean[] foundParameterNumbers = this.cachedParameterCounts.get(declaringType);
            if (foundParameterNumbers == null) {
                foundParameterNumbers = new boolean[11];
                this.gatherParameters(declaringType, foundParameterNumbers);
                this.cachedParameterCounts.put(declaringType, foundParameterNumbers);
            }
            methodParamNumberMatch = !foundParameterNumbers[Math.min(10, currentCallCount)];
        }
        return methodParamNumberMatch;
    }

    private void gatherParameters(ClassNode declaringType, boolean[] foundParameterNumbers) {
        if (declaringType == null) {
            return;
        }
        declaringType = this.findWrappedNode(declaringType.redirect());
        List<MethodNode> methods = declaringType.getMethods(String.valueOf(this.name));
        for (MethodNode method : methods) {
            method = method.getOriginal();
            foundParameterNumbers[Math.min((int)method.getParameters().length, (int)10)] = true;
        }
        this.gatherParameters(declaringType.getSuperClass(), foundParameterNumbers);
        ClassNode[] classNodeArray = declaringType.getInterfaces();
        int n = classNodeArray.length;
        int n2 = 0;
        while (n2 < n) {
            ClassNode iface = classNodeArray[n2];
            this.gatherParameters(iface, foundParameterNumbers);
            ++n2;
        }
    }

    private ClassNode findWrappedNode(ClassNode declaringType) {
        ReferenceBinding binding;
        ClassNode wrappedNode = null;
        if (declaringType instanceof JDTClassNode && (binding = ((JDTClassNode)declaringType).getJdtBinding()) instanceof SourceTypeBinding) {
            TypeDeclaration typeDeclaration;
            SourceTypeBinding sourceTypeBinding = (SourceTypeBinding)binding;
            if (sourceTypeBinding.scope != null && (typeDeclaration = sourceTypeBinding.scope.referenceContext) instanceof GroovyTypeDeclaration) {
                GroovyTypeDeclaration groovyTypeDeclaration = (GroovyTypeDeclaration)typeDeclaration;
                wrappedNode = groovyTypeDeclaration.getClassNode();
            }
        }
        return wrappedNode == null ? declaringType : wrappedNode;
    }

    private int getAccuracy(TypeLookupResult.TypeConfidence confidence, boolean isCompleteMatch) {
        if (this.shouldAlwaysBeAccurate()) {
            return 0;
        }
        if (!isCompleteMatch) {
            return 1;
        }
        switch (confidence) {
            case EXACT: {
                return 0;
            }
        }
        return 1;
    }

    private boolean shouldAlwaysBeAccurate() {
        return this.requestor.getClass().getPackage().getName().indexOf("refactoring") != -1;
    }

    private ClassNode removeArray(ClassNode declaration) {
        return declaration.getComponentType() != null ? this.removeArray(declaration.getComponentType()) : declaration;
    }
}

