/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.flow;

import org.eclipse.jdt.internal.compiler.ast.IfStatement;
import org.eclipse.jdt.internal.compiler.flow.ConditionalFlowInfo;
import org.eclipse.jdt.internal.compiler.flow.UnconditionalFlowInfo;
import org.eclipse.jdt.internal.compiler.lookup.FieldBinding;
import org.eclipse.jdt.internal.compiler.lookup.LocalVariableBinding;
import org.eclipse.jdt.internal.compiler.lookup.VariableBinding;

public abstract class FlowInfo {
    public int tagBits;
    public static final int REACHABLE = 0;
    public static final int UNREACHABLE_OR_DEAD = 1;
    public static final int UNREACHABLE_BY_NULLANALYSIS = 2;
    public static final int UNREACHABLE = 3;
    public static final int NULL_FLAG_MASK = 4;
    public static final int UNKNOWN = 1;
    public static final int NULL = 2;
    public static final int NON_NULL = 4;
    public static final int POTENTIALLY_UNKNOWN = 8;
    public static final int POTENTIALLY_NULL = 16;
    public static final int POTENTIALLY_NON_NULL = 32;
    public static final UnconditionalFlowInfo DEAD_END = new UnconditionalFlowInfo();

    static {
        FlowInfo.DEAD_END.tagBits = 3;
    }

    public abstract FlowInfo addInitializationsFrom(FlowInfo var1);

    public abstract FlowInfo addNullInfoFrom(FlowInfo var1);

    public abstract FlowInfo addPotentialInitializationsFrom(FlowInfo var1);

    public FlowInfo asNegatedCondition() {
        return this;
    }

    public static FlowInfo conditional(FlowInfo initsWhenTrue, FlowInfo initsWhenFalse) {
        if (initsWhenTrue == initsWhenFalse) {
            return initsWhenTrue;
        }
        return new ConditionalFlowInfo(initsWhenTrue, initsWhenFalse);
    }

    public boolean cannotBeDefinitelyNullOrNonNull(VariableBinding binding) {
        return this.isPotentiallyUnknown(binding) || this.isPotentiallyNonNull(binding) && this.isPotentiallyNull(binding);
    }

    public boolean cannotBeNull(VariableBinding binding) {
        return this.isDefinitelyNonNull(binding) || this.isProtectedNonNull(binding);
    }

    public boolean canOnlyBeNull(VariableBinding binding) {
        return this.isDefinitelyNull(binding) || this.isProtectedNull(binding);
    }

    public abstract FlowInfo copy();

    public static UnconditionalFlowInfo initial(int maxFieldCount) {
        UnconditionalFlowInfo info = new UnconditionalFlowInfo();
        info.maxFieldCount = maxFieldCount;
        info.constantFieldsMask = 0L;
        return info;
    }

    public abstract FlowInfo initsWhenFalse();

    public abstract FlowInfo initsWhenTrue();

    public abstract boolean isDefinitelyAssigned(VariableBinding var1);

    public abstract boolean isDefinitelyNonNull(VariableBinding var1);

    public abstract boolean isDefinitelyNull(VariableBinding var1);

    public abstract boolean isDefinitelyUnknown(VariableBinding var1);

    public abstract boolean isPotentiallyAssigned(VariableBinding var1);

    public abstract boolean isPotentiallyNonNull(VariableBinding var1);

    public abstract boolean isPotentiallyNull(VariableBinding var1);

    public abstract boolean isPotentiallyUnknown(VariableBinding var1);

    public abstract boolean isProtectedNonNull(VariableBinding var1);

    public abstract boolean isProtectedNull(VariableBinding var1);

    public abstract void markAsComparedEqualToNonNull(VariableBinding var1);

    public abstract void markAsComparedEqualToNull(VariableBinding var1);

    public abstract void markAsDefinitelyNonNull(VariableBinding var1);

    public abstract void markAsDefinitelyNull(VariableBinding var1);

    public abstract void resetNullInfo(VariableBinding var1);

    public abstract void resetNullInfoForFields();

    public abstract void updateConstantFieldsMask(FieldBinding var1);

    public abstract void addConstantFieldsMask(UnconditionalFlowInfo var1);

    public abstract void markPotentiallyUnknownBit(VariableBinding var1);

    public abstract void markPotentiallyNullBit(VariableBinding var1);

    public abstract void markPotentiallyNonNullBit(VariableBinding var1);

    public abstract void markAsDefinitelyAssigned(VariableBinding var1);

    public abstract void markAsDefinitelyUnknown(VariableBinding var1);

    public void markNullStatus(VariableBinding binding, int nullStatus) {
        switch (nullStatus) {
            case 1: {
                this.markAsDefinitelyUnknown(binding);
                break;
            }
            case 2: {
                this.markAsDefinitelyNull(binding);
                break;
            }
            case 4: {
                this.markAsDefinitelyNonNull(binding);
                break;
            }
            default: {
                this.resetNullInfo(binding);
                if ((nullStatus & 8) != 0) {
                    this.markPotentiallyUnknownBit(binding);
                }
                if ((nullStatus & 0x10) != 0) {
                    this.markPotentiallyNullBit(binding);
                }
                if ((nullStatus & 0x20) != 0) {
                    this.markPotentiallyNonNullBit(binding);
                }
                if ((nullStatus & 0x38) != 0) break;
                this.markAsDefinitelyUnknown(binding);
            }
        }
    }

    public int nullStatus(VariableBinding binding) {
        if (this.isDefinitelyUnknown(binding)) {
            return 1;
        }
        if (this.isDefinitelyNull(binding)) {
            return 2;
        }
        if (this.isDefinitelyNonNull(binding)) {
            return 4;
        }
        int status = 0;
        if (this.isPotentiallyUnknown(binding)) {
            status |= 8;
        }
        if (this.isPotentiallyNull(binding)) {
            status |= 0x10;
        }
        if (this.isPotentiallyNonNull(binding)) {
            status |= 0x20;
        }
        if (status > 0) {
            return status;
        }
        return 1;
    }

    public static UnconditionalFlowInfo mergedOptimizedBranches(FlowInfo initsWhenTrue, boolean isOptimizedTrue, FlowInfo initsWhenFalse, boolean isOptimizedFalse, boolean allowFakeDeadBranch) {
        UnconditionalFlowInfo mergedInfo = isOptimizedTrue ? (initsWhenTrue == DEAD_END && allowFakeDeadBranch ? initsWhenFalse.setReachMode(1).unconditionalInits() : initsWhenTrue.addPotentialInitializationsFrom(initsWhenFalse.nullInfoLessUnconditionalCopy()).unconditionalInits()) : (isOptimizedFalse ? (initsWhenFalse == DEAD_END && allowFakeDeadBranch ? initsWhenTrue.setReachMode(1).unconditionalInits() : initsWhenFalse.addPotentialInitializationsFrom(initsWhenTrue.nullInfoLessUnconditionalCopy()).unconditionalInits()) : initsWhenTrue.mergedWith(initsWhenFalse.unconditionalInits()));
        return mergedInfo;
    }

    public static UnconditionalFlowInfo mergedOptimizedBranchesIfElse(FlowInfo initsWhenTrue, boolean isOptimizedTrue, FlowInfo initsWhenFalse, boolean isOptimizedFalse, boolean allowFakeDeadBranch, FlowInfo flowInfo, IfStatement ifStatement, boolean reportDeadCodeInKnownPattern) {
        UnconditionalFlowInfo mergedInfo;
        if (isOptimizedTrue) {
            if (initsWhenTrue == DEAD_END && allowFakeDeadBranch) {
                if (!reportDeadCodeInKnownPattern) {
                    if (ifStatement.elseStatement == null) {
                        mergedInfo = flowInfo.unconditionalInits();
                    } else {
                        mergedInfo = initsWhenFalse.unconditionalInits();
                        if (initsWhenFalse != DEAD_END) {
                            mergedInfo.setReachMode(flowInfo.reachMode());
                        }
                    }
                } else {
                    mergedInfo = initsWhenFalse.setReachMode(1).unconditionalInits();
                }
            } else {
                mergedInfo = initsWhenTrue.addPotentialInitializationsFrom(initsWhenFalse.nullInfoLessUnconditionalCopy()).unconditionalInits();
            }
        } else if (isOptimizedFalse) {
            if (initsWhenFalse == DEAD_END && allowFakeDeadBranch) {
                if (!reportDeadCodeInKnownPattern) {
                    if (ifStatement.thenStatement == null) {
                        mergedInfo = flowInfo.unconditionalInits();
                    } else {
                        mergedInfo = initsWhenTrue.unconditionalInits();
                        if (initsWhenTrue != DEAD_END) {
                            mergedInfo.setReachMode(flowInfo.reachMode());
                        }
                    }
                } else {
                    mergedInfo = initsWhenTrue.setReachMode(1).unconditionalInits();
                }
            } else {
                mergedInfo = initsWhenFalse.addPotentialInitializationsFrom(initsWhenTrue.nullInfoLessUnconditionalCopy()).unconditionalInits();
            }
        } else if ((flowInfo.tagBits & 3) == 0 && (ifStatement.bits & 0x80) != 0 && initsWhenTrue != DEAD_END && initsWhenFalse != DEAD_END) {
            mergedInfo = initsWhenTrue.addPotentialInitializationsFrom(initsWhenFalse.nullInfoLessUnconditionalCopy()).unconditionalInits();
            mergedInfo.definiteInits &= initsWhenFalse.unconditionalCopy().definiteInits;
        } else if ((flowInfo.tagBits & 3) == 0 && (ifStatement.bits & 0x100) != 0 && initsWhenTrue != DEAD_END && initsWhenFalse != DEAD_END) {
            mergedInfo = initsWhenFalse.addPotentialInitializationsFrom(initsWhenTrue.nullInfoLessUnconditionalCopy()).unconditionalInits();
            mergedInfo.definiteInits &= initsWhenTrue.unconditionalCopy().definiteInits;
        } else {
            mergedInfo = initsWhenTrue.mergedWith(initsWhenFalse.unconditionalInits());
        }
        return mergedInfo;
    }

    public int reachMode() {
        return this.tagBits & 3;
    }

    public abstract FlowInfo safeInitsWhenTrue();

    public abstract FlowInfo setReachMode(int var1);

    public abstract UnconditionalFlowInfo mergedWith(UnconditionalFlowInfo var1);

    public abstract UnconditionalFlowInfo nullInfoLessUnconditionalCopy();

    public String toString() {
        if (this == DEAD_END) {
            return "FlowInfo.DEAD_END";
        }
        return super.toString();
    }

    public abstract UnconditionalFlowInfo unconditionalCopy();

    public abstract UnconditionalFlowInfo unconditionalFieldLessCopy();

    public abstract UnconditionalFlowInfo unconditionalInits();

    public abstract UnconditionalFlowInfo unconditionalInitsWithoutSideEffect();

    public abstract void markedAsNullOrNonNullInAssertExpression(VariableBinding var1);

    public abstract boolean isMarkedAsNullOrNonNullInAssertExpression(VariableBinding var1);

    public abstract void resetAssignmentInfo(LocalVariableBinding var1);
}

